/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.entity;

import com.wcohen.ss.AbstractStringDistance;
import com.wcohen.ss.JaroWinkler;
import fr.inrialpes.exmo.ontosim.Measure;
import fr.inrialpes.exmo.ontosim.OntoSimException;
import fr.inrialpes.exmo.ontosim.entity.model.Entity;
import fr.inrialpes.exmo.ontosim.set.MaxCoupling;
import fr.inrialpes.exmo.ontosim.set.SetMeasure;
import fr.inrialpes.exmo.ontosim.string.StringMeasureSS;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Set;

public class EntityLexicalMeasure<E>
implements Measure<Entity<E>> {
    Measure<String> stringMeasure;
    SetMeasure<String> setMeasure;

    public EntityLexicalMeasure() {
        this.stringMeasure = new StringMeasureSS((AbstractStringDistance)new JaroWinkler());
        this.setMeasure = new MaxCoupling<String>(this.stringMeasure, Double.NEGATIVE_INFINITY);
    }

    public EntityLexicalMeasure(SetMeasure<String> measure) {
        this.stringMeasure = measure.getLocalMeasure();
        this.setMeasure = measure;
    }

    public EntityLexicalMeasure(Measure<String> measure) {
        this.stringMeasure = measure;
        this.setMeasure = new MaxCoupling<String>(measure, Double.NEGATIVE_INFINITY);
    }

    @Override
    public double getMeasureValue(Entity<E> e1, Entity<E> e2) {
        if (e1.getURI() != null && e1.getURI().equals(e2.getURI())) {
            return 1.0;
        }
        URI e1URI = e1.getURI();
        URI e2URI = e2.getURI();
        Set<String> e1Labels = e1.getAnnotations(null);
        Set<String> e2Labels = e2.getAnnotations(null);
        double sim = 0.0;
        LinkedHashSet<String> temp = new LinkedHashSet<String>(e1Labels.size() + 1);
        temp.addAll(e1Labels);
        if (e1URI != null && e1URI.getFragment() != null) {
            temp.add(e1URI.getFragment());
        }
        e1Labels = temp;
        temp = new LinkedHashSet(e2Labels.size() + 1);
        temp.addAll(e2Labels);
        if (e2URI != null && e2URI.getFragment() != null) {
            temp.add(e2URI.getFragment());
        }
        e2Labels = temp;
        if (e1Labels.size() == 1 && e2Labels.size() == 1) {
            sim = this.stringMeasure.getSim(e1Labels.iterator().next(), e2Labels.iterator().next());
        } else if (e1Labels.size() > 0 && e2Labels.size() > 0) {
            sim = this.setMeasure.getSim(e1Labels, e2Labels);
        }
        if (sim > 1.0) {
            throw new OntoSimException("Similarity value greater than 1");
        }
        return sim;
    }

    @Override
    public double getDissim(Entity<E> e1, Entity<E> e2) {
        return 1.0 - this.getMeasureValue(e1, e2);
    }

    @Override
    public double getSim(Entity<E> e1, Entity<E> e2) {
        return this.getMeasureValue(e1, e2);
    }

    @Override
    public Measure.TYPES getMType() {
        return Measure.TYPES.similarity;
    }
}

