/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.align;

import fr.inrialpes.exmo.ontosim.Measure;
import fr.inrialpes.exmo.ontosim.NoAlignmentException;
import fr.inrialpes.exmo.ontosim.OntoSimException;
import fr.inrialpes.exmo.ontosim.align.AbstractAlignmentSpaceMeasure;
import fr.inrialpes.exmo.ontowrap.LoadedOntology;
import java.util.Enumeration;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.Cell;

public class AlignmentGlobalSum
extends AbstractAlignmentSpaceMeasure<LoadedOntology<?>> {
    protected double getSumAlign(Alignment a) {
        Enumeration<Cell> enumA = a.getElements();
        double sum = 0.0;
        while (enumA.hasMoreElements()) {
            sum += enumA.nextElement().getStrength();
        }
        return sum;
    }

    public double getMeasureValue(LoadedOntology<?> o1, LoadedOntology<?> o2, Alignment al) throws OntoSimException {
        try {
            this.addAlignment(al);
        }
        catch (AlignmentException aex) {
            throw new OntoSimException("Alignment error", aex);
        }
        if (!this.getAlignments(o1, o2).contains(al)) {
            return 0.0;
        }
        return this.getSumAlign(al);
    }

    @Override
    public double getDissim(LoadedOntology<?> o1, LoadedOntology<?> o2) {
        throw new OntoSimException(this.getClass() + " is not a dissimilarity");
    }

    @Override
    public double getMeasureValue(LoadedOntology<?> o1, LoadedOntology<?> o2) {
        double max = Double.NEGATIVE_INFINITY;
        try {
            for (Alignment al : this.getAlignments(o1, o2)) {
                max = Math.max(max, this.getMeasureValue(o1, o2, al));
            }
            if (max == Double.NEGATIVE_INFINITY) {
                return Double.NaN;
            }
            return max;
        }
        catch (NullPointerException e) {
            throw new NoAlignmentException(o1, o2, e);
        }
    }

    @Override
    public double getSim(LoadedOntology<?> o1, LoadedOntology<?> o2) {
        throw new OntoSimException(this.getClass() + " is not a similarity");
    }

    @Override
    public Measure.TYPES getMType() {
        return Measure.TYPES.other;
    }

    public Measure.TYPES getSubMeasureType() {
        return Measure.TYPES.other;
    }
}

