/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.align;

import fr.inrialpes.exmo.ontosim.Measure;
import fr.inrialpes.exmo.ontosim.OntoSimException;
import fr.inrialpes.exmo.ontosim.align.AbstractAlignmentSpaceMeasure;
import fr.inrialpes.exmo.ontowrap.LoadedOntology;
import fr.inrialpes.exmo.ontowrap.Ontology;
import java.net.URI;
import java.util.Hashtable;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.OntologyNetwork;

public class ASShortestPathMeasure
extends AbstractAlignmentSpaceMeasure<LoadedOntology<?>> {
    private boolean inited = false;
    protected NORM modality = NORM.cardinal;
    protected int size = 0;
    protected int norm = 0;
    protected int diameter = 0;
    protected Hashtable<URI, Integer> index;
    protected int[][] matrix;

    public ASShortestPathMeasure(OntologyNetwork noo) {
        super(noo);
    }

    public ASShortestPathMeasure() {
    }

    @Override
    public Measure.TYPES getMType() {
        return Measure.TYPES.distance;
    }

    public NORM getNormModality() {
        return this.modality;
    }

    public void setNormModality(NORM mod) {
        this.modality = mod;
        this.norm = this.modality == NORM.diameter ? this.diameter + 1 : this.size;
    }

    public int getValue(Ontology o1, Ontology o2) {
        if (!this.inited) {
            this.init();
        }
        try {
            int i = this.index.get(o1.getURI());
            int j = this.index.get(o2.getURI());
            return this.matrix[i][j];
        }
        catch (NullPointerException e) {
            return this.size;
        }
    }

    @Override
    public double getMeasureValue(LoadedOntology<?> o1, LoadedOntology<?> o2) {
        int v = this.getValue(o1, o2);
        if (v == this.size) {
            return 1.0;
        }
        return (double)v / (double)this.norm;
    }

    @Override
    public double getSim(LoadedOntology<?> o1, LoadedOntology<?> o2) {
        return 1.0 - this.getMeasureValue(o1, o2);
    }

    @Override
    public double getDissim(LoadedOntology<?> o1, LoadedOntology<?> o2) {
        return this.getMeasureValue(o1, o2);
    }

    private void init() throws OntoSimException {
        int j;
        int i;
        this.index = new Hashtable();
        int max = 0;
        this.size = 0;
        for (URI ont : this.network.getOntologies()) {
            this.index.put(ont, new Integer(this.size));
            ++this.size;
        }
        this.matrix = new int[this.size][this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            for (int j2 = 0; j2 < this.size; ++j2) {
                this.matrix[i2][j2] = i2 == j2 ? 0 : this.size;
            }
        }
        for (Alignment al : this.network.getAlignments()) {
            max = 1;
            try {
                i = this.index.get(al.getOntology1URI());
                j = this.index.get(al.getOntology2URI());
                this.matrix[i][j] = 1;
            }
            catch (AlignmentException aex) {
                throw new OntoSimException("Cannot find ontology URI", aex);
            }
        }
        boolean modified = true;
        int it = 1;
        while (modified) {
            ++it;
            modified = false;
            for (i = 0; i < this.size; ++i) {
                for (j = 0; j < this.size; ++j) {
                    if (i == j || this.matrix[i][j] <= it) continue;
                    for (int k = 0; k < this.size; ++k) {
                        if (this.matrix[i][k] + this.matrix[k][j] >= this.matrix[i][j]) continue;
                        modified = true;
                        this.matrix[i][j] = this.matrix[i][k] + this.matrix[k][j];
                        if (this.matrix[i][j] <= max) continue;
                        max = this.matrix[i][j];
                    }
                }
            }
        }
        this.diameter = max;
        this.norm = this.modality == NORM.diameter ? this.diameter + 1 : this.size;
        this.inited = true;
    }

    public static enum NORM {
        diameter,
        cardinal;

    }
}

