/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.align;

import fr.inrialpes.exmo.align.impl.BasicAlignment;
import fr.inrialpes.exmo.align.impl.BasicRelation;
import fr.inrialpes.exmo.align.impl.URIAlignment;
import fr.inrialpes.exmo.ontosim.Measure;
import fr.inrialpes.exmo.ontosim.OntoSimException;
import fr.inrialpes.exmo.ontosim.align.AbstractAlignmentSpaceMeasure;
import fr.inrialpes.exmo.ontowrap.LoadedOntology;
import fr.inrialpes.exmo.ontowrap.Ontology;
import fr.inrialpes.exmo.ontowrap.OntologyFactory;
import fr.inrialpes.exmo.ontowrap.OntowrapException;
import java.net.URI;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.OntologyNetwork;
import org.semanticweb.owl.align.Relation;

public abstract class ASAbstractCoverageTraversal
extends AbstractAlignmentSpaceMeasure<LoadedOntology<?>> {
    int globaliterations;
    Hashtable<URI, Set<Set<URI>>> prevtable;
    BasicRelation EquivRel = new BasicRelation("=");
    Hashtable<URI, Set<Hashtable<URI, URI>>> prevtable2;

    public ASAbstractCoverageTraversal(OntologyNetwork noo, int it) {
        super(noo);
        this.globaliterations = it;
    }

    public ASAbstractCoverageTraversal(OntologyNetwork noo) {
        super(noo);
    }

    public ASAbstractCoverageTraversal() {
    }

    @Override
    public Measure.TYPES getMType() {
        return Measure.TYPES.similarity;
    }

    @Override
    public double getMeasureValue(LoadedOntology<?> o1, LoadedOntology<?> o2) {
        return this.getValue(o1, o2);
    }

    @Override
    public double getSim(LoadedOntology<?> o1, LoadedOntology<?> o2) {
        return this.getMeasureValue(o1, o2);
    }

    @Override
    public double getDissim(LoadedOntology<?> o1, LoadedOntology<?> o2) {
        return 1.0 - this.getMeasureValue(o1, o2);
    }

    public double getValue(Ontology o1, Ontology o2) throws OntoSimException {
        Hashtable<URI, URI> topreserve = new Hashtable<URI, URI>();
        int size = 0;
        for (URI u : this.objectsToPreserve(o1)) {
            topreserve.put(u, u);
            ++size;
        }
        if (size == 0) {
            return 0.0;
        }
        int iterations = this.globaliterations == 0 ? size : Math.min(this.globaliterations, size);
        Hashtable<URI, URI> fullresult = new Hashtable<URI, URI>();
        while (iterations > 0) {
            this.prevtable2 = new Hashtable();
            Hashtable<URI, URI> result = this.traverse(new Hashtable<URI, URI>(), size, topreserve, o1.getURI(), o2.getURI());
            fullresult.putAll(result);
            if (result.size() == 0) {
                iterations = 0;
                continue;
            }
            if (topreserve.size() == result.size()) {
                iterations = 0;
                continue;
            }
            this.differs(topreserve, result);
            --iterations;
        }
        return (double)fullresult.size() / (double)size;
    }

    public void differs(Hashtable<URI, URI> tab1, Hashtable<URI, URI> tab2) {
        for (URI k : tab2.keySet()) {
            tab1.remove(k);
        }
    }

    public Hashtable<URI, URI> traverse(Hashtable<URI, URI> max, int size, Hashtable<URI, URI> topreserve, URI current, URI target) {
        if (current.equals(target)) {
            return topreserve;
        }
        if (!this.alreadyVisited(current, topreserve)) {
            if (this.prevtable2.get(current) == null) {
                this.prevtable2.put(current, new HashSet());
            }
            this.prevtable2.get(current).add(topreserve);
            Hashtable<URI, URI> result = max;
            for (Alignment al : this.network.getSourceAlignments(current)) {
                Hashtable<URI, URI> preserved = this.applyAlignment(al, topreserve);
                try {
                    if (preserved.size() <= result.size()) continue;
                    Hashtable<URI, URI> obtained = this.traverse(result, preserved.size(), preserved, al.getOntology2URI(), target);
                    if (obtained.size() == size) {
                        return obtained;
                    }
                    if (obtained.size() <= result.size()) continue;
                    result = obtained;
                }
                catch (AlignmentException aex) {}
            }
            return result;
        }
        return max;
    }

    public boolean alreadyVisited(URI current, Hashtable<URI, URI> topreserve) {
        Set<Hashtable<URI, URI>> previous = this.prevtable2.get(current);
        if (previous == null) {
            return false;
        }
        for (Hashtable<URI, URI> s : previous) {
            if (!this.includedIn(topreserve, s)) continue;
            return true;
        }
        return false;
    }

    public boolean includedIn(Hashtable<URI, URI> sub, Hashtable<URI, URI> sup) {
        for (URI ob : sub.values()) {
            if (sup.containsValue(ob)) continue;
            return false;
        }
        return true;
    }

    public Hashtable<URI, URI> applyAlignment(Alignment al, Hashtable<URI, URI> entities) {
        Hashtable<URI, URI> results = new Hashtable<URI, URI>();
        URIAlignment align = null;
        if (al instanceof URIAlignment) {
            align = (URIAlignment)al;
        } else if (al instanceof BasicAlignment) {
            try {
                align = ((BasicAlignment)al).toURIAlignment();
            }
            catch (AlignmentException aex) {
                // empty catch block
            }
        }
        if (align == null) {
            return results;
        }
        for (URI u : entities.keySet()) {
            URI intermediate = entities.get(u);
            try {
                Set cells = align.getAlignCells1((Object)intermediate);
                if (cells == null) continue;
                for (Cell cell : cells) {
                    if (!cell.getRelation().equals((Relation)this.EquivRel)) continue;
                    results.put(u, cell.getObject2AsURI());
                }
            }
            catch (AlignmentException aex) {
                aex.printStackTrace();
            }
        }
        return results;
    }

    public Set<URI> objectsToPreserve(Ontology o1) throws OntoSimException {
        LoadedOntology onto;
        HashSet<URI> topreserve = new HashSet<URI>();
        if (o1 instanceof LoadedOntology) {
            onto = (LoadedOntology)o1;
        } else {
            try {
                OntologyFactory factory = OntologyFactory.getFactory();
                onto = factory.loadOntology(o1.getURI());
            }
            catch (OntowrapException aex) {
                throw new OntoSimException("Cannot loaded ontology", aex);
            }
        }
        for (Object o : onto.getEntities()) {
            try {
                topreserve.add(((LoadedOntology)o1).getEntityURI(o));
            }
            catch (OntowrapException aex) {
                aex.printStackTrace();
            }
        }
        return topreserve;
    }
}

