/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.aggregation;

import fr.inrialpes.exmo.ontosim.Measure;
import fr.inrialpes.exmo.ontosim.aggregation.AggregationScheme;
import fr.inrialpes.exmo.ontosim.extractor.matching.Matching;
import java.util.HashMap;
import java.util.Map;

public class GenericMean
extends AggregationScheme {
    private static final Map<Type, GenericMean> INSTANCES = new HashMap<Type, GenericMean>();
    public static final Type ARITHMETIC = new Type(){

        @Override
        public final double inversePhi(double x) {
            return x;
        }

        @Override
        public final double phi(double x) {
            return x;
        }
    };
    public static final Type QUADRATIC = new Type(){

        @Override
        public final double inversePhi(double x) {
            return Math.sqrt(x);
        }

        @Override
        public double phi(double x) {
            return x * x;
        }
    };
    public static final Type GEOMETRIC = new Type(){

        @Override
        public final double inversePhi(double x) {
            return Math.exp(x);
        }

        @Override
        public final double phi(double x) {
            return Math.log(x);
        }
    };
    public static final Type HARMONIC = new Type(){

        @Override
        public final double inversePhi(double x) {
            return 1.0 / x;
        }

        @Override
        public final double phi(double x) {
            return 1.0 / x;
        }
    };
    protected Type p;

    public static synchronized GenericMean getInstance(Type t) {
        GenericMean m = INSTANCES.get(t);
        if (m == null) {
            m = new GenericMean(t);
            INSTANCES.put(t, m);
        }
        return m;
    }

    protected GenericMean(Type t) {
        this.p = t;
    }

    protected GenericMean() {
        this(ARITHMETIC);
    }

    @Override
    public final double getValue(double[] vals) {
        double sum = 0.0;
        double sumW = 0.0;
        for (double v : vals) {
            int w = this.weight(v);
            sum += (double)w * this.p.phi(v);
            sumW += (double)w;
        }
        return this.p.inversePhi(sum / sumW);
    }

    protected int weight(double x) {
        return 1;
    }

    @Override
    public final <O> double getValue(Measure<O> measure, Matching<O> matching) {
        double sum = 0.0;
        double sumW = 0.0;
        for (Matching.Entry entry : matching) {
            double v = measure.getMeasureValue(entry.getSource(), entry.getTarget());
            int w = this.weight(v);
            sum += (double)w * this.p.phi(v);
            sumW += (double)w;
        }
        return this.p.inversePhi(sum / sumW);
    }

    public static interface Type {
        public double phi(double var1);

        public double inversePhi(double var1);
    }
}

