/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim;

import fr.inrialpes.exmo.ontosim.Measure;
import fr.inrialpes.exmo.ontosim.vector.CosineVM;
import fr.inrialpes.exmo.ontosim.vector.VectorMeasure;
import fr.inrialpes.exmo.ontosim.vector.model.Document;
import fr.inrialpes.exmo.ontosim.vector.model.DocumentCollection;
import fr.inrialpes.exmo.ontowrap.LoadedOntology;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.snowball.SnowballAnalyzer;

public class VectorSpaceMeasure
implements Measure<LoadedOntology<?>> {
    private Analyzer analyzer = new SnowballAnalyzer("English", StopAnalyzer.ENGLISH_STOP_WORDS);
    protected Map<LoadedOntology<?>, Document> ontologies = new HashMap();
    private DocumentCollection ontIndex = new DocumentCollection();
    protected DocumentCollection.WEIGHT vectorType = DocumentCollection.WEIGHT.TF;
    protected VectorMeasure measure = new CosineVM();

    public VectorSpaceMeasure() {
    }

    public VectorSpaceMeasure(Collection<LoadedOntology<?>> ontologies) {
        for (LoadedOntology<?> ont : ontologies) {
            this.addOntology(ont);
        }
    }

    public VectorSpaceMeasure(VectorMeasure m, DocumentCollection.WEIGHT vectorType) {
        this.measure = m;
        this.vectorType = vectorType;
    }

    public VectorSpaceMeasure(Collection<LoadedOntology<?>> ontologies, VectorMeasure m, DocumentCollection.WEIGHT vectorType) {
        this.measure = m;
        this.vectorType = vectorType;
        for (LoadedOntology<?> ont : ontologies) {
            this.addOntology(ont);
        }
    }

    public final boolean addOntology(LoadedOntology<?> ontology) {
        if (this.ontologies.containsKey(ontology)) {
            return false;
        }
        Document ontDoc = new Document(ontology.getURI().toString());
        for (Object e : ontology.getEntities()) {
            try {
                for (String annot : ontology.getEntityAnnotations(e)) {
                    Vector<String> terms = new Vector<String>();
                    this.analyseString(annot, terms);
                    ontDoc.addOccTerms(terms);
                }
                URI entUri = ontology.getEntityURI(e);
                if (entUri == null || entUri.getFragment() == null) continue;
                ontDoc.addOccTerm(entUri.getFragment());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.ontIndex.add(ontDoc);
        this.ontologies.put(ontology, ontDoc);
        return true;
    }

    public final void addOntologies(Collection<LoadedOntology<?>> ontologies) {
        for (LoadedOntology<?> o : ontologies) {
            this.addOntology(o);
        }
    }

    protected void analyseString(String toAnalyse, Collection<String> words) {
        TokenStream tokenS = this.analyzer.tokenStream("", (Reader)new StringReader(toAnalyse));
        try {
            Token token;
            while ((token = tokenS.next()) != null) {
                String aWord = token.termText();
                words.add(aWord);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public double getSim(LoadedOntology<?> o1, LoadedOntology<?> o2, VectorMeasure m, DocumentCollection.WEIGHT vectorType) {
        this.addOntology(o1);
        this.addOntology(o2);
        return m.getMeasureValue(this.ontIndex.getDocVector(this.ontologies.get(o1), vectorType), this.ontIndex.getDocVector(this.ontologies.get(o2), vectorType));
    }

    public double getDissim(LoadedOntology<?> o1, LoadedOntology<?> o2, VectorMeasure m, DocumentCollection.WEIGHT vectorType) {
        return 1.0 - this.getSim(o1, o2, m, vectorType);
    }

    @Override
    public double getSim(LoadedOntology<?> o1, LoadedOntology<?> o2) {
        return this.getSim(o1, o2, this.measure, this.vectorType);
    }

    @Override
    public double getDissim(LoadedOntology<?> o1, LoadedOntology<?> o2) {
        return this.getDissim(o1, o2, this.measure, this.vectorType);
    }

    @Override
    public double getMeasureValue(LoadedOntology<?> o1, LoadedOntology<?> o2) {
        return this.getSim(o1, o2, this.measure, this.vectorType);
    }

    @Override
    public Measure.TYPES getMType() {
        return this.measure.getMType();
    }

    public DocumentCollection.WEIGHT getVectorType() {
        return this.vectorType;
    }
}

