/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim;

import com.hp.hpl.jena.ontology.OntResource;
import fr.inrialpes.exmo.ontosim.Measure;
import fr.inrialpes.exmo.ontosim.entity.model.Entity;
import fr.inrialpes.exmo.ontosim.entity.model.EntityImpl;
import fr.inrialpes.exmo.ontosim.entity.model.HLEntityFactory;
import fr.inrialpes.exmo.ontosim.set.SetMeasure;
import fr.inrialpes.exmo.ontowrap.HeavyLoadedOntology;
import fr.inrialpes.exmo.ontowrap.LoadedOntology;
import fr.inrialpes.exmo.ontowrap.OntologyFactory;
import fr.inrialpes.exmo.ontowrap.OntowrapException;
import fr.inrialpes.exmo.ontowrap.jena25.JENAOntologyFactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;

public class OntologySpaceMeasure
implements Measure<LoadedOntology<?>> {
    private SetMeasure<Entity<?>> globalMeasure;

    public OntologySpaceMeasure(SetMeasure<Entity<?>> globalMeasure) {
        this.globalMeasure = globalMeasure;
    }

    public Measure<Entity<?>> getLocalMeasure() {
        return this.globalMeasure.getLocalMeasure();
    }

    private Set<Entity<?>> getEntities(LoadedOntology<?> o1) {
        HashSet entities = new HashSet();
        for (Type t : this.globalMeasure.getLocalMeasure().getClass().getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(t instanceof ParameterizedType) || (pt = (ParameterizedType)t).getRawType() != Measure.class || !(pt.getActualTypeArguments()[0] instanceof ParameterizedType) || ((ParameterizedType)pt.getActualTypeArguments()[0]).getActualTypeArguments()[0] != OntResource.class) continue;
            JENAOntologyFactory f = new JENAOntologyFactory();
            try {
                o1 = ((OntologyFactory)f).loadOntology(o1.getFile());
            }
            catch (OntowrapException e) {
                e.printStackTrace();
            }
        }
        if (o1 instanceof HeavyLoadedOntology) {
            for (Object e1 : o1.getEntities()) {
                entities.add(HLEntityFactory.getInstance((HeavyLoadedOntology)o1).createHLEntity(e1));
            }
        } else {
            for (Object e1 : o1.getEntities()) {
                entities.add(new EntityImpl<Object>(o1, e1));
            }
        }
        return entities;
    }

    @Override
    public double getDissim(LoadedOntology<?> o1, LoadedOntology<?> o2) {
        Set<Entity<?>> o1Entities = this.getEntities(o1);
        Set<Entity<?>> o2Entities = this.getEntities(o2);
        return this.globalMeasure.getDissim(o1Entities, o2Entities);
    }

    @Override
    public double getMeasureValue(LoadedOntology<?> o1, LoadedOntology<?> o2) {
        Set<Entity<?>> o1Entities = this.getEntities(o1);
        Set<Entity<?>> o2Entities = this.getEntities(o2);
        return this.globalMeasure.getMeasureValue(o1Entities, o2Entities);
    }

    @Override
    public double getSim(LoadedOntology<?> o1, LoadedOntology<?> o2) {
        Set<Entity<?>> o1Entities = this.getEntities(o1);
        Set<Entity<?>> o2Entities = this.getEntities(o2);
        return this.globalMeasure.getSim(o1Entities, o2Entities);
    }

    @Override
    public Measure.TYPES getMType() {
        return this.globalMeasure.getMType();
    }

    public SetMeasure<Entity<?>> getGlobalMeasure() {
        return this.globalMeasure;
    }
}

