/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import uk.ac.manchester.cs.owl.owlapi.OWLAxiomImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLSubAnnotationPropertyOfAxiomImpl
extends OWLAxiomImpl
implements OWLSubAnnotationPropertyOfAxiom {
    private OWLAnnotationProperty subProperty;
    private OWLAnnotationProperty superProperty;

    public OWLSubAnnotationPropertyOfAxiomImpl(OWLDataFactory dataFactory, OWLAnnotationProperty subProperty, OWLAnnotationProperty superProperty, Collection<? extends OWLAnnotation> annotations) {
        super(dataFactory, annotations);
        this.subProperty = subProperty;
        this.superProperty = superProperty;
    }

    @Override
    public OWLSubAnnotationPropertyOfAxiom getAnnotatedAxiom(Set<OWLAnnotation> annotations) {
        return this.getOWLDataFactory().getOWLSubAnnotationPropertyOfAxiom(this.getSubProperty(), this.getSuperProperty(), this.mergeAnnos(annotations));
    }

    @Override
    public OWLSubAnnotationPropertyOfAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return this.getOWLDataFactory().getOWLSubAnnotationPropertyOfAxiom(this.getSubProperty(), this.getSuperProperty());
    }

    @Override
    public OWLAnnotationProperty getSubProperty() {
        return this.subProperty;
    }

    @Override
    public OWLAnnotationProperty getSuperProperty() {
        return this.superProperty;
    }

    @Override
    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean isLogicalAxiom() {
        return false;
    }

    @Override
    public AxiomType getAxiomType() {
        return AxiomType.SUB_ANNOTATION_PROPERTY_OF;
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLSubAnnotationPropertyOfAxiom other = (OWLSubAnnotationPropertyOfAxiom)object;
        int diff = this.subProperty.compareTo(other.getSubProperty());
        if (diff != 0) {
            return diff;
        }
        return this.superProperty.compareTo(other.getSuperProperty());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OWLSubAnnotationPropertyOfAxiom)) {
            return false;
        }
        OWLSubAnnotationPropertyOfAxiom other = (OWLSubAnnotationPropertyOfAxiom)obj;
        return this.subProperty.equals(other.getSubProperty()) && this.superProperty.equals(other.getSuperProperty());
    }
}

