/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.profiles;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLTypedLiteral;
import org.semanticweb.owlapi.profiles.LexicalNotInLexicalSpace;
import org.semanticweb.owlapi.profiles.OWLProfile;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;
import org.semanticweb.owlapi.profiles.OntologyIRINotAbsolute;
import org.semanticweb.owlapi.profiles.OntologyVersionIRINotAbsolute;
import org.semanticweb.owlapi.profiles.UseOfDefinedDatatypeInDatatypeRestriction;
import org.semanticweb.owlapi.profiles.UseOfIllegalFacetRestriction;
import org.semanticweb.owlapi.profiles.UseOfNonAbsoluteIRI;
import org.semanticweb.owlapi.profiles.UseOfUndeclaredDatatype;
import org.semanticweb.owlapi.util.OWLOntologyWalker;
import org.semanticweb.owlapi.util.OWLOntologyWalkerVisitor;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class OWL2Profile
implements OWLProfile {
    public String getName() {
        return "OWL 2";
    }

    public OWLProfileReport checkOntology(OWLOntology ontology) {
        OWLOntologyWalker walker = new OWLOntologyWalker(ontology.getImportsClosure());
        OWL2ProfileObjectWalker visitor = new OWL2ProfileObjectWalker(walker, ontology.getOWLOntologyManager());
        walker.walkStructure(visitor);
        Set<OWLProfileViolation> pv = visitor.getProfileViolations();
        return new OWLProfileReport(this, pv);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OWL2ProfileObjectWalker
    extends OWLOntologyWalkerVisitor {
        private OWLOntologyManager man;
        private Set<OWLProfileViolation> profileViolations;

        public OWL2ProfileObjectWalker(OWLOntologyWalker walker, OWLOntologyManager man) {
            super(walker);
            this.profileViolations = new HashSet<OWLProfileViolation>();
            this.man = man;
        }

        public Set<OWLProfileViolation> getProfileViolations() {
            return new HashSet<OWLProfileViolation>(this.profileViolations);
        }

        @Override
        public Object visit(OWLOntology ont) {
            OWLOntologyID id = ont.getOntologyID();
            if (!id.isAnonymous()) {
                IRI versionIRI;
                IRI ontologyIRI = id.getOntologyIRI();
                if (!ontologyIRI.isAbsolute()) {
                    this.profileViolations.add(new OntologyIRINotAbsolute(ont));
                }
                if ((versionIRI = id.getVersionIRI()) != null && !versionIRI.isAbsolute()) {
                    this.profileViolations.add(new OntologyVersionIRINotAbsolute(ont));
                }
            }
            return null;
        }

        @Override
        public Object visit(IRI iri) {
            if (!iri.isAbsolute()) {
                this.profileViolations.add(new UseOfNonAbsoluteIRI(this.getCurrentOntology(), this.getCurrentAxiom()));
            }
            return null;
        }

        @Override
        public Object visit(OWLTypedLiteral node) {
            if (node.getDatatype().isBuiltIn() && !node.getDatatype().getBuiltInDatatype().isInLexicalSpace(node.getLiteral())) {
                this.profileViolations.add(new LexicalNotInLexicalSpace(this.getCurrentOntology(), this.getCurrentAxiom(), node));
            }
            return null;
        }

        @Override
        public Object visit(OWLDatatypeRestriction node) {
            for (OWLOntology ont : this.man.getImportsClosure(this.getCurrentOntology())) {
                for (OWLDatatypeDefinitionAxiom ax : ont.getAxioms(AxiomType.DATATYPE_DEFINITION)) {
                    if (!node.getDatatype().equals(ax.getDatatype())) continue;
                    this.profileViolations.add(new UseOfDefinedDatatypeInDatatypeRestriction(this.getCurrentOntology(), this.getCurrentAxiom(), node));
                }
            }
            for (OWLFacetRestriction r : node.getFacetRestrictions()) {
                OWL2Datatype dt = node.getDatatype().getBuiltInDatatype();
                if (dt.getFacets().contains((Object)r.getFacet())) continue;
                this.profileViolations.add(new UseOfIllegalFacetRestriction(this.getCurrentOntology(), this.getCurrentAxiom(), node, r.getFacet()));
            }
            return null;
        }

        @Override
        public Object visit(OWLDatatypeDefinitionAxiom axiom) {
            if (!this.getCurrentOntology().isDeclared(axiom.getDatatype(), true)) {
                this.profileViolations.add(new UseOfUndeclaredDatatype(this.getCurrentOntology(), axiom, axiom.getDatatype()));
            }
            return null;
        }
    }
}

