/*
 * Decompiled with CFR 0.152.
 */
package org.coode.string;

public class EscapeUtils {
    public static String escapeString(String s) {
        if (s.indexOf(34) == -1 && s.indexOf(92) == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + 20);
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '\\') {
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            if (ch == '\"') {
                sb.append('\\');
                sb.append('\"');
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String unescapeString(String s) {
        if (s.indexOf(92) == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '\\') {
                int j = i + 1;
                if (j < s.length()) {
                    char escCh = s.charAt(j);
                    if (escCh != '\\' && escCh != '\"') continue;
                    ++i;
                    sb.append(escCh);
                    continue;
                }
                sb.append('\\');
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String escapeXML(String s) {
        StringBuilder sb = new StringBuilder(s.length() * 2);
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '<') {
                sb.append("&lt;");
                continue;
            }
            if (ch == '>') {
                sb.append("&gt;");
                continue;
            }
            if (ch == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (ch == '&') {
                sb.append("&amp;");
                continue;
            }
            if (ch == '\'') {
                sb.append("&#");
                sb.append(Integer.toString(ch, 10));
                sb.append(';');
                continue;
            }
            if (ch > '\u007f') {
                sb.append("&#");
                sb.append(Integer.toString(ch, 10));
                sb.append(';');
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

