/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdf.rdfxml;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.coode.owlapi.rdf.model.RDFLiteralNode;
import org.coode.owlapi.rdf.model.RDFNode;
import org.coode.owlapi.rdf.model.RDFResourceNode;
import org.coode.owlapi.rdf.model.RDFTriple;
import org.coode.owlapi.rdf.rdfxml.RDFXMLWriter;
import org.coode.owlapi.rdf.renderer.RDFRendererBase;
import org.coode.string.EscapeUtils;
import org.coode.xml.OWLOntologyXMLNamespaceManager;
import org.coode.xml.XMLWriterFactory;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.VersionInfo;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class RDFXMLRenderer
extends RDFRendererBase {
    private RDFXMLWriter writer;
    private Set<RDFResourceNode> pending = new HashSet<RDFResourceNode>();
    private Set<RDFResourceNode> renderedAnonymousNodes = new HashSet<RDFResourceNode>();

    public RDFXMLRenderer(OWLOntologyManager manager, OWLOntology ontology, Writer w) {
        this(manager, ontology, w, manager.getOntologyFormat(ontology));
    }

    public RDFXMLRenderer(OWLOntologyManager manager, OWLOntology ontology, Writer w, OWLOntologyFormat format) {
        super(ontology, manager, format);
        OWLOntologyXMLNamespaceManager nsm = new OWLOntologyXMLNamespaceManager(manager, ontology, format);
        String defaultNamespace = nsm.getDefaultNamespace();
        String base = defaultNamespace.endsWith("#") ? defaultNamespace.substring(0, defaultNamespace.length() - 1) : defaultNamespace;
        this.writer = new RDFXMLWriter(XMLWriterFactory.getInstance().createXMLWriter(w, nsm, base));
        this.prettyPrintedTypes = new HashSet();
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_CLASS.getIRI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_OBJECT_PROPERTY.getIRI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_DATA_PROPERTY.getIRI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY.getIRI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_RESTRICTION.getIRI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_THING.getIRI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_NOTHING.getIRI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_ONTOLOGY.getIRI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_NEGATIVE_DATA_PROPERTY_ASSERTION.getIRI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_NEGATIVE_OBJECT_PROPERTY_ASSERTION.getIRI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_ANNOTATION_PROPERTY.getIRI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_NAMED_INDIVIDUAL.getIRI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.RDFS_DATATYPE.getIRI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_AXIOM.getIRI());
        this.prettyPrintedTypes.add(OWLRDFVocabulary.OWL_ANNOTATION.getIRI());
    }

    protected void beginDocument() throws IOException {
        this.writer.startDocument();
    }

    protected void endDocument() throws IOException {
        this.writer.endDocument();
        this.writer.writeComment(VersionInfo.getVersionInfo().getGeneratedByMessage());
    }

    protected void writeIndividualComments(OWLNamedIndividual ind) throws IOException {
        this.writer.writeComment(EscapeUtils.escapeXML(ind.getIRI().toString()));
    }

    protected void writeClassComment(OWLClass cls) throws IOException {
        this.writer.writeComment(EscapeUtils.escapeXML(cls.getIRI().toString()));
    }

    protected void writeDataPropertyComment(OWLDataProperty prop) throws IOException {
        this.writer.writeComment(EscapeUtils.escapeXML(prop.getIRI().toString()));
    }

    protected void writeObjectPropertyComment(OWLObjectProperty prop) throws IOException {
        this.writer.writeComment(EscapeUtils.escapeXML(prop.getIRI().toString()));
    }

    protected void writeAnnotationPropertyComment(OWLAnnotationProperty prop) throws IOException {
        this.writer.writeComment(EscapeUtils.escapeXML(prop.getIRI().toString()));
    }

    protected void writeDatatypeComment(OWLDatatype datatype) throws IOException {
        this.writer.writeComment(EscapeUtils.escapeXML(datatype.getIRI().toString()));
    }

    protected void writeBanner(String name) throws IOException {
        this.writer.writeComment("\n///////////////////////////////////////////////////////////////////////////////////////\n//\n// " + name + "\n" + "//\n" + "///////////////////////////////////////////////////////////////////////////////////////\n");
    }

    public void render(RDFResourceNode node) throws IOException {
        if (this.pending.contains(node)) {
            return;
        }
        this.pending.add(node);
        TreeSet<RDFTriple> triples = new TreeSet<RDFTriple>(new RDFRendererBase.TripleComparator());
        triples.addAll(this.getGraph().getTriplesForSubject(node));
        RDFTriple candidatePrettyPrintTypeTriple = null;
        for (RDFTriple triple : triples) {
            IRI propertyIRI = triple.getProperty().getIRI();
            if (!propertyIRI.equals(OWLRDFVocabulary.RDF_TYPE.getIRI()) || triple.getObject().isAnonymous()) continue;
            if (OWLRDFVocabulary.BUILT_IN_VOCABULARY_IRIS.contains(triple.getObject().getIRI())) {
                if (!this.prettyPrintedTypes.contains(triple.getObject().getIRI())) continue;
                candidatePrettyPrintTypeTriple = triple;
                continue;
            }
            candidatePrettyPrintTypeTriple = triple;
        }
        if (candidatePrettyPrintTypeTriple == null) {
            this.writer.writeStartElement(OWLRDFVocabulary.RDF_DESCRIPTION.getIRI());
        } else {
            this.writer.writeStartElement(candidatePrettyPrintTypeTriple.getObject().getIRI());
        }
        if (!node.isAnonymous()) {
            this.writer.writeAboutAttribute(node.getIRI());
        }
        for (RDFTriple triple : triples) {
            if (candidatePrettyPrintTypeTriple != null && candidatePrettyPrintTypeTriple.equals(triple)) continue;
            this.writer.writeStartElement(triple.getProperty().getIRI());
            RDFNode objectNode = triple.getObject();
            if (!objectNode.isLiteral()) {
                RDFResourceNode objectRes = (RDFResourceNode)objectNode;
                if (objectRes.isAnonymous()) {
                    if (this.isObjectList(objectRes)) {
                        this.writer.writeParseTypeAttribute();
                        ArrayList<RDFNode> list = new ArrayList<RDFNode>();
                        this.toJavaList(objectRes, list);
                        for (RDFNode n : list) {
                            if (n.isAnonymous()) {
                                this.render((RDFResourceNode)n);
                                continue;
                            }
                            if (n.isLiteral()) {
                                RDFLiteralNode litNode = (RDFLiteralNode)n;
                                this.writer.writeStartElement(OWLRDFVocabulary.RDFS_LITERAL.getIRI());
                                if (litNode.getDatatype() != null) {
                                    this.writer.writeDatatypeAttribute(litNode.getDatatype());
                                } else if (litNode.getLang() != null) {
                                    this.writer.writeLangAttribute(litNode.getLang());
                                }
                                this.writer.writeTextContent(litNode.getLiteral());
                                this.writer.writeEndElement();
                                continue;
                            }
                            this.writer.writeStartElement(OWLRDFVocabulary.RDF_DESCRIPTION.getIRI());
                            this.writer.writeAboutAttribute(n.getIRI());
                            this.writer.writeEndElement();
                        }
                    } else {
                        this.render(objectRes);
                    }
                } else {
                    this.writer.writeResourceAttribute(objectRes.getIRI());
                }
            } else {
                RDFLiteralNode rdfLiteralNode = (RDFLiteralNode)objectNode;
                if (rdfLiteralNode.getDatatype() != null) {
                    this.writer.writeDatatypeAttribute(rdfLiteralNode.getDatatype());
                } else if (rdfLiteralNode.getLang() != null) {
                    this.writer.writeLangAttribute(rdfLiteralNode.getLang());
                }
                this.writer.writeTextContent(rdfLiteralNode.getLiteral());
            }
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
        this.pending.remove(node);
    }
}

