/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.snowball;

import java.io.IOException;
import java.lang.reflect.Method;
import net.sf.snowball.SnowballProgram;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public class SnowballFilter
extends TokenFilter {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private SnowballProgram stemmer;
    private Method stemMethod;

    public SnowballFilter(TokenStream in, String name) {
        super(in);
        try {
            Class<?> stemClass = Class.forName("net.sf.snowball.ext." + name + "Stemmer");
            this.stemmer = (SnowballProgram)stemClass.newInstance();
            this.stemMethod = stemClass.getMethod("stem", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public final Token next() throws IOException {
        Token token = this.input.next();
        if (token == null) {
            return null;
        }
        this.stemmer.setCurrent(token.termText());
        try {
            this.stemMethod.invoke((Object)this.stemmer, EMPTY_ARGS);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        Token newToken = new Token(this.stemmer.getCurrent(), token.startOffset(), token.endOffset(), token.type());
        newToken.setPositionIncrement(token.getPositionIncrement());
        return newToken;
    }
}

