/*
 * Decompiled with CFR 0.152.
 */
package edu.unika.aifb.rdf.mainmemory;

import edu.unika.aifb.rdf.api.model.ModelException;
import edu.unika.aifb.rdf.api.model.NodeFactory;
import edu.unika.aifb.rdf.api.model.Statement;
import edu.unika.aifb.rdf.mainmemory.ModelImpl;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TransactionableModelImpl
extends ModelImpl {
    protected List m_rollbackLog;

    public TransactionableModelImpl(NodeFactory nodeFactory) {
        super(nodeFactory);
    }

    public void add(Statement statement) throws ModelException {
        this.nonTransactionalAdd(statement);
        if (this.m_rollbackLog != null) {
            this.m_rollbackLog.add(0, new RemoveStatementRollbackLogEntry(statement));
        }
    }

    public void remove(Statement statement) throws ModelException {
        this.nonTransactionalRemove(statement);
        if (this.m_rollbackLog != null) {
            this.m_rollbackLog.add(0, new AddStatementRollbackLogEntry(statement));
        }
    }

    public boolean supportsTransactions() {
        return true;
    }

    public void setAutocommit(boolean bl) throws ModelException {
        if (bl) {
            if (this.m_rollbackLog != null && this.m_rollbackLog.size() != 0) {
                throw new ModelException("Autocommit mode cannot be changed during a transaction.");
            }
            this.m_rollbackLog = null;
        } else {
            this.m_rollbackLog = new LinkedList();
        }
    }

    public boolean isAutocommit() {
        return this.m_rollbackLog == null;
    }

    public void commit() throws ModelException {
        if (this.m_rollbackLog != null) {
            this.m_rollbackLog.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws ModelException {
        if (this.m_rollbackLog != null) {
            try {
                Iterator iterator = this.m_rollbackLog.iterator();
                while (iterator.hasNext()) {
                    RollbackLogEntry rollbackLogEntry = (RollbackLogEntry)iterator.next();
                    rollbackLogEntry.apply(this);
                }
            }
            finally {
                this.m_rollbackLog.clear();
            }
        }
    }

    protected void nonTransactionalAdd(Statement statement) throws ModelException {
        super.add(statement);
    }

    protected void nonTransactionalRemove(Statement statement) throws ModelException {
        super.remove(statement);
    }

    protected static class AddStatementRollbackLogEntry
    extends RollbackLogEntry {
        public AddStatementRollbackLogEntry(Statement statement) {
            super(statement);
        }

        public void apply(TransactionableModelImpl transactionableModelImpl) throws ModelException {
            transactionableModelImpl.nonTransactionalAdd(this.m_statement);
        }
    }

    protected static class RemoveStatementRollbackLogEntry
    extends RollbackLogEntry {
        public RemoveStatementRollbackLogEntry(Statement statement) {
            super(statement);
        }

        public void apply(TransactionableModelImpl transactionableModelImpl) throws ModelException {
            transactionableModelImpl.nonTransactionalRemove(this.m_statement);
        }
    }

    protected static abstract class RollbackLogEntry {
        protected Statement m_statement;

        public RollbackLogEntry(Statement statement) {
            this.m_statement = statement;
        }

        public abstract void apply(TransactionableModelImpl var1) throws ModelException;
    }
}

