/*
 * Decompiled with CFR 0.152.
 */
package edu.unika.aifb.rdf.mainmemory;

import edu.unika.aifb.rdf.api.model.Literal;
import edu.unika.aifb.rdf.api.model.ModelException;
import edu.unika.aifb.rdf.api.model.RDFNode;
import edu.unika.aifb.rdf.api.model.Resource;
import edu.unika.aifb.rdf.api.model.Statement;

public class StatementImpl
implements Statement {
    protected Resource m_subject;
    protected Resource m_predicate;
    protected RDFNode m_object;
    protected int m_hashCode;

    public StatementImpl(Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
        this.m_subject = resource;
        this.m_predicate = resource2;
        this.m_object = rDFNode;
        this.m_hashCode = (resource.hashCode() * 7 + resource2.hashCode()) * 7 + rDFNode.hashCode();
    }

    protected StatementImpl(Resource resource, Resource resource2, RDFNode rDFNode, int n) throws ModelException {
        this.m_subject = resource;
        this.m_predicate = resource2;
        this.m_object = rDFNode;
        this.m_hashCode = n;
    }

    public Resource subject() {
        return this.m_subject;
    }

    public Resource predicate() {
        return this.m_predicate;
    }

    public RDFNode object() {
        return this.m_object;
    }

    public String toString() {
        return "triple(" + this.m_subject.toString() + ", " + this.m_predicate.toString() + ", " + (this.m_object instanceof Literal ? "'" + this.m_object.toString() + "'" : this.m_object.toString()) + ")";
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public boolean match(Resource resource, Resource resource2, RDFNode rDFNode) {
        if (resource != null && !this.m_subject.equals(resource)) {
            return false;
        }
        if (resource2 != null && !this.m_predicate.equals(resource2)) {
            return false;
        }
        return rDFNode == null || this.m_object.equals(rDFNode);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Statement)) {
            return false;
        }
        try {
            Statement statement = (Statement)object;
            return this.m_subject.equals(statement.subject()) && this.m_predicate.equals(statement.predicate()) && this.m_object.equals(statement.object());
        }
        catch (ModelException modelException) {
            return false;
        }
    }
}

