/*
 * Decompiled with CFR 0.152.
 */
package edu.unika.aifb.rdf.mainmemory;

import edu.unika.aifb.rdf.api.model.Model;
import edu.unika.aifb.rdf.api.model.ModelException;
import edu.unika.aifb.rdf.api.model.NodeFactory;
import edu.unika.aifb.rdf.api.model.RDFNode;
import edu.unika.aifb.rdf.api.model.Resource;
import edu.unika.aifb.rdf.api.model.Statement;
import edu.unika.aifb.rdf.api.model.StatementAlreadyExists;
import edu.unika.aifb.rdf.api.model.StatementDoesntExist;
import edu.unika.aifb.rdf.mainmemory.AbstractModel;
import edu.unika.aifb.rdf.mainmemory.FindIndex;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ModelImpl
extends AbstractModel {
    protected String m_logicalURI;
    protected String m_physicalURI;
    protected FindIndex m_findIndex;
    protected Map m_parameters = new HashMap();
    protected int m_size;

    public ModelImpl(NodeFactory nodeFactory) {
        super(nodeFactory);
        this.m_findIndex = new FindIndex();
    }

    public boolean isPersistent() {
        return false;
    }

    public String getLogicalURI() throws ModelException {
        return this.m_logicalURI;
    }

    public void setLogicalURI(String string) throws ModelException {
        this.m_logicalURI = string;
    }

    public String getPhysicalURI() throws ModelException {
        return this.m_physicalURI;
    }

    public void setPhysicalURI(String string) throws ModelException {
        this.m_physicalURI = string;
    }

    public void add(Resource resource, Resource resource2, String string) throws ModelException {
        this.add(resource, resource2, this.m_nodeFactory.createLiteral(string));
    }

    public void add(Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
        this.add(this.m_nodeFactory.createStatement(resource, resource2, rDFNode));
    }

    public void add(Statement statement) throws ModelException {
        if (this.contains(statement)) {
            throw new StatementAlreadyExists(statement);
        }
        this.m_findIndex.addLookup(statement);
        ++this.m_size;
    }

    public void remove(Statement statement) throws ModelException {
        if (!this.contains(statement)) {
            throw new StatementDoesntExist(statement);
        }
        this.m_findIndex.removeLookup(statement);
        --this.m_size;
    }

    public String getUniqueResourceURI(String string) throws ModelException {
        int n = 1;
        String string2;
        Resource resource;
        while (this.find(resource = this.m_nodeFactory.createResource(string2 = string + n), null, null).size() != 0 || this.find(null, resource, null).size() != 0 || this.find(null, null, resource).size() != 0) {
            ++n;
        }
        return string2;
    }

    public String getLabel() throws ModelException {
        return this.getURI();
    }

    public boolean supportsTransactions() {
        return false;
    }

    public void setAutocommit(boolean bl) throws ModelException {
        if (!bl) {
            throw new ModelException("Non-autocommit mode is not supproted by this model.");
        }
    }

    public boolean isAutocommit() {
        return true;
    }

    public void commit() throws ModelException {
        throw new ModelException("Transactions are not supproted by this model.");
    }

    public void rollback() throws ModelException {
        throw new ModelException("Transactions are not supproted by this model.");
    }

    public String getURI() throws ModelException {
        return this.m_logicalURI;
    }

    public String toString() {
        try {
            return "Model[" + this.getURI() + " of size " + this.size() + "]";
        }
        catch (ModelException modelException) {
            return "Error";
        }
    }

    public int thisSize() {
        return this.m_size;
    }

    public boolean thisIsEmpty() {
        return this.m_size == 0;
    }

    public Iterator thisIterator() throws ModelException {
        return this.m_findIndex.multiget(null, null, null);
    }

    public boolean thisContains(Statement statement) throws ModelException {
        return this.m_findIndex.contains(statement.subject(), statement.predicate(), statement.object());
    }

    public boolean thisContains(Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
        if (this.thisIsEmpty()) {
            return false;
        }
        if (resource == null && resource2 == null && rDFNode == null) {
            return !this.thisIsEmpty();
        }
        return this.m_findIndex.contains(resource, resource2, rDFNode);
    }

    public void thisFind(Resource resource, Resource resource2, RDFNode rDFNode, Model model) throws ModelException {
        if (this.thisIsEmpty()) {
            return;
        }
        Iterator iterator = this.m_findIndex.multiget(resource, resource2, rDFNode);
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            if (!statement.match(resource, resource2, rDFNode)) continue;
            model.add(statement);
        }
    }

    public String getAttribute(String string) throws ModelException {
        return (String)this.m_parameters.get(string);
    }

    public void setAttribute(String string, String string2) throws ModelException {
        if (string2 == null) {
            this.m_parameters.remove(string);
        } else {
            this.m_parameters.put(string, string2);
        }
    }

    public Map getAttributes() throws ModelException {
        return Collections.unmodifiableMap(this.m_parameters);
    }
}

