/*
 * Decompiled with CFR 0.152.
 */
package edu.unika.aifb.rdf.mainmemory;

import edu.unika.aifb.rdf.api.model.ModelException;
import edu.unika.aifb.rdf.api.model.RDFNode;
import edu.unika.aifb.rdf.api.model.Resource;
import edu.unika.aifb.rdf.api.model.Statement;
import edu.unika.aifb.rdf.mainmemory.ResourceImpl;
import edu.unika.aifb.rdf.mainmemory.StatementImpl;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class FindIndex {
    protected static final ResourceImpl MAX_RES = new ResourceImpl("<MAX>");
    protected static final Comparator s_spoComparator = new SPOComparator();
    protected static final Comparator s_opComparator = new OPComparator();
    protected static final Comparator s_pComparator = new PComparator();
    protected SortedMap m_spoIndex = new TreeMap(s_spoComparator);
    protected SortedMap m_opIndex = new TreeMap(s_opComparator);
    protected SortedMap m_pIndex = new TreeMap(s_pComparator);

    protected void put(Map map, Statement statement) {
        Object v = map.get(statement);
        if (v == null) {
            map.put(statement, statement);
        } else if (v instanceof Statement) {
            HashSet<Object> hashSet = new HashSet<Object>();
            hashSet.add(v);
            hashSet.add(statement);
            map.put(statement, hashSet);
        } else {
            ((Set)v).add(statement);
        }
    }

    protected void remove(Map map, Statement statement) {
        Object v = map.get(statement);
        if (v == null) {
            return;
        }
        if (v instanceof Statement) {
            map.remove(statement);
        } else {
            Set set = (Set)v;
            set.remove(statement);
            if (set.size() == 0) {
                map.remove(statement);
            }
        }
    }

    public void addLookup(Statement statement) {
        this.put(this.m_spoIndex, statement);
        this.put(this.m_opIndex, statement);
        this.put(this.m_pIndex, statement);
    }

    public void removeLookup(Statement statement) {
        this.remove(this.m_spoIndex, statement);
        this.remove(this.m_opIndex, statement);
        this.remove(this.m_pIndex, statement);
    }

    public Iterator multiget(Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
        StatementImpl statementImpl = new StatementImpl(resource, resource2, rDFNode, Integer.MIN_VALUE);
        if (resource == null) {
            if (rDFNode == null) {
                return new PrefixIterator(this.m_pIndex, statementImpl);
            }
            return new PrefixIterator(this.m_opIndex, statementImpl);
        }
        return new PrefixIterator(this.m_spoIndex, statementImpl);
    }

    public boolean contains(Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
        SortedMap sortedMap = resource == null ? (rDFNode == null ? this.m_pIndex : this.m_opIndex) : this.m_spoIndex;
        StatementImpl statementImpl = new StatementImpl(resource, resource2, rDFNode, Integer.MIN_VALUE);
        SortedMap sortedMap2 = sortedMap.tailMap(statementImpl);
        if (sortedMap2.isEmpty()) {
            return false;
        }
        Statement statement = sortedMap2.firstKey();
        return statement.match(resource, resource2, rDFNode);
    }

    protected static class PrefixIterator
    implements Iterator {
        protected Iterator m_outer;
        protected Object m_current;
        protected Iterator m_inner;

        public PrefixIterator(SortedMap sortedMap, Statement statement) throws ModelException {
            if (statement.subject() != null && statement.predicate() != null && statement.object() != null) {
                Object v = sortedMap.get(statement);
                HashSet hashSet = new HashSet();
                hashSet.add(v);
                this.m_outer = hashSet.iterator();
            } else {
                StatementImpl statementImpl = new StatementImpl(this.limitResource(statement.subject()), this.limitResource(statement.predicate()), this.limitNode(statement.object()));
                SortedMap sortedMap2 = sortedMap.subMap(statement, statementImpl);
                this.m_outer = sortedMap2.values().iterator();
            }
            this.step();
        }

        protected Resource limitResource(Resource resource) {
            return resource == null ? MAX_RES : resource;
        }

        protected RDFNode limitNode(RDFNode rDFNode) {
            return rDFNode == null ? MAX_RES : rDFNode;
        }

        protected void step() {
            this.m_current = null;
            if (this.m_inner == null || !this.m_inner.hasNext()) {
                this.m_inner = null;
                if (this.m_outer.hasNext()) {
                    Object e = this.m_outer.next();
                    if (e instanceof Statement) {
                        this.m_current = e;
                    } else if (e instanceof Set) {
                        this.m_inner = ((Set)e).iterator();
                        this.m_current = this.m_inner.next();
                    }
                }
            } else {
                this.m_current = this.m_inner.next();
            }
        }

        public boolean hasNext() {
            return this.m_current != null;
        }

        public Object next() {
            if (this.m_current == null) {
                throw new NoSuchElementException();
            }
            Object object = this.m_current;
            this.step();
            return object;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class PComparator
    extends AbstractComparator {
        protected PComparator() {
        }

        public int compare(Object object, Object object2) {
            Statement statement = (Statement)object;
            Statement statement2 = (Statement)object2;
            try {
                Resource resource = statement.predicate();
                Resource resource2 = statement2.predicate();
                int n = this.compareNodes(resource, resource2);
                if (n == 0) {
                    n = statement2.subject() == MAX_RES ? -1 : (statement.subject() == MAX_RES ? 1 : 0);
                }
                return n;
            }
            catch (ModelException modelException) {
                return 0;
            }
        }
    }

    protected static class OPComparator
    extends AbstractComparator {
        protected OPComparator() {
        }

        public int compare(Object object, Object object2) {
            Statement statement = (Statement)object;
            Statement statement2 = (Statement)object2;
            try {
                RDFNode rDFNode = statement.object();
                RDFNode rDFNode2 = statement2.object();
                int n = this.compareNodes(rDFNode, rDFNode2);
                if (n == 0 && (n = this.compareNodes(rDFNode = statement.predicate(), rDFNode2 = statement2.predicate())) == 0) {
                    n = statement2.subject() == MAX_RES ? -1 : (statement.subject() == MAX_RES ? 1 : 0);
                }
                return n;
            }
            catch (ModelException modelException) {
                return 0;
            }
        }
    }

    protected static class SPOComparator
    extends AbstractComparator {
        protected SPOComparator() {
        }

        public int compare(Object object, Object object2) {
            Statement statement = (Statement)object;
            Statement statement2 = (Statement)object2;
            try {
                Resource resource = statement.subject();
                Resource resource2 = statement2.subject();
                int n = this.compareNodes(resource, resource2);
                if (n == 0 && (n = this.compareNodes(resource = statement.predicate(), resource2 = statement2.predicate())) == 0) {
                    n = this.compareNodes(statement.object(), statement2.object());
                }
                return n;
            }
            catch (ModelException modelException) {
                return 0;
            }
        }
    }

    protected static abstract class AbstractComparator
    implements Comparator {
        protected AbstractComparator() {
        }

        protected int compareNodes(RDFNode rDFNode, RDFNode rDFNode2) {
            int n;
            if (rDFNode == rDFNode2) {
                return 0;
            }
            if (rDFNode == null || rDFNode2 == MAX_RES) {
                return -1;
            }
            if (rDFNode2 == null || rDFNode == MAX_RES) {
                return 1;
            }
            int n2 = rDFNode.hashCode();
            if (n2 < (n = rDFNode2.hashCode())) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            try {
                return rDFNode.getLabel().compareTo(rDFNode2.getLabel());
            }
            catch (ModelException modelException) {
                return 0;
            }
        }
    }
}

