/*
 * Decompiled with CFR 0.152.
 */
package edu.unika.aifb.rdf.api.util;

import edu.unika.aifb.rdf.api.model.Model;
import edu.unika.aifb.rdf.api.model.ModelException;
import edu.unika.aifb.rdf.api.model.NodeFactory;
import edu.unika.aifb.rdf.api.model.RDFNode;
import edu.unika.aifb.rdf.api.model.Resource;
import edu.unika.aifb.rdf.api.model.Statement;
import java.util.HashSet;
import java.util.Iterator;

public class SetOperations {
    public static void copy(Model model, Model model2) throws ModelException {
        SetOperations.subtract(model2, model2);
        SetOperations.unite(model2, model);
    }

    public static void unite(Model model, Model model2) throws ModelException {
        NodeFactory nodeFactory = model.getNodeFactory();
        Iterator iterator = model2.iterator();
        while (iterator.hasNext()) {
            RDFNode rDFNode;
            Resource resource;
            Statement statement = (Statement)iterator.next();
            Resource resource2 = nodeFactory.createResource(statement.subject().getURI());
            if (model.contains(statement = nodeFactory.createStatement(resource2, resource = nodeFactory.createResource(statement.predicate().getURI()), rDFNode = (rDFNode = statement.object()) instanceof Resource ? nodeFactory.createResource(((Resource)rDFNode).getURI()) : nodeFactory.createLiteral(rDFNode.getLabel())))) continue;
            model.add(statement);
        }
    }

    public static void subtract(Model model, Model model2) throws ModelException {
        Iterator iterator = model2.iterator();
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            if (!model.contains(statement)) continue;
            model.remove(statement);
        }
    }

    public static void intersect(Model model, Model model2) throws ModelException {
        HashSet hashSet = new HashSet();
        Iterator iterator = model.iterator();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        Iterator iterator2 = hashSet.iterator();
        while (iterator2.hasNext()) {
            Statement statement = (Statement)iterator2.next();
            if (model2.contains(statement)) continue;
            model.remove(statement);
        }
    }

    public static Model union(Model model, Model model2, Model model3) throws ModelException {
        SetOperations.subtract(model3, model3);
        SetOperations.unite(model3, model);
        SetOperations.unite(model3, model2);
        return model3;
    }

    public static Model difference(Model model, Model model2, Model model3) throws ModelException {
        SetOperations.subtract(model3, model3);
        SetOperations.unite(model3, model);
        SetOperations.subtract(model3, model2);
        return model3;
    }

    public static Model intersection(Model model, Model model2, Model model3) throws ModelException {
        SetOperations.subtract(model3, model3);
        NodeFactory nodeFactory = model3.getNodeFactory();
        Iterator iterator = model.iterator();
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            if (!model2.contains(statement)) continue;
            Resource resource = nodeFactory.createResource(statement.subject().getURI());
            Resource resource2 = nodeFactory.createResource(statement.predicate().getURI());
            RDFNode rDFNode = statement.object();
            rDFNode = rDFNode instanceof Resource ? nodeFactory.createResource(((Resource)rDFNode).getURI()) : nodeFactory.createLiteral(rDFNode.getLabel());
            statement = nodeFactory.createStatement(resource, resource2, rDFNode);
            model3.add(statement);
        }
        return model3;
    }
}

