/*
 * Decompiled with CFR 0.152.
 */
package edu.unika.aifb.rdf.api.syntax;

import edu.unika.aifb.rdf.api.util.RDFConstants;
import edu.unika.aifb.rdf.api.util.RDFUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RDFWriter
implements RDFConstants {
    public static final String DEFAULT_ENCODING = "UTF-8";
    protected static final char USE_ANY_QUOTE = '\u0000';
    protected static final char USE_CDATA = '\u0001';
    protected static final int MAX_ALLOWED_ABBREVIATED_LENGTH = 60;
    protected static final String INDENTATION = "    ";
    protected static final String OPAQUE_URI = "opaque:uri";
    protected Map m_defaultNamespaces = new HashMap();
    protected Map m_namespaces;
    protected int m_nextAutomaticPrefixIndex;
    protected PrintWriter m_out;
    protected String m_rdfIDElementText;
    protected String m_rdfAboutElementText;
    protected String m_rdfResourceElementText;
    protected String m_rdfParseTypeText;
    protected String m_rdfDatatypeText;
    protected String m_rdfElementText;
    protected URI m_baseURI;
    protected URI m_physicalURI;
    protected String m_currentSubject;
    protected RDFStatement m_groupTypeStatement;
    protected List m_attributeStatements;
    protected Set m_attributePredicates;
    protected List m_contentStatements;

    public RDFWriter() {
        this.addNamespacePrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.addNamespacePrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.addNamespacePrefix("kaon", "http://kaon.semanticweb.org/2001/11/kaon-lexical#");
    }

    public PrintWriter getOut() {
        return this.m_out;
    }

    public void addNamespacePrefix(String string, String string2) {
        this.m_defaultNamespaces.put(string2, string);
    }

    public void prepareNamespaceCollection() {
        this.m_namespaces = new HashMap();
        this.m_namespaces.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", this.m_defaultNamespaces.get("http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
    }

    public void startSerialization(Writer writer, String string, String string2, String string3) throws IOException {
        this.m_rdfElementText = this.getElementText("http://www.w3.org/1999/02/22-rdf-syntax-ns#RDF");
        this.m_rdfIDElementText = this.getElementText("http://www.w3.org/1999/02/22-rdf-syntax-ns#ID");
        this.m_rdfAboutElementText = this.getElementText("http://www.w3.org/1999/02/22-rdf-syntax-ns#about");
        this.m_rdfResourceElementText = this.getElementText("http://www.w3.org/1999/02/22-rdf-syntax-ns#resource");
        this.m_rdfParseTypeText = this.getElementText("http://www.w3.org/1999/02/22-rdf-syntax-ns#parseType");
        this.m_rdfDatatypeText = this.getElementText("http://www.w3.org/1999/02/22-rdf-syntax-ns#datatype");
        this.m_out = new PrintWriter(writer);
        try {
            String string4;
            int n;
            this.m_physicalURI = new URI(string);
            if (!this.m_physicalURI.isOpaque() && (n = (string4 = this.m_physicalURI.getPath()).lastIndexOf(47)) != -1) {
                String string5 = string4.substring(0, n + 1);
                this.m_physicalURI = new URI(this.m_physicalURI.getScheme(), this.m_physicalURI.getUserInfo(), this.m_physicalURI.getHost(), this.m_physicalURI.getPort(), string5, this.m_physicalURI.getQuery(), this.m_physicalURI.getFragment());
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            IOException iOException = new IOException("Invalid physical URI '" + string + "'");
            iOException.initCause(uRISyntaxException);
            throw iOException;
        }
        try {
            this.m_baseURI = string2 == null ? new URI(OPAQUE_URI) : new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            IOException iOException = new IOException("Invalid physical URI '" + string2 + "'");
            iOException.initCause(uRISyntaxException);
            throw iOException;
        }
        this.m_out.println("<?xml version='1.0' encoding='" + string3 + "'?>");
        this.m_out.println("<!DOCTYPE " + this.m_rdfElementText + " [");
        this.writeEntityDeclarations();
        this.m_out.println("]>");
    }

    public void startRDFContents() throws IOException {
        this.m_out.println();
        this.m_out.print("<" + this.m_rdfElementText);
        String string = this.m_baseURI.toString();
        if (!OPAQUE_URI.equals(string)) {
            this.m_out.print(" xml:base=\"" + string + "\"");
        }
        this.writeNamespaceDeclarations();
        this.m_out.println(">");
        this.m_out.println();
        this.m_groupTypeStatement = null;
        this.m_attributeStatements = new ArrayList();
        this.m_attributePredicates = new HashSet();
        this.m_contentStatements = new ArrayList();
        this.m_currentSubject = null;
    }

    public void finishRDFContents() throws IOException {
        this.writeGroup();
        this.m_out.println();
        this.m_out.println("</" + this.m_rdfElementText + ">");
    }

    public void cleanUp() throws IOException {
        this.m_namespaces = null;
        this.m_currentSubject = null;
        this.m_groupTypeStatement = null;
        this.m_attributeStatements = null;
        this.m_attributePredicates = null;
        this.m_contentStatements = null;
        this.m_rdfResourceElementText = null;
        if (this.m_out != null) {
            this.m_out.flush();
            this.m_out = null;
        }
    }

    public void writeInclusion(String string, String string2) throws IOException {
        try {
            if (string != null || string2 != null) {
                this.m_out.print("<?include-rdf");
                if (string != null) {
                    this.m_out.print(" logicalURI=\"");
                    this.m_out.print(string);
                    this.m_out.print("\"");
                }
                if (string2 != null) {
                    this.m_out.print(" physicalURI=\"");
                    String string3 = this.m_physicalURI.relativize(new URI(string2)).toString();
                    this.m_out.print(string3);
                    this.m_out.print("\"");
                }
                this.m_out.println("?>");
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            IOException iOException = new IOException("Invalid physical URI '" + string2 + "'");
            iOException.initCause(uRISyntaxException);
            throw iOException;
        }
    }

    public void writeModelAttribute(String string, String string2) {
        this.m_out.print("<?model-attribute key=\"");
        this.m_out.print(string);
        this.m_out.print("\" value=\"");
        this.m_out.print(string2);
        this.m_out.println("\"?>");
    }

    public void writeModelAttributes(Map map) {
        if (!map.isEmpty()) {
            this.m_out.println();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)map.get(string);
                this.writeModelAttribute(string, string2);
            }
        }
    }

    protected void writeEntityDeclarations() {
        Iterator iterator = this.m_namespaces.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.m_namespaces.get(string);
            this.m_out.println("    <!ENTITY " + string2 + " '" + string + "'>");
        }
    }

    protected void writeNamespaceDeclarations() {
        Iterator iterator = this.m_namespaces.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.m_namespaces.get(string);
            this.m_out.println();
            this.m_out.print("    xmlns:" + string2 + "=\"&" + string2 + ";\"");
        }
    }

    public void writeStatement(String string, String string2, String string3, String string4, String string5, boolean bl) throws IOException {
        RDFStatement rDFStatement = new RDFStatement(string, string2, string3, string4, string5, bl);
        if (this.m_currentSubject == null || !this.m_currentSubject.equals(rDFStatement.m_subject)) {
            this.writeGroup();
            this.m_currentSubject = string;
        }
        if (this.m_groupTypeStatement == null && this.canAbbreviateStatementAsTypeDeclaration(rDFStatement)) {
            this.m_groupTypeStatement = rDFStatement;
        } else if (this.canAbbreviateLiteralValue(rDFStatement) && !this.m_attributePredicates.contains(rDFStatement.m_predicate)) {
            this.m_attributeStatements.add(rDFStatement);
            this.m_attributePredicates.add(rDFStatement.m_predicate);
        } else {
            this.m_contentStatements.add(rDFStatement);
        }
    }

    protected void writeGroup() throws IOException {
        if (this.m_currentSubject == null || this.m_groupTypeStatement == null && this.m_attributeStatements.isEmpty() && this.m_contentStatements.isEmpty()) {
            return;
        }
        String string = this.m_groupTypeStatement != null ? this.getElementText(this.m_groupTypeStatement.m_object) : this.getElementText("http://www.w3.org/1999/02/22-rdf-syntax-ns#Description");
        this.m_out.print('<');
        this.m_out.print(string);
        this.m_out.print(' ');
        this.writeIDOrAbout(this.m_currentSubject);
        this.writeAttributeStatements();
        if (this.m_contentStatements.isEmpty()) {
            this.m_out.println("/>");
        } else {
            this.m_out.println(">");
            this.writeContentStatements();
            this.m_out.print("</");
            this.m_out.print(string);
            this.m_out.println('>');
        }
        this.m_groupTypeStatement = null;
        this.m_attributeStatements.clear();
        this.m_attributePredicates.clear();
        this.m_contentStatements.clear();
    }

    protected void writeIDOrAbout(String string) throws IOException {
        try {
            URI uRI = this.m_baseURI.relativize(new URI(string));
            String string2 = uRI.toString();
            if (!uRI.isAbsolute() && string2.startsWith("#")) {
                this.m_out.print(this.m_rdfIDElementText);
                this.m_out.print("=\"");
                this.m_out.print(string2.substring(1));
            } else {
                this.m_out.print(this.m_rdfAboutElementText);
                this.m_out.print("=\"");
                if (!uRI.isAbsolute()) {
                    this.m_out.print(string2);
                } else {
                    this.writeAbsoluteResourceReference(string2);
                }
            }
            this.m_out.print("\"");
        }
        catch (URISyntaxException uRISyntaxException) {
            IOException iOException = new IOException("Invalid URI syntax '" + string + "'");
            iOException.initCause(uRISyntaxException);
            throw iOException;
        }
    }

    protected void writeAttributeStatements() throws IOException {
        for (int i = 0; i < this.m_attributeStatements.size(); ++i) {
            RDFStatement rDFStatement = (RDFStatement)this.m_attributeStatements.get(i);
            this.m_out.println();
            this.m_out.print(INDENTATION);
            this.m_out.print(this.getElementText(rDFStatement.m_predicate));
            this.m_out.print('=');
            String string = rDFStatement.m_object;
            char c = this.getValueQuoteType(string);
            this.m_out.print(c);
            this.m_out.print(this.escapeValueForXML(string));
            this.m_out.print(c);
        }
    }

    protected void writeContentStatements() throws IOException {
        for (int i = 0; i < this.m_contentStatements.size(); ++i) {
            RDFStatement rDFStatement = (RDFStatement)this.m_contentStatements.get(i);
            this.m_out.print(INDENTATION);
            this.m_out.print('<');
            String string = this.getElementText(rDFStatement.m_predicate);
            this.m_out.print(string);
            if (!rDFStatement.m_isLiteral) {
                this.writeResourceReference(rDFStatement.m_object);
                this.m_out.println("/>");
                continue;
            }
            if (rDFStatement.m_language != null) {
                this.m_out.print(" ");
                this.m_out.print("xml:lang");
                this.m_out.print("=\"");
                this.m_out.print(rDFStatement.m_language);
                this.m_out.print("\"");
            }
            if (rDFStatement.m_datatype != null) {
                if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral".equals(rDFStatement.m_datatype)) {
                    this.m_out.print(" ");
                    this.m_out.print(this.m_rdfParseTypeText);
                    this.m_out.print("=\"");
                    this.m_out.print("Literal");
                    this.m_out.print("\"");
                } else {
                    this.m_out.print(" ");
                    this.m_out.print(this.m_rdfDatatypeText);
                    this.m_out.print("=\"");
                    this.m_out.print(rDFStatement.m_datatype);
                    this.m_out.print("\"");
                }
            }
            this.m_out.print('>');
            this.writeTextValue(rDFStatement.m_object);
            this.m_out.print("</");
            this.m_out.print(string);
            this.m_out.println('>');
        }
    }

    protected void writeResourceReference(String string) throws IOException {
        try {
            this.m_out.print(' ');
            this.m_out.print(this.m_rdfResourceElementText);
            this.m_out.print("=\"");
            URI uRI = this.m_baseURI.relativize(new URI(string));
            if (!uRI.isAbsolute()) {
                this.m_out.print(uRI.toString());
            } else {
                this.writeAbsoluteResourceReference(string);
            }
            this.m_out.print("\"");
        }
        catch (URISyntaxException uRISyntaxException) {
            IOException iOException = new IOException("Invalid URI syntax '" + string + "'");
            iOException.initCause(uRISyntaxException);
            throw iOException;
        }
    }

    protected void writeAbsoluteResourceReference(String string) {
        String string2;
        String string3 = RDFUtil.guessNamespace(string);
        String string4 = RDFUtil.guessName(string);
        String string5 = string;
        if (string3 != null && string3.length() != 0 && (string2 = (String)this.m_namespaces.get(string3)) != null) {
            string5 = "&" + string2 + ";" + string4;
        }
        this.m_out.print(string5);
    }

    protected void writeTextValue(String string) {
        if (this.getValueQuoteType(string) == '\u0001') {
            this.writeEscapedCDATA(string);
        } else {
            this.m_out.print(this.escapeValueForXML(string));
        }
    }

    protected void writeEscapedCDATA(String string) {
        int n = 0;
        int n2 = string.indexOf("]]>", n);
        this.m_out.print("<![CDATA[");
        while (n2 >= 0 && n < string.length()) {
            this.m_out.print(string.substring(n, n2));
            this.m_out.print("]]>]]&#x3e;<![CDATA[");
            n = n2 + 3;
            n2 = string.indexOf("]]>", n);
        }
        this.m_out.print(string.substring(n));
        this.m_out.print("]]>");
    }

    protected String escapeValueForXML(String string) {
        if (string.indexOf(60) == -1 && string.indexOf(38) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = stringBuffer.length() - 1; i >= 0; --i) {
            char c = stringBuffer.charAt(i);
            if (c == '<') {
                stringBuffer.deleteCharAt(i);
                stringBuffer.insert(i, "&lt;");
                continue;
            }
            if (c != '&') continue;
            stringBuffer.deleteCharAt(i);
            stringBuffer.insert(i, "&amp;");
        }
        return stringBuffer.toString();
    }

    protected char getValueQuoteType(String string) {
        int n = 0;
        boolean bl = false;
        boolean bl2 = true;
        for (int i = 0; i < string.length(); ++i) {
            int n2 = string.charAt(i);
            if (n2 == 10) {
                bl = true;
            }
            if (n2 == 34 || n2 == 39) {
                if (n == 0) {
                    n = n2 == 34 ? 39 : 34;
                } else if (n2 == n) {
                    return '\u0001';
                }
            }
            if (Character.isWhitespace((char)n2)) continue;
            bl2 = false;
        }
        if (bl2 || bl) {
            return '\u0001';
        }
        return (char)(n == 0 ? 34 : n);
    }

    protected boolean canAbbreviateLiteralValue(RDFStatement rDFStatement) {
        String string;
        if (rDFStatement.m_isLiteral && rDFStatement.m_language == null && rDFStatement.m_datatype == null && (string = rDFStatement.m_object).length() < 60) {
            char c = this.getValueQuoteType(string);
            return c == '\"' || c == '\'';
        }
        return false;
    }

    protected boolean canAbbreviateStatementAsTypeDeclaration(RDFStatement rDFStatement) throws IOException {
        if (!rDFStatement.m_isLiteral && "http://www.w3.org/1999/02/22-rdf-syntax-ns#type".equals(rDFStatement.m_predicate)) {
            String string = this.getElementText(rDFStatement.m_object);
            return this.isValidXMLName(string);
        }
        return false;
    }

    protected boolean isValidXMLName(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || c == ':' || c == '-' || c == '_') continue;
            return false;
        }
        return true;
    }

    protected String getElementText(String string) throws IOException {
        String string2 = RDFUtil.guessNamespace(string);
        String string3 = RDFUtil.guessName(string);
        if (string2 == null || string2.length() == 0) {
            return string3;
        }
        String string4 = (String)this.m_namespaces.get(string2);
        if (string4 == null) {
            throw new IOException("Prefix for element '" + string + "' cannot be found.");
        }
        return string4 + ":" + string3;
    }

    public void collectNamespace(String string) {
        String string2 = RDFUtil.guessNamespace(string);
        if (!this.m_namespaces.containsKey(string2)) {
            String string3 = (String)this.m_defaultNamespaces.get(string2);
            if (string3 == null) {
                string3 = (String)this.m_defaultNamespaces.get(string2);
            }
            if (string3 == null) {
                while (this.m_namespaces.containsKey(string3 = this.getNextNamespacePrefix())) {
                }
            }
            this.m_namespaces.put(string2, string3);
        }
    }

    protected String getNextNamespacePrefix() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.m_nextAutomaticPrefixIndex++;
        do {
            stringBuffer.append((char)(97 + n % 26));
        } while ((n /= 26) != 0);
        return stringBuffer.toString();
    }

    protected static class RDFStatement {
        public String m_subject;
        public String m_predicate;
        public String m_object;
        public String m_language;
        public String m_datatype;
        public boolean m_isLiteral;

        public RDFStatement(String string, String string2, String string3, String string4, String string5, boolean bl) {
            this.m_subject = string;
            this.m_predicate = string2;
            this.m_object = string3;
            this.m_language = string4;
            this.m_datatype = string5;
            this.m_isLiteral = bl;
        }
    }
}

