/*
 * Decompiled with CFR 0.152.
 */
package edu.unika.aifb.rdf.api.syntax;

import edu.unika.aifb.rdf.api.syntax.RDFConsumer;
import edu.unika.aifb.rdf.api.syntax.RDFParseException;
import edu.unika.aifb.rdf.api.util.RDFConstants;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;

public class RDFParser
extends DefaultHandler
implements RDFConstants {
    protected static final Locator s_nullDocumentLocator = new LocatorImpl();
    protected static final SAXParserFactory s_parserFactory = SAXParserFactory.newInstance();
    protected ErrorHandler m_errorHandler;
    protected Stack m_baseURIs;
    protected URI m_baseURI;
    protected Stack m_languages;
    protected String m_language;
    protected RDFConsumer m_consumer;
    protected State m_state;
    protected List m_states = new ArrayList();
    protected int m_generatedURIIndex;
    protected Locator m_documentLocator;

    public RDFParser() {
        this.m_baseURIs = new Stack();
        this.m_languages = new Stack();
    }

    public void parse(InputSource inputSource, RDFConsumer rDFConsumer) throws SAXException, IOException {
        String string = inputSource.getSystemId();
        try {
            try {
                this.m_documentLocator = s_nullDocumentLocator;
                if (string == null) {
                    throw new SAXException("Supplied InputSource object myst have systemId property set, which is needed for URI resolution.");
                }
                this.m_baseURI = new URI(inputSource.getSystemId());
                this.m_consumer = rDFConsumer;
                this.m_consumer.startModel(this.m_baseURI.toString());
                SAXParser sAXParser = s_parserFactory.newSAXParser();
                sAXParser.parse(inputSource, (DefaultHandler)this);
                this.m_consumer.endModel();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new SAXException("Parser coniguration exception", parserConfigurationException);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new SAXException("Invalid SystemID '" + string + "'of the supplied input source.");
            }
            Object var6_7 = null;
            this.m_state = null;
            this.m_states.clear();
            this.m_documentLocator = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.m_state = null;
            this.m_states.clear();
            this.m_documentLocator = null;
            this.m_baseURIs.clear();
            throw throwable;
        }
        this.m_baseURIs.clear();
    }

    public void setDocumentLocator(Locator locator) {
        this.m_documentLocator = locator;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.m_errorHandler = errorHandler;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (this.m_errorHandler == null) {
            super.warning(sAXParseException);
        } else {
            this.m_errorHandler.warning(sAXParseException);
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (this.m_errorHandler == null) {
            super.error(sAXParseException);
        } else {
            this.m_errorHandler.error(sAXParseException);
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (this.m_errorHandler == null) {
            super.fatalError(sAXParseException);
        } else {
            this.m_errorHandler.fatalError(sAXParseException);
        }
    }

    public void startDocument() throws SAXException {
        this.m_generatedURIIndex = 0;
        this.m_states.clear();
        this.pushState(new StartRDF());
    }

    public void endDocument() throws SAXException {
        if (this.m_state != null) {
            throw new RDFParseException("RDF content not finished.", this.m_documentLocator);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.processXMLBase(attributes);
        this.processXMLLanguage(attributes);
        this.m_state.startElement(string, string2, string3, attributes);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.m_state.endElement(string, string2, string3);
        this.m_baseURI = (URI)this.m_baseURIs.pop();
        this.m_language = (String)this.m_languages.pop();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.m_state.characters(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if ("include-rdf".equals(string)) {
            Map map = this.parseStringArguments(string2);
            if (map.size() > 2) {
                throw new RDFParseException("Incorrect number of arguments for 'include-rdf' processing instruction.", this.m_documentLocator);
            }
            String string3 = (String)map.get("logicalURI");
            String string4 = (String)map.get("physicalURI");
            if (string4 != null) {
                string4 = this.resolveURI(string4);
            }
            this.m_consumer.includeModel(string3, string4);
        } else if ("model-attribute".equals(string)) {
            Map map = this.parseStringArguments(string2);
            if (map.size() != 2) {
                throw new RDFParseException("Incorrect number of arguments for 'model-attribute' processing instruction.", this.m_documentLocator);
            }
            String string5 = (String)map.get("key");
            if (string5 == null) {
                throw new RDFParseException("Mising the 'key' argument for 'model-attribute' processing instruction.", this.m_documentLocator);
            }
            String string6 = (String)map.get("value");
            if (string6 == null) {
                throw new RDFParseException("Mising the 'value' argument for 'model-attribute' processing instruction.", this.m_documentLocator);
            }
            this.m_consumer.addModelAttribte(string5, string6);
        }
    }

    protected void pushState(State state) {
        this.m_states.add(state);
        this.m_state = state;
    }

    protected void popState() throws SAXException {
        int n = this.m_states.size();
        if (n == 0) {
            throw new RDFParseException("Internal exception: state stack is empty.", this.m_documentLocator);
        }
        this.m_state = n == 1 ? null : (State)this.m_states.get(n - 2);
        this.m_states.remove(n - 1);
    }

    protected void checkUnsupportedAttributes(Attributes attributes) throws SAXException {
        if (attributes.getIndex("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "aboutEach") != -1) {
            throw new RDFParseException("rdf:aboutEach attribute is not supported.", this.m_documentLocator);
        }
        if (attributes.getIndex("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "aboutEachPrefix") != -1) {
            throw new RDFParseException("rdf:aboutEachPrefix attribute is not supported.", this.m_documentLocator);
        }
    }

    protected void processXMLBase(Attributes attributes) throws SAXException {
        this.m_baseURIs.push(this.m_baseURI);
        String string = attributes.getValue("http://www.w3.org/XML/1998/namespace", "base");
        if (string != null) {
            try {
                this.m_baseURI = this.m_baseURI.resolve(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                RDFParseException rDFParseException = new RDFParseException("New base URI '" + string + "' cannot be resolved against curent base URI " + this.m_baseURI.toString(), this.m_documentLocator);
                rDFParseException.initCause(illegalArgumentException);
                throw rDFParseException;
            }
        }
    }

    protected void processXMLLanguage(Attributes attributes) throws SAXException {
        this.m_languages.push(this.m_language);
        String string = attributes.getValue("xml:lang");
        if (string != null) {
            this.m_language = string;
        }
    }

    protected String resolveURI(String string) throws SAXException {
        if (string.length() == 0) {
            return this.m_baseURI.toString();
        }
        try {
            return this.m_baseURI.resolve(string).toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            RDFParseException rDFParseException = new RDFParseException("URI '" + string + "' cannot be resolved against curent base URI " + this.m_baseURI.toString(), this.m_documentLocator);
            rDFParseException.initCause(illegalArgumentException);
            throw rDFParseException;
        }
    }

    protected String getURIFromID(String string) throws SAXException {
        return this.resolveURI("#" + string);
    }

    protected String getURIFromAbout(String string) throws SAXException {
        return this.resolveURI(string);
    }

    protected String getURIFromNodeID(String string) throws SAXException {
        return this.resolveURI("#genid-" + string);
    }

    protected String getURIFromResource(String string) throws SAXException {
        return this.resolveURI(string);
    }

    protected String nextAnonymousURI() throws SAXException {
        return this.getURIFromID("genid" + ++this.m_generatedURIIndex);
    }

    protected String getIDNodeIDAboutResourceURI(Attributes attributes) throws SAXException {
        String string = null;
        String string2 = attributes.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "ID");
        if (string2 != null) {
            string = this.getURIFromID(string2);
        }
        if ((string2 = attributes.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about")) != null) {
            if (string != null) {
                throw new RDFParseException("Element cannot specify both rdf:ID and rdf:about attributes.", this.m_documentLocator);
            }
            string = this.getURIFromAbout(string2);
        }
        if ((string2 = attributes.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID")) != null) {
            if (string != null) {
                throw new RDFParseException("Element cannot specify both rdf:nodeID and rdf:ID or rdf:about attributes.", this.m_documentLocator);
            }
            string = this.getURIFromNodeID(string2);
        }
        if (string == null) {
            string = this.nextAnonymousURI();
        }
        return string;
    }

    protected String getNodeIDResourceResourceURI(Attributes attributes) throws SAXException {
        String string = attributes.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource");
        if (string != null) {
            return this.getURIFromResource(string);
        }
        string = attributes.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID");
        if (string != null) {
            return this.getURIFromNodeID(string);
        }
        return null;
    }

    protected void statementWithResourceValue(String string, String string2, String string3, String string4) throws SAXException {
        this.m_consumer.statementWithResourceValue(string, string2, string3);
        if (string4 != null) {
            this.m_consumer.statementWithResourceValue(string4, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/1999/02/22-rdf-syntax-ns#statement");
            this.m_consumer.statementWithResourceValue(string4, "http://www.w3.org/1999/02/22-rdf-syntax-ns#subject", string);
            this.m_consumer.statementWithResourceValue(string4, "http://www.w3.org/1999/02/22-rdf-syntax-ns#predicate", string2);
            this.m_consumer.statementWithResourceValue(string4, "http://www.w3.org/1999/02/22-rdf-syntax-ns#object", string3);
        }
    }

    protected void statementWithLiteralValue(String string, String string2, String string3, String string4, String string5) throws SAXException {
        this.m_consumer.statementWithLiteralValue(string, string2, string3, this.m_language, string4);
        if (string5 != null) {
            this.m_consumer.statementWithResourceValue(string5, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/1999/02/22-rdf-syntax-ns#statement");
            this.m_consumer.statementWithResourceValue(string5, "http://www.w3.org/1999/02/22-rdf-syntax-ns#subject", string);
            this.m_consumer.statementWithResourceValue(string5, "http://www.w3.org/1999/02/22-rdf-syntax-ns#predicate", string2);
            this.m_consumer.statementWithLiteralValue(string5, "http://www.w3.org/1999/02/22-rdf-syntax-ns#object", string3, this.m_language, string4);
        }
    }

    protected void propertyAttributes(String string, Attributes attributes, ReificationManager reificationManager) throws SAXException {
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String string2;
            String string3;
            String string4 = attributes.getURI(i);
            String string5 = attributes.getLocalName(i);
            if (!("http://www.w3.org/XML/1998/namespace".equals(string4) || "xml:lang".equals(string5) || "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(string4) && ("ID".equals(string5) || "nodeID".equals(string5) || "about".equals(string5) || "type".equals(string5) || "resource".equals(string5) || "parseType".equals(string5) || "aboutEach".equals(string5) || "aboutEachPrefix".equals(string5) || "bagID".equals(string5)))) {
                string3 = attributes.getValue(i);
                string2 = reificationManager.getReificationID(null);
                this.statementWithLiteralValue(string, string4 + string5, string3, null, string2);
                continue;
            }
            if (!"http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(string4) || !"type".equals(string5)) continue;
            string3 = this.resolveURI(attributes.getValue(i));
            string2 = reificationManager.getReificationID(null);
            this.statementWithResourceValue(string, string4 + string5, string3, string2);
        }
    }

    protected boolean isWhitespaceOnly(char[] cArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            char c = cArray[i];
            if (c == '\n' || c == '\r' || c == '\t' || c == ' ') continue;
            return false;
        }
        return true;
    }

    protected boolean isWhitespaceOnly(StringBuffer stringBuffer) {
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (c == '\n' || c == '\r' || c == '\t' || c == ' ') continue;
            return false;
        }
        return true;
    }

    protected ReificationManager getReificationManager(Attributes attributes) throws SAXException {
        String string = attributes.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "bagID");
        if (string == null) {
            return ReificationManager.INSTANCE;
        }
        String string2 = this.getURIFromID(string);
        return new ReifiedStatementBag(string2);
    }

    protected Map parseStringArguments(String string) throws SAXException {
        try {
            StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
            HashMap<String, String> hashMap = new HashMap<String, String>();
            streamTokenizer.nextToken();
            while (streamTokenizer.ttype != -1) {
                if (streamTokenizer.ttype != -3) {
                    throw new RDFParseException("Invalid processing instruction argument.", this.m_documentLocator);
                }
                String string2 = streamTokenizer.sval;
                if (61 != streamTokenizer.nextToken()) {
                    throw new RDFParseException("Expecting token =", this.m_documentLocator);
                }
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != 34 && streamTokenizer.ttype != 39) {
                    throw new RDFParseException("Invalid processing instruction argument.", this.m_documentLocator);
                }
                String string3 = streamTokenizer.sval;
                hashMap.put(string2, string3);
                streamTokenizer.nextToken();
            }
            return hashMap;
        }
        catch (IOException iOException) {
            RDFParseException rDFParseException = new RDFParseException("I/O error", this.m_documentLocator);
            rDFParseException.initCause(iOException);
            throw rDFParseException;
        }
    }

    public boolean isAnonymousNodeURI(String string) {
        return string.indexOf("#genid") != -1;
    }

    static {
        s_parserFactory.setNamespaceAware(true);
    }

    protected class ReifiedStatementBag
    extends ReificationManager {
        protected String m_uri;
        protected int m_elements;

        public ReifiedStatementBag(String string) throws SAXException {
            this.m_uri = string;
            this.m_elements = 0;
            RDFParser.this.statementWithResourceValue(this.m_uri, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag", null);
        }

        public String getReificationID(String string) throws SAXException {
            String string2 = string == null ? RDFParser.this.nextAnonymousURI() : string;
            RDFParser.this.statementWithResourceValue(this.m_uri, "http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + ++this.m_elements, string2, null);
            return string2;
        }
    }

    protected static class ReificationManager {
        public static ReificationManager INSTANCE = new ReificationManager();

        protected ReificationManager() {
        }

        public String getReificationID(String string) throws SAXException {
            return string;
        }
    }

    protected class ParseTypeResourcePropertyElement
    extends State {
        protected NodeElement m_nodeElement;
        protected String m_propertyURI;
        protected String m_reificationID;

        public ParseTypeResourcePropertyElement(NodeElement nodeElement) {
            this.m_nodeElement = nodeElement;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.m_propertyURI = this.m_nodeElement.getPropertyURI(string + string2);
            this.m_reificationID = this.m_nodeElement.getReificationID(attributes);
            NodeElement nodeElement = new NodeElement();
            nodeElement.startDummyElement(attributes);
            RDFParser.this.statementWithResourceValue(this.m_nodeElement.getSubjectURI(), this.m_propertyURI, nodeElement.getSubjectURI(), this.m_reificationID);
            RDFParser.this.pushState(new PropertyElementList(nodeElement));
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            RDFParser.this.popState();
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (!RDFParser.this.isWhitespaceOnly(cArray, n, n2)) {
                throw new RDFParseException("Cannot process characters when object properties are excepted.", RDFParser.this.m_documentLocator);
            }
        }
    }

    protected class ParseTypeLiteralPropertyElement
    extends State {
        protected NodeElement m_nodeElement;
        protected String m_propertyURI;
        protected String m_reificationID;
        protected int m_depth;
        protected StringBuffer m_content;

        public ParseTypeLiteralPropertyElement(NodeElement nodeElement) {
            this.m_nodeElement = nodeElement;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.m_depth == 0) {
                this.m_propertyURI = this.m_nodeElement.getPropertyURI(string + string2);
                this.m_reificationID = this.m_nodeElement.getReificationID(attributes);
                this.m_content = new StringBuffer();
            } else {
                this.m_content.append('<');
                this.m_content.append(string3);
                int n = attributes.getLength();
                for (int i = 0; i < n; ++i) {
                    this.m_content.append(' ');
                    this.m_content.append(attributes.getQName(i));
                    this.m_content.append("=\"");
                    this.m_content.append(attributes.getValue(i));
                    this.m_content.append("\"");
                }
                this.m_content.append(">");
            }
            ++this.m_depth;
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.m_depth == 1) {
                RDFParser.this.statementWithLiteralValue(this.m_nodeElement.getSubjectURI(), this.m_propertyURI, this.m_content.toString(), "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral", this.m_reificationID);
                RDFParser.this.popState();
            } else {
                this.m_content.append("</");
                this.m_content.append(string3);
                this.m_content.append(">");
            }
            --this.m_depth;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.m_content.append(cArray, n, n2);
        }
    }

    protected class ParseTypeCollectionPropertyElement
    extends State {
        protected NodeElement m_nodeElement;
        protected String m_propertyURI;
        protected String m_reificationID;
        protected String m_lastCellURI;

        public ParseTypeCollectionPropertyElement(NodeElement nodeElement) {
            this.m_nodeElement = nodeElement;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.m_propertyURI == null) {
                this.m_propertyURI = this.m_nodeElement.getPropertyURI(string + string2);
                this.m_reificationID = this.m_nodeElement.getReificationID(attributes);
            } else {
                NodeElement nodeElement = new NodeElement();
                RDFParser.this.pushState(nodeElement);
                RDFParser.this.m_state.startElement(string, string2, string3, attributes);
                String string4 = this.listCell(nodeElement.getSubjectURI());
                if (this.m_lastCellURI == null) {
                    RDFParser.this.statementWithResourceValue(this.m_nodeElement.getSubjectURI(), this.m_propertyURI, string4, this.m_reificationID);
                } else {
                    RDFParser.this.statementWithResourceValue(this.m_lastCellURI, "http://www.w3.org/1999/02/22-rdf-syntax-ns#rest", string4, null);
                }
                this.m_lastCellURI = string4;
            }
        }

        protected String listCell(String string) throws SAXException {
            String string2 = RDFParser.this.nextAnonymousURI();
            RDFParser.this.statementWithResourceValue(string2, "http://www.w3.org/1999/02/22-rdf-syntax-ns#first", string, null);
            RDFParser.this.statementWithResourceValue(string2, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/1999/02/22-rdf-syntax-ns#List", null);
            return string2;
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.m_lastCellURI == null) {
                RDFParser.this.statementWithResourceValue(this.m_nodeElement.getSubjectURI(), this.m_propertyURI, "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil", this.m_reificationID);
            } else {
                RDFParser.this.statementWithResourceValue(this.m_lastCellURI, "http://www.w3.org/1999/02/22-rdf-syntax-ns#rest", "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil", null);
            }
            RDFParser.this.popState();
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (!RDFParser.this.isWhitespaceOnly(cArray, n, n2)) {
                throw new RDFParseException("Expecting an object element instead of character content.", RDFParser.this.m_documentLocator);
            }
        }
    }

    protected class EmptyPropertyElement
    extends State {
        protected NodeElement m_nodeElement;
        protected String m_propertyURI;

        public EmptyPropertyElement(NodeElement nodeElement) {
            this.m_nodeElement = nodeElement;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4;
            String string5;
            if (this.m_propertyURI == null) {
                this.m_propertyURI = this.m_nodeElement.getPropertyURI(string + string2);
                string5 = this.m_nodeElement.getReificationID(attributes);
                string4 = RDFParser.this.getNodeIDResourceResourceURI(attributes);
                if (string4 == null) {
                    string4 = RDFParser.this.nextAnonymousURI();
                }
            } else {
                throw new RDFParseException("incorrect element start encountered.", RDFParser.this.m_documentLocator);
            }
            RDFParser.this.statementWithResourceValue(this.m_nodeElement.getSubjectURI(), this.m_propertyURI, string4, string5);
            ReificationManager reificationManager = RDFParser.this.getReificationManager(attributes);
            RDFParser.this.propertyAttributes(string4, attributes, reificationManager);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            RDFParser.this.popState();
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            throw new RDFParseException("Characters were not excepted.", RDFParser.this.m_documentLocator);
        }
    }

    protected class ResourceOrLiteralPropertyElement
    extends State {
        protected NodeElement m_nodeElement;
        protected String m_propertyURI;
        protected String m_reificationID;
        protected String m_datatype;
        protected StringBuffer m_text;
        protected NodeElement m_innerNode;

        public ResourceOrLiteralPropertyElement(NodeElement nodeElement) {
            this.m_nodeElement = nodeElement;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.m_text == null) {
                this.m_propertyURI = this.m_nodeElement.getPropertyURI(string + string2);
                this.m_reificationID = this.m_nodeElement.getReificationID(attributes);
                this.m_datatype = attributes.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype");
                this.m_text = new StringBuffer();
            } else {
                if (!RDFParser.this.isWhitespaceOnly(this.m_text)) {
                    throw new RDFParseException("Text was seen and new node is started.", RDFParser.this.m_documentLocator);
                }
                if (this.m_datatype != null) {
                    throw new RDFParseException("rdf:datatype specified on a node with resource value.", RDFParser.this.m_documentLocator);
                }
                this.m_innerNode = new NodeElement();
                RDFParser.this.pushState(this.m_innerNode);
                RDFParser.this.m_state.startElement(string, string2, string3, attributes);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.m_innerNode != null) {
                RDFParser.this.statementWithResourceValue(this.m_nodeElement.getSubjectURI(), this.m_propertyURI, this.m_innerNode.getSubjectURI(), this.m_reificationID);
            } else {
                RDFParser.this.statementWithLiteralValue(this.m_nodeElement.getSubjectURI(), this.m_propertyURI, this.m_text.toString().trim(), this.m_datatype, this.m_reificationID);
            }
            RDFParser.this.popState();
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.m_innerNode != null) {
                if (!RDFParser.this.isWhitespaceOnly(cArray, n, n2)) {
                    throw new RDFParseException("Cannot process characters when object properties are excepted.", RDFParser.this.m_documentLocator);
                }
            } else {
                this.m_text.append(cArray, n, n2);
            }
        }
    }

    protected class PropertyElementList
    extends State {
        protected NodeElement m_nodeElement;

        public PropertyElementList(NodeElement nodeElement) {
            this.m_nodeElement = nodeElement;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4 = attributes.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType");
            if ("Literal".equals(string4)) {
                RDFParser.this.pushState(new ParseTypeLiteralPropertyElement(this.m_nodeElement));
            } else if ("Resource".equals(string4)) {
                RDFParser.this.pushState(new ParseTypeResourcePropertyElement(this.m_nodeElement));
            } else if ("Collection".equals(string4)) {
                RDFParser.this.pushState(new ParseTypeCollectionPropertyElement(this.m_nodeElement));
            } else if (string4 != null) {
                RDFParser.this.pushState(new ParseTypeLiteralPropertyElement(this.m_nodeElement));
            } else {
                String string5 = RDFParser.this.getNodeIDResourceResourceURI(attributes);
                if (string5 != null) {
                    RDFParser.this.pushState(new EmptyPropertyElement(this.m_nodeElement));
                } else {
                    RDFParser.this.pushState(new ResourceOrLiteralPropertyElement(this.m_nodeElement));
                }
            }
            RDFParser.this.m_state.startElement(string, string2, string3, attributes);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            RDFParser.this.popState();
            RDFParser.this.m_state.endElement(string, string2, string3);
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (!RDFParser.this.isWhitespaceOnly(cArray, n, n2)) {
                throw new RDFParseException("Cannot process characters when object properties are excepted.", RDFParser.this.m_documentLocator);
            }
        }
    }

    protected class NodeElement
    extends State {
        protected String m_subjectURI;
        protected ReificationManager m_reificationManager;
        protected int m_nextLi = 1;

        protected NodeElement() {
        }

        public void startDummyElement(Attributes attributes) throws SAXException {
            this.m_subjectURI = RDFParser.this.nextAnonymousURI();
            this.m_reificationManager = RDFParser.this.getReificationManager(attributes);
        }

        public String getSubjectURI() {
            return this.m_subjectURI;
        }

        public String getReificationID(Attributes attributes) throws SAXException {
            String string = attributes.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "ID");
            if (string != null) {
                string = RDFParser.this.getURIFromID(string);
            }
            return this.m_reificationManager.getReificationID(string);
        }

        public String getNextLi() {
            return "http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + this.m_nextLi++;
        }

        public String getPropertyURI(String string) {
            if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#li".equals(string)) {
                return this.getNextLi();
            }
            return string;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.m_subjectURI = RDFParser.this.getIDNodeIDAboutResourceURI(attributes);
            boolean bl = "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(string);
            this.m_reificationManager = RDFParser.this.getReificationManager(attributes);
            if (!bl || !"Description".equals(string2)) {
                RDFParser.this.statementWithResourceValue(this.m_subjectURI, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", string + string2, this.m_reificationManager.getReificationID(null));
            }
            RDFParser.this.checkUnsupportedAttributes(attributes);
            RDFParser.this.propertyAttributes(this.m_subjectURI, attributes, this.m_reificationManager);
            RDFParser.this.pushState(new PropertyElementList(this));
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            RDFParser.this.popState();
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (!RDFParser.this.isWhitespaceOnly(cArray, n, n2)) {
                throw new RDFParseException("Cannot process characters when node is excepted.", RDFParser.this.m_documentLocator);
            }
        }
    }

    protected class NodeElementList
    extends State {
        protected NodeElementList() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            RDFParser.this.pushState(new NodeElement());
            RDFParser.this.m_state.startElement(string, string2, string3, attributes);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            RDFParser.this.popState();
            RDFParser.this.m_state.endElement(string, string2, string3);
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (!RDFParser.this.isWhitespaceOnly(cArray, n, n2)) {
                throw new RDFParseException("Expecting an object element instead of character content.", RDFParser.this.m_documentLocator);
            }
        }
    }

    protected class StartRDF
    extends State {
        protected StartRDF() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!"http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(string) || !"RDF".equals(string2)) {
                throw new RDFParseException("Expecting rdf:RDF element.", RDFParser.this.m_documentLocator);
            }
            RDFParser.this.m_consumer.logicalURI(RDFParser.this.m_baseURI.toString());
            RDFParser.this.pushState(new NodeElementList());
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            RDFParser.this.popState();
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (!RDFParser.this.isWhitespaceOnly(cArray, n, n2)) {
                throw new RDFParseException("Expecting rdf:rdf element instead of character content.", RDFParser.this.m_documentLocator);
            }
        }
    }

    protected static class State {
        protected State() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
        }
    }
}

