/*
 * Decompiled with CFR 0.152.
 */
package ca.uqam.info.latece.sboa.impl.ograph;

import ca.uqam.info.latece.sboa.inter.ograph.Vertice;
import ca.uqam.info.latece.sboa.inter.ograph.VerticesPool;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerticesPoolImpl
implements VerticesPool {
    private String[] categoryNames = null;
    private Hashtable<String, Integer> categoryLabelToId = new Hashtable();
    private Hashtable<String, Integer> verticeLabelToId = new Hashtable();
    private Vector<ArrayList<Integer>> IdsGroupedByCategory = null;
    private Hashtable<Integer, Vertice> verticeIdToVertice = new Hashtable();
    private int[] IdGroupsLen = null;
    private int size = 0;
    private int numberOfCategories = 0;
    private int numberOfNeighParts = 0;

    public VerticesPoolImpl() {
    }

    public VerticesPoolImpl(String[] stringArray, int n) {
        this.init(stringArray);
        this.setNeighborhoodParts(n);
    }

    @Override
    public int numberOfPart() {
        return this.numberOfCategories;
    }

    @Override
    public int getPartId(String string) {
        return this.categoryLabelToId.get(string);
    }

    @Override
    public boolean containsCategory(String string) {
        return this.categoryLabelToId.containsKey(string);
    }

    @Override
    public boolean contains(String string) {
        Integer n = this.verticeLabelToId.get(string);
        return this.verticeIdToVertice.containsKey(n);
    }

    @Override
    public boolean contains(int n) {
        Integer n2 = new Integer(n);
        return this.verticeIdToVertice.containsKey(n2);
    }

    @Override
    public Object get(String string) {
        Integer n = this.verticeLabelToId.get(string);
        return this.verticeIdToVertice.get(n);
    }

    @Override
    public Object get(int n) {
        Integer n2 = new Integer(n);
        return this.verticeIdToVertice.get(n2);
    }

    @Override
    public ArrayList<Integer> getAllIds(String string) {
        Integer n = this.categoryLabelToId.get(string);
        return this.IdsGroupedByCategory.elementAt(n);
    }

    @Override
    public Object[] getAll(String string) {
        Integer n = this.categoryLabelToId.get(string);
        int n2 = this.IdGroupsLen[n];
        Object[] objectArray = new Object[n2];
        ArrayList<Integer> arrayList = this.IdsGroupedByCategory.elementAt(n);
        for (int i = 0; i < n2; ++i) {
            Integer n3 = arrayList.get(i);
            objectArray[i] = this.get(n3);
        }
        return objectArray;
    }

    @Override
    public Object[] getAll() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.numberOfCategories; ++i) {
            Object[] objectArray = this.getAll(this.categoryNames[i]);
            int n = this.partSize(this.categoryNames[i]);
            for (int j = 0; j < n; ++j) {
                arrayList.add(objectArray[j]);
            }
        }
        return arrayList.toArray();
    }

    @Override
    public Object[] getAll(int[] nArray) {
        int n = nArray.length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.get(nArray[i]);
        }
        return objectArray;
    }

    @Override
    public String[] getPartsNames() {
        return this.categoryNames;
    }

    @Override
    public void init(String[] stringArray) {
        int n = stringArray.length;
        this.categoryNames = new String[n];
        this.IdsGroupedByCategory = new Vector(n);
        this.IdGroupsLen = new int[n];
        for (int i = 0; i < n; ++i) {
            this.categoryNames[i] = stringArray[i];
            this.categoryLabelToId.put(this.categoryNames[i], i);
            this.IdsGroupedByCategory.insertElementAt(new ArrayList(), i);
            this.IdGroupsLen[i] = 0;
            ++this.numberOfCategories;
        }
    }

    @Override
    public void insert(Object object) {
        Vertice vertice = (Vertice)object;
        String string = vertice.getLabel();
        int n = vertice.getId();
        String string2 = vertice.getCategory();
        vertice.setNumberOfEdgesLabels(this.numberOfNeighParts);
        Integer n2 = this.categoryLabelToId.get(string2);
        Integer n3 = new Integer(n);
        this.IdsGroupedByCategory.elementAt(n2).add(n3);
        this.verticeLabelToId.put(string, n3);
        this.verticeIdToVertice.put(n3, vertice);
        int n4 = n2;
        this.IdGroupsLen[n4] = this.IdGroupsLen[n4] + 1;
        ++this.size;
    }

    @Override
    public void insertAll(Object[] objectArray) {
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            this.insert(objectArray[i]);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int partSize(String string) {
        Integer n = this.categoryLabelToId.get(string);
        return this.IdGroupsLen[n];
    }

    @Override
    public void remove(String string) {
        Vertice vertice = (Vertice)this.get(string);
        String string2 = vertice.getCategory();
        Integer n = this.categoryLabelToId.get(string2);
        Integer n2 = this.verticeLabelToId.get(string);
        this.IdsGroupedByCategory.elementAt(n).remove(n2);
        int n3 = n;
        this.IdGroupsLen[n3] = this.IdGroupsLen[n3] - 1;
        --this.size;
        this.verticeIdToVertice.remove(n2);
        this.verticeLabelToId.remove(string);
    }

    @Override
    public void remove(int n) {
        Vertice vertice = (Vertice)this.get(n);
        String string = vertice.getCategory();
        Integer n2 = this.categoryLabelToId.get(string);
        Integer n3 = new Integer(n);
        this.IdsGroupedByCategory.elementAt(n2).remove(n3);
        int n4 = n2;
        this.IdGroupsLen[n4] = this.IdGroupsLen[n4] - 1;
        --this.size;
        this.verticeIdToVertice.remove(n3);
        String string2 = vertice.getLabel();
        this.verticeLabelToId.remove(string2);
    }

    @Override
    public void removeAll(String string) {
        Integer n = this.categoryLabelToId.get(string);
        int n2 = this.IdGroupsLen[n];
        ArrayList<Integer> arrayList = this.IdsGroupedByCategory.elementAt(n);
        for (int i = 0; i < n2; ++i) {
            Integer n3 = arrayList.get(i);
            this.remove(n3);
        }
    }

    @Override
    public void removeAll(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            this.remove(nArray[i]);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int getNumberOfNeighborhooParts() {
        return this.numberOfNeighParts;
    }

    @Override
    public void setNeighborhoodParts(int n) {
        this.numberOfNeighParts = n;
    }

    @Override
    public void viewAllVertices() {
        for (int i = this.numberOfCategories - 1; i >= 0; --i) {
            String string = this.categoryNames[i];
            Object[] objectArray = this.getAll(string);
            int n = this.partSize(string);
            for (int j = 0; j < n; ++j) {
                ((Vertice)objectArray[j]).view();
            }
        }
    }

    @Override
    public void clearAll() {
        this.categoryNames = null;
        this.categoryLabelToId.clear();
        this.verticeLabelToId.clear();
        this.IdsGroupedByCategory.clear();
        this.verticeIdToVertice.clear();
        this.IdGroupsLen = null;
    }
}

