/*
 * Decompiled with CFR 0.152.
 */
package ca.uqam.info.latece.sboa.impl.ograph;

import ca.uqam.info.latece.sboa.inter.ograph.Vertice;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.Vector;
import org.semanticweb.owl.model.OWLEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerticeImpl
implements Vertice {
    private int Id;
    private String category;
    private String label;
    private String comments;
    private String annotation;
    private double score;
    private OWLEntity oe1;
    private OWLEntity oe2;
    private Vector<TreeSet<Integer>> tailNeighborhood = null;
    private Vector<TreeSet<Integer>> headNeighborhood = null;
    private Vector<ArrayList<Integer>> tailOfEdges = null;
    private Vector<ArrayList<Integer>> headOfEdges = null;
    private int[] tNeighLen = null;
    private int[] hNeighLen = null;
    private int tNeighSz = 0;
    private int hNeighSz = 0;
    private int nOfEdgeslab = 0;

    public VerticeImpl() {
    }

    public VerticeImpl(int n, String string, String string2, String string3, String string4, double d, OWLEntity oWLEntity, OWLEntity oWLEntity2) {
        this.setCategory(string);
        this.setId(n);
        this.setLabel(string2);
        this.setComments(string3);
        this.setWeight(d);
        this.setFirstEntity(oWLEntity);
        this.setSecondEntity(oWLEntity2);
        this.setAnnotation(string4);
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public String getAnnotation() {
        return this.annotation;
    }

    @Override
    public OWLEntity getFirstEntity() {
        return this.oe1;
    }

    @Override
    public OWLEntity getSecondEntity() {
        return this.oe2;
    }

    @Override
    public int getId() {
        return this.Id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public double getWeight() {
        return this.score;
    }

    @Override
    public void setCategory(String string) {
        this.category = string;
    }

    @Override
    public void setComments(String string) {
        this.comments = string;
    }

    @Override
    public void setAnnotation(String string) {
        this.annotation = string;
    }

    @Override
    public void setFirstEntity(OWLEntity oWLEntity) {
        this.oe1 = oWLEntity;
    }

    @Override
    public void setSecondEntity(OWLEntity oWLEntity) {
        this.oe2 = oWLEntity;
    }

    @Override
    public void setId(int n) {
        this.Id = n;
    }

    @Override
    public void setLabel(String string) {
        this.label = string;
    }

    @Override
    public void setWeight(double d) {
        this.score = d;
    }

    @Override
    public void view() {
        System.err.println("Vertice-" + this.Id);
        System.err.println("\tCategory = " + this.category);
        System.err.println("\tLabel = " + this.label);
        System.err.println("\tScore = " + this.score);
        System.err.println("\tComments = " + this.comments);
        System.err.println("\tAnnotation = " + this.annotation);
        System.err.println("\tHead Neighbor of " + this.hNeighSz + " vertice : " + this.getNeighborhood(true).toString());
        System.err.println("\tTail Neighbor of " + this.tNeighSz + " vertice : " + this.getNeighborhood(false).toString());
    }

    @Override
    public void clearAll() {
        this.oe1 = null;
        this.oe2 = null;
        this.label = null;
        this.category = null;
        this.comments = null;
        this.tailNeighborhood.clear();
        this.tailNeighborhood = null;
        this.headNeighborhood.clear();
        this.headNeighborhood = null;
        this.tailOfEdges.clear();
        this.tailOfEdges = null;
        this.headOfEdges.clear();
        this.headOfEdges = null;
        this.tNeighLen = null;
        this.hNeighLen = null;
    }

    @Override
    public void setNumberOfEdgesLabels(int n) {
        this.nOfEdgeslab = n;
        this.tNeighSz = 0;
        this.hNeighSz = 0;
        this.tNeighLen = new int[this.nOfEdgeslab];
        this.hNeighLen = new int[this.nOfEdgeslab];
        this.tailNeighborhood = new Vector(this.nOfEdgeslab);
        this.headNeighborhood = new Vector(this.nOfEdgeslab);
        this.tailOfEdges = new Vector(this.nOfEdgeslab);
        this.headOfEdges = new Vector(this.nOfEdgeslab);
        for (int i = 0; i < this.nOfEdgeslab; ++i) {
            this.tailNeighborhood.insertElementAt(new TreeSet(), i);
            this.headNeighborhood.insertElementAt(new TreeSet(), i);
            this.tailOfEdges.insertElementAt(new ArrayList(), i);
            this.headOfEdges.insertElementAt(new ArrayList(), i);
            this.tNeighLen[i] = 0;
            this.hNeighLen[i] = 0;
        }
    }

    @Override
    public void insertNeighId(int n, int n2, boolean bl) {
        Integer n3 = new Integer(n);
        if (bl) {
            boolean bl2 = this.headNeighborhood.elementAt(n2).add(n3);
            if (bl2) {
                int n4 = n2;
                this.hNeighLen[n4] = this.hNeighLen[n4] + 1;
                ++this.hNeighSz;
            }
        } else {
            boolean bl3 = this.tailNeighborhood.elementAt(n2).add(n3);
            if (bl3) {
                int n5 = n2;
                this.tNeighLen[n5] = this.tNeighLen[n5] + 1;
                ++this.tNeighSz;
            }
        }
    }

    @Override
    public void insertEdgeId(int n, int n2, boolean bl) {
        Integer n3 = new Integer(n);
        if (bl) {
            this.headOfEdges.elementAt(n2).add(n3);
        } else {
            this.tailOfEdges.elementAt(n2).add(n3);
        }
    }

    @Override
    public ArrayList<Integer> getNeighborhood(int n, boolean bl) {
        if (bl) {
            TreeSet<Integer> treeSet = this.headNeighborhood.elementAt(n);
            return new ArrayList<Integer>(treeSet);
        }
        TreeSet<Integer> treeSet = this.tailNeighborhood.elementAt(n);
        return new ArrayList<Integer>(treeSet);
    }

    @Override
    public ArrayList<Integer> getEdges(int n, boolean bl) {
        if (bl) {
            return this.headOfEdges.elementAt(n);
        }
        return this.tailOfEdges.elementAt(n);
    }

    @Override
    public ArrayList<Integer> getNeighborhood(boolean bl) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (bl) {
            for (int i = 0; i < this.nOfEdgeslab; ++i) {
                ArrayList<Integer> arrayList2 = this.getNeighborhood(i, true);
                arrayList.addAll(arrayList2);
            }
        } else {
            for (int i = 0; i < this.nOfEdgeslab; ++i) {
                ArrayList<Integer> arrayList3 = this.getNeighborhood(i, false);
                arrayList.addAll(arrayList3);
            }
        }
        return arrayList;
    }

    @Override
    public ArrayList<Integer> getEdges(boolean bl) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (bl) {
            for (int i = 0; i < this.nOfEdgeslab; ++i) {
                ArrayList<Integer> arrayList2 = this.getEdges(i, true);
                arrayList.addAll(arrayList2);
            }
        } else {
            for (int i = 0; i < this.nOfEdgeslab; ++i) {
                ArrayList<Integer> arrayList3 = this.getEdges(i, false);
                arrayList.addAll(arrayList3);
            }
        }
        return arrayList;
    }

    @Override
    public int getNeighborhoodSize(int n, boolean bl) {
        if (bl) {
            return this.hNeighLen[n];
        }
        return this.tNeighLen[n];
    }

    @Override
    public int getNeighborhoodSize(boolean bl) {
        if (bl) {
            return this.hNeighSz;
        }
        return this.tNeighSz;
    }
}

