/*
 * Decompiled with CFR 0.152.
 */
package ca.uqam.info.latece.sboa.impl.ograph;

import ca.uqam.info.latece.sboa.impl.amatrix.AdjacencyMatrixImpl;
import ca.uqam.info.latece.sboa.impl.ograph.EdgesPoolImpl;
import ca.uqam.info.latece.sboa.impl.ograph.VerticesPoolImpl;
import ca.uqam.info.latece.sboa.inter.amatrix.AdjacencyMatrix;
import ca.uqam.info.latece.sboa.inter.ograph.Edge;
import ca.uqam.info.latece.sboa.inter.ograph.EdgesPool;
import ca.uqam.info.latece.sboa.inter.ograph.OntologyGraph;
import ca.uqam.info.latece.sboa.inter.ograph.Vertice;
import ca.uqam.info.latece.sboa.inter.ograph.VerticesPool;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.TreeSet;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyGraphImpl
implements OntologyGraph {
    private VerticesPool vPool = null;
    private EdgesPool ePool = null;
    private int nOfStaticWeightVertices = 0;
    String[] catRep = null;
    String[] labRep = null;
    boolean annUsed = false;

    public OntologyGraphImpl() {
    }

    public OntologyGraphImpl(String[] stringArray, String[] stringArray2) {
        this.init(stringArray, stringArray2);
    }

    @Override
    public void init(String[] stringArray, String[] stringArray2) {
        int n = stringArray2.length;
        this.vPool = new VerticesPoolImpl(stringArray, n);
        this.ePool = new EdgesPoolImpl(stringArray2);
    }

    @Override
    public void ImprovedBuild(Object[] objectArray, Object[] objectArray2, String string) {
    }

    @Override
    public void StraightforwardBuild(Object[] objectArray, Object[] objectArray2) {
        this.vPool.insertAll(objectArray);
        this.ePool.insertAll(objectArray2);
        this.upgradeVerticePool();
    }

    @Override
    public EdgesPool getEdgePool() {
        return this.ePool;
    }

    @Override
    public VerticesPool getVerticePool() {
        return this.vPool;
    }

    @Override
    public void upgradeVerticePool() {
        String[] stringArray = this.ePool.getPartsNames();
        int n = this.ePool.numberOfPart();
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            Object[] objectArray = this.ePool.getAll(string);
            int n2 = this.ePool.partSize(string);
            for (int j = 0; j < n2; ++j) {
                Edge edge = (Edge)objectArray[j];
                int n3 = edge.getId();
                int n4 = edge.getHead();
                int n5 = edge.getTail();
                ((Vertice)this.vPool.get(n4)).insertNeighId(n5, i, true);
                ((Vertice)this.vPool.get(n5)).insertNeighId(n4, i, false);
                ((Vertice)this.vPool.get(n4)).insertEdgeId(n3, i, true);
                ((Vertice)this.vPool.get(n5)).insertEdgeId(n3, i, false);
            }
        }
    }

    @Override
    public AdjacencyMatrix getCategoryAdjacencyMatrix(String string, String string2) {
        int n;
        Object[] objectArray = this.getLabelCandidate(string, string2);
        HashSet<Integer> hashSet = this.getTailCandidate(string, string2);
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        int n2 = objectArray.length;
        for (n = 0; n < n2; ++n) {
            int n3 = (Integer)objectArray[n];
            Edge edge = (Edge)this.ePool.get(n3);
            int n4 = edge.getTail();
            if (!hashSet.contains(new Integer(n4))) continue;
            arrayList.add(edge);
        }
        n = arrayList.size();
        Edge[] edgeArray = new Edge[n];
        for (int i = 0; i < n; ++i) {
            edgeArray[i] = (Edge)arrayList.get(i);
        }
        AdjacencyMatrixImpl adjacencyMatrixImpl = new AdjacencyMatrixImpl(edgeArray);
        return adjacencyMatrixImpl;
    }

    private Object[] getLabelCandidate(String string, String string2) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Object[] objectArray = this.vPool.getAll(string);
        int n = this.vPool.partSize(string);
        for (int i = 0; i < n; ++i) {
            ArrayList<Integer> arrayList = ((Vertice)objectArray[i]).getEdges(true);
            hashSet.addAll(arrayList);
        }
        return hashSet.toArray();
    }

    private HashSet<Integer> getTailCandidate(String string, String string2) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Object[] objectArray = this.vPool.getAll(string2);
        int n = this.vPool.partSize(string2);
        for (int i = 0; i < n; ++i) {
            Integer n2 = ((Vertice)objectArray[i]).getId();
            hashSet.add(n2);
        }
        return hashSet;
    }

    @Override
    public AdjacencyMatrix getCategoryMatrix() {
        String[] stringArray = this.vPool.getPartsNames();
        int n = this.vPool.numberOfPart();
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        int[] nArray = this.getCategoryMatrixVerticeIds(stringArray, n, hashtable);
        Matrix matrix = this.createCategoryMatrix(stringArray, n, nArray.length, hashtable);
        AdjacencyMatrixImpl adjacencyMatrixImpl = new AdjacencyMatrixImpl("CategoryMatrix", "Matrix", matrix, nArray, nArray);
        return adjacencyMatrixImpl;
    }

    @Override
    public int[] getCategoryMatrixVerticeIds(String[] stringArray, int n, Hashtable<Integer, Integer> hashtable) {
        int n2;
        Object[] objectArray;
        int n3;
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n3 = 0; n3 < n; ++n3) {
            objectArray = this.vPool.getAll(stringArray[n3]);
            n2 = this.vPool.partSize(stringArray[n3]);
            treeSet.clear();
            for (int i = 0; i < n2; ++i) {
                Vertice vertice = (Vertice)objectArray[i];
                treeSet.add(vertice.getId());
            }
            for (Integer n4 : treeSet) {
                arrayList.add(n4);
            }
        }
        n3 = this.vPool.size();
        objectArray = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = (Integer)arrayList.get(n2);
            objectArray[n2] = n4;
            hashtable.put(n4, new Integer(n2));
        }
        return objectArray;
    }

    @Override
    public Matrix createCategoryMatrix(String[] stringArray, int n, int n2, Hashtable<Integer, Integer> hashtable) {
        FlexCompRowMatrix flexCompRowMatrix = new FlexCompRowMatrix(n2, n2);
        Object[] objectArray = this.ePool.getAll();
        int n3 = this.ePool.size();
        for (int i = 0; i < n3; ++i) {
            Edge edge = (Edge)objectArray[i];
            int n4 = edge.getHead();
            int n5 = edge.getTail();
            int n6 = hashtable.get(new Integer(n4));
            int n7 = hashtable.get(new Integer(n5));
            flexCompRowMatrix.set(n7, n6, edge.getWeight());
        }
        return flexCompRowMatrix;
    }

    @Override
    public AdjacencyMatrix getLabelAdjacencyMatrix(String string) {
        Object[] objectArray = this.ePool.getAll(string);
        int n = objectArray.length;
        Edge[] edgeArray = new Edge[n];
        for (int i = 0; i < n; ++i) {
            edgeArray[i] = (Edge)objectArray[i];
        }
        AdjacencyMatrixImpl adjacencyMatrixImpl = new AdjacencyMatrixImpl(edgeArray);
        return adjacencyMatrixImpl;
    }

    @Override
    public AdjacencyMatrix[] getLabelMatrices() {
        int n = this.ePool.numberOfPart();
        AdjacencyMatrix[] adjacencyMatrixArray = new AdjacencyMatrix[n];
        String[] stringArray = this.ePool.getPartsNames();
        for (int i = 0; i < n; ++i) {
            adjacencyMatrixArray[i] = this.getLabelAdjacencyMatrix(stringArray[i]);
        }
        return adjacencyMatrixArray;
    }

    @Override
    public Vector getInitialVector(int[] nArray, int n) {
        DenseVector denseVector = new DenseVector(n);
        for (int i = 0; i < n; ++i) {
            Vertice vertice = (Vertice)this.vPool.get(nArray[i]);
            denseVector.add(i, vertice.getWeight());
        }
        return denseVector;
    }

    @Override
    public int[] getStaticWeightVertices(String[] stringArray, int n) {
        this.nOfStaticWeightVertices = 0;
        for (int i = 0; i < n; ++i) {
            this.nOfStaticWeightVertices += this.vPool.partSize(stringArray[i]);
        }
        int[] nArray = new int[this.nOfStaticWeightVertices];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ArrayList<Integer> arrayList = this.vPool.getAllIds(stringArray[i]);
            int n3 = this.vPool.partSize(stringArray[i]);
            for (int j = 0; j < n3; ++j) {
                Integer n4 = arrayList.get(j);
                nArray[n2] = n4;
                ++n2;
            }
        }
        return nArray;
    }

    @Override
    public int getNumberOfStaticWeightVertices() {
        return this.nOfStaticWeightVertices;
    }

    @Override
    public void insertEdge(Object object) {
        this.ePool.insert(object);
    }

    @Override
    public void insertEdge(Object[] objectArray) {
        this.ePool.insertAll(objectArray);
    }

    @Override
    public void insertVertice(Object object) {
        this.vPool.insert(object);
    }

    @Override
    public void insertVertice(Object[] objectArray) {
        this.vPool.insertAll(objectArray);
    }

    @Override
    public void getResume() {
        String[] stringArray;
        int n;
        System.err.println("Number of vertices = " + this.vPool.size());
        int n2 = this.vPool.numberOfPart();
        String[] stringArray2 = this.vPool.getPartsNames();
        for (n = 0; n < n2; ++n) {
            stringArray = stringArray2[n];
            System.err.println("\t" + (String)stringArray + ": " + this.vPool.partSize((String)stringArray) + " vertices");
        }
        System.err.println("Number of edges = " + this.ePool.size());
        n = this.ePool.numberOfPart();
        stringArray = this.ePool.getPartsNames();
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            System.err.println("\t" + string + ": " + this.ePool.partSize(string) + " edges");
        }
    }

    @Override
    public String concactLabels(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        Object[] objectArray = this.vPool.getAll(string);
        int n = this.vPool.partSize(string);
        for (int i = 0; i < n; ++i) {
            Vertice vertice = (Vertice)objectArray[i];
            hashSet.add(vertice.getLabel());
        }
        String string2 = hashSet.toString();
        string2 = string2.replace(" ", "");
        string2 = string2.replace(",", "");
        string2 = string2.replace("[", "");
        string2 = string2.replace("]", "");
        return string2.toString();
    }

    private String getVerticeConfig(Vertice vertice) {
        int n;
        int n2;
        String string = "";
        int n3 = this.ePool.numberOfPart();
        for (n2 = 0; n2 < n3; ++n2) {
            n = vertice.getNeighborhoodSize(n2, true);
            string = string + Integer.toString(n);
        }
        string = string + ":";
        for (n2 = 0; n2 < n3; ++n2) {
            n = vertice.getNeighborhoodSize(n2, false);
            string = string + Integer.toString(n);
        }
        return string;
    }

    @Override
    public String defaultName(Vertice vertice, String[] stringArray, int[] nArray, int n, TreeSet<Integer> treeSet) {
        int n2;
        String string = vertice.getComments();
        String string2 = this.getVerticeConfig(vertice);
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            n3 += vertice.getNeighborhoodSize(nArray[n2], true);
        }
        if (n3 > 0 && string.equalsIgnoreCase("")) {
            for (n2 = 0; n2 < n; ++n2) {
                ArrayList<Integer> arrayList = vertice.getNeighborhood(nArray[n2], true);
                int n4 = vertice.getNeighborhoodSize(nArray[n2], true);
                for (int i = 0; i < n4; ++i) {
                    int n5 = arrayList.get(i);
                    Vertice vertice2 = (Vertice)this.vPool.get(n5);
                    String string3 = vertice.getCategory();
                    String string4 = this.catRep[this.vPool.getPartId(string3)];
                    Integer n6 = new Integer(vertice2.getId());
                    boolean bl = treeSet.contains(n6);
                    if (vertice.getId() == vertice2.getId() || bl) continue;
                    treeSet.add(n6);
                    string = string + "(" + this.defaultName(vertice2, stringArray, nArray, n, treeSet) + "+" + stringArray[n2] + ":" + string4 + string2 + ")";
                }
            }
        } else if (n3 == 0) {
            String string5 = vertice.getCategory();
            String string6 = this.catRep[this.vPool.getPartId(string5)];
            string = "(x:" + string6 + string2 + ")";
        }
        vertice.setComments(string);
        return string;
    }

    @Override
    public void setRepresentatives(String[] stringArray, String[] stringArray2) {
        int n = this.vPool.numberOfPart();
        int n2 = this.ePool.numberOfPart();
        if (n != stringArray.length || n2 != stringArray2.length) {
            System.err.println("Strict representatives needed");
            System.exit(1);
        } else {
            int n3;
            this.catRep = new String[n];
            this.labRep = new String[n2];
            for (n3 = 0; n3 < n; ++n3) {
                this.catRep[n3] = stringArray[n3];
            }
            for (n3 = 0; n3 < n2; ++n3) {
                this.labRep[n3] = stringArray2[n3];
            }
        }
    }

    @Override
    public String[] buildRepresentatives(String[] stringArray) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            int n2 = this.ePool.getPartId(stringArray[i]);
            stringArray2[i] = this.labRep[n2];
        }
        return stringArray2;
    }

    private void buildDefaultNameOfParts(String[] stringArray, String[] stringArray2) {
        int n;
        int n2 = 0;
        int n3 = stringArray.length;
        int n4 = stringArray2.length;
        int[] nArray = new int[n4];
        Object[] objectArray = this.buildRoots(stringArray);
        String[] stringArray3 = this.buildRepresentatives(stringArray2);
        for (n = 0; n < n3; ++n) {
            n2 += this.vPool.partSize(stringArray[n]);
        }
        for (n = 0; n < n4; ++n) {
            nArray[n] = this.ePool.getPartId(stringArray2[n]);
        }
        for (n = 0; n < n2; ++n) {
            Vertice vertice = (Vertice)objectArray[n];
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            treeSet.add(new Integer(vertice.getId()));
            this.defaultName(vertice, stringArray3, nArray, n4, treeSet);
        }
    }

    @Override
    public void buildAllDefaultNames(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) {
        this.buildDefaultNameOfParts(stringArray, stringArray2);
        this.buildDefaultNameOfParts(stringArray3, stringArray4);
    }

    public Object[] buildRoots(String[] stringArray) {
        ArrayList<Vertice> arrayList = new ArrayList<Vertice>();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = this.vPool.getAll(stringArray[i]);
            int n2 = this.vPool.partSize(stringArray[i]);
            for (int j = 0; j < n2; ++j) {
                arrayList.add((Vertice)objectArray[j]);
            }
        }
        return arrayList.toArray();
    }

    @Override
    public void createGraphMLFile(String string, String string2) {
        try {
            FileWriter fileWriter = new FileWriter(string2);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            this.initGraphMLFile(printWriter, string);
            this.insertVerticesInGraphMLFile(printWriter);
            this.insertEdgesInGraphMLFile(printWriter);
            this.finalizeGraphMLFile(printWriter);
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void clearAll() {
        this.ePool.clearAll();
        this.ePool = null;
    }

    @Override
    public void initGraphMLFile(PrintWriter printWriter, String string) {
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printWriter.println("<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns/graphml\" xmlns:y=\"http://www.yworks.com/xml/graphml\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns/graphml http://www.yworks.com/xml/schema/graphml/1.0/ygraphml.xsd\">");
        printWriter.println("<key id=\"d0\" for=\"node\" yfiles.type=\"nodegraphics\"/>");
        printWriter.println("<key id=\"d1\" for=\"edge\" yfiles.type=\"edgegraphics\"/>");
        printWriter.println("<graph id=\"" + string + "\" edgedefault=\"directed\">");
    }

    @Override
    public void insertVerticesInGraphMLFile(PrintWriter printWriter) {
        String[] stringArray = this.vPool.getPartsNames();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = this.vPool.getAll(stringArray[i]);
            int n2 = objectArray.length;
            for (int j = 0; j < n2; ++j) {
                Vertice vertice = (Vertice)objectArray[j];
                int n3 = vertice.getId();
                String string = vertice.getLabel();
                printWriter.println("<node id=\"n" + n3 + "\">");
                printWriter.println("\t<data key=\"d0\" >");
                printWriter.println("\t\t<y:ShapeNode >");
                printWriter.println("\t\t\t<y:NodeLabel>" + string + "</y:NodeLabel>");
                printWriter.println("<y:Shape type=\"" + this.getVerticeShape(stringArray[i]) + "\"/>");
                printWriter.println("\t\t</y:ShapeNode>");
                printWriter.println("\t</data>");
                printWriter.println("</node>");
            }
        }
    }

    @Override
    public void insertEdgesInGraphMLFile(PrintWriter printWriter) {
        String[] stringArray = this.ePool.getPartsNames();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = this.ePool.getAll(stringArray[i]);
            int n2 = objectArray.length;
            for (int j = 0; j < n2; ++j) {
                Edge edge = (Edge)objectArray[j];
                int n3 = edge.getId();
                String string = edge.getLabel();
                int n4 = edge.getHead();
                int n5 = edge.getTail();
                printWriter.println("<edge id=\"e" + n3 + "\" source=\"" + "n" + n4 + "\" target=\"" + "n" + n5 + "\">");
                printWriter.println("\t<data key=\"d1\" >");
                printWriter.println("\t\t<y:PolyLineEdge >");
                printWriter.println("\t\t\t<y:EdgeLabel>" + string + "</y:EdgeLabel>");
                printWriter.println("\t\t\t<y:BendStyle smoothed=\"false\"/>");
                printWriter.println("\t\t</y:PolyLineEdge>");
                printWriter.println("\t</data>");
                printWriter.println("</edge>");
            }
        }
    }

    @Override
    public String getVerticeShape(String string) {
        String string2 = null;
        string2 = string.equalsIgnoreCase("Class") ? "rectangle" : (string.equalsIgnoreCase("Token") ? "octagon" : (string.equalsIgnoreCase("Relation") ? "hexagon" : (string.equalsIgnoreCase("Property") ? "parallelogram" : (string.equalsIgnoreCase("DataType") ? "diamond" : (string.equalsIgnoreCase("Cardinality") ? "roundrectangle" : (string.equalsIgnoreCase("Object") ? "triangle" : (string.equalsIgnoreCase("PropertyInstance") ? "trapezoid" : "ellipse")))))));
        return string2;
    }

    @Override
    public void finalizeGraphMLFile(PrintWriter printWriter) {
        printWriter.println("</graph>");
        printWriter.println("</graphml>");
    }

    @Override
    public void viewAll() {
        this.vPool.viewAllVertices();
        this.ePool.viewAllEdges();
    }
}

