/*
 * Decompiled with CFR 0.152.
 */
package ca.uqam.info.latece.sboa.impl.ograph;

import ca.uqam.info.latece.sboa.inter.ograph.Edge;
import ca.uqam.info.latece.sboa.inter.ograph.EdgesPool;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgesPoolImpl
implements EdgesPool {
    private String[] labelNames = null;
    private Hashtable<String, Integer> edgeLabelToId = new Hashtable();
    private Vector<ArrayList<Integer>> idsGroupedByLabel = null;
    private Hashtable<Integer, Edge> edgeIdToEdges = new Hashtable();
    private int[] labelGroupsLen = null;
    private int size = 0;
    private int numberOfLabels = 0;

    public EdgesPoolImpl() {
    }

    public EdgesPoolImpl(String[] stringArray) {
        this.init(stringArray);
    }

    @Override
    public int numberOfPart() {
        return this.numberOfLabels;
    }

    @Override
    public int getPartId(String string) {
        return this.edgeLabelToId.get(string);
    }

    @Override
    public boolean contains(String string) {
        return this.edgeLabelToId.containsKey(string);
    }

    @Override
    public boolean contains(int n) {
        Integer n2 = new Integer(n);
        return this.edgeIdToEdges.containsKey(n2);
    }

    @Override
    public Object get(int n) {
        Integer n2 = new Integer(n);
        return this.edgeIdToEdges.get(n2);
    }

    @Override
    public Object[] getAll(String string) {
        Integer n = this.edgeLabelToId.get(string);
        int n2 = this.labelGroupsLen[n];
        Object[] objectArray = new Object[n2];
        ArrayList<Integer> arrayList = this.idsGroupedByLabel.elementAt(n);
        for (int i = 0; i < n2; ++i) {
            Integer n3 = arrayList.get(i);
            objectArray[i] = this.get(n3);
        }
        return objectArray;
    }

    @Override
    public Object[] getAll() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.numberOfLabels; ++i) {
            Object[] objectArray = this.getAll(this.labelNames[i]);
            int n = this.partSize(this.labelNames[i]);
            for (int j = 0; j < n; ++j) {
                arrayList.add(objectArray[j]);
            }
        }
        return arrayList.toArray();
    }

    @Override
    public Object[] getEdgesBetween(ArrayList<Integer> arrayList, ArrayList<Integer> arrayList2) {
        int n;
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        int n2 = 0;
        for (int i = 0; i < this.numberOfLabels; ++i) {
            for (n = 0; n < this.labelGroupsLen[i]; ++n) {
                int n3 = this.idsGroupedByLabel.elementAt(i).get(n);
                Integer n4 = new Integer(n3);
                Edge edge = this.edgeIdToEdges.get(n4);
                Integer n5 = new Integer(edge.getHead());
                Integer n6 = new Integer(edge.getTail());
                if (!arrayList.contains(n5) || !arrayList2.contains(n6)) continue;
                arrayList3.add(n4);
                ++n2;
            }
        }
        Object[] objectArray = new Object[n2];
        for (n = 0; n < n2; ++n) {
            Integer n7 = (Integer)arrayList3.get(n);
            objectArray[n] = this.get(n7);
        }
        return objectArray;
    }

    @Override
    public Object[] getAll(int[] nArray) {
        int n = nArray.length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.get(nArray[i]);
        }
        return objectArray;
    }

    @Override
    public String[] getPartsNames() {
        return this.labelNames;
    }

    @Override
    public void init(String[] stringArray) {
        int n = stringArray.length;
        this.labelNames = new String[n];
        this.idsGroupedByLabel = new Vector(n);
        this.labelGroupsLen = new int[n];
        for (int i = 0; i < n; ++i) {
            this.labelNames[i] = stringArray[i];
            this.edgeLabelToId.put(this.labelNames[i], i);
            this.idsGroupedByLabel.insertElementAt(new ArrayList(), i);
            this.labelGroupsLen[i] = 0;
            ++this.numberOfLabels;
        }
    }

    @Override
    public void insert(Object object) {
        Edge edge = (Edge)object;
        String string = edge.getLabel();
        int n = edge.getId();
        Integer n2 = new Integer(n);
        Integer n3 = this.edgeLabelToId.get(string);
        this.idsGroupedByLabel.elementAt(n3).add(n2);
        this.edgeIdToEdges.put(n2, edge);
        int n4 = n3;
        this.labelGroupsLen[n4] = this.labelGroupsLen[n4] + 1;
        ++this.size;
    }

    @Override
    public void insertAll(Object[] objectArray) {
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            this.insert(objectArray[i]);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int partSize(String string) {
        Integer n = this.edgeLabelToId.get(string);
        return this.labelGroupsLen[n];
    }

    @Override
    public void remove(int n) {
        Edge edge = (Edge)this.get(n);
        String string = edge.getLabel();
        Integer n2 = this.edgeLabelToId.get(string);
        Integer n3 = new Integer(n);
        this.idsGroupedByLabel.elementAt(n2).remove(n3);
        int n4 = n2;
        this.labelGroupsLen[n4] = this.labelGroupsLen[n4] - 1;
        --this.size;
        this.edgeIdToEdges.remove(n3);
        this.edgeLabelToId.remove(string);
    }

    @Override
    public void removeAll(String string) {
        Integer n = this.edgeLabelToId.get(string);
        int n2 = this.labelGroupsLen[n];
        ArrayList<Integer> arrayList = this.idsGroupedByLabel.elementAt(n);
        for (int i = 0; i < n2; ++i) {
            Integer n3 = arrayList.get(i);
            this.remove(n3);
        }
    }

    @Override
    public void removeAll(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            this.remove(nArray[i]);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void viewAllEdges() {
        for (int i = 0; i < this.numberOfLabels; ++i) {
            String string = this.labelNames[i];
            Object[] objectArray = this.getAll(string);
            int n = this.partSize(string);
            for (int j = 0; j < n; ++j) {
                ((Edge)objectArray[j]).view();
            }
        }
    }

    @Override
    public void clearAll() {
        this.labelNames = null;
        this.edgeLabelToId.clear();
        this.idsGroupedByLabel.clear();
        this.edgeIdToEdges.clear();
    }
}

