/*
 * Decompiled with CFR 0.152.
 */
package ca.uqam.info.latece.sboa.impl.mgraph;

import ca.uqam.info.latece.sboa.impl.ograph.EdgeImpl;
import ca.uqam.info.latece.sboa.impl.ograph.OntologyGraphImpl;
import ca.uqam.info.latece.sboa.impl.ograph.VerticeImpl;
import ca.uqam.info.latece.sboa.inter.mgraph.MatchGraphs;
import ca.uqam.info.latece.sboa.inter.ograph.Edge;
import ca.uqam.info.latece.sboa.inter.ograph.EdgesPool;
import ca.uqam.info.latece.sboa.inter.ograph.OntologyGraph;
import ca.uqam.info.latece.sboa.inter.ograph.Vertice;
import ca.uqam.info.latece.sboa.inter.ograph.VerticesPool;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import org.semanticweb.owl.model.OWLEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchGraphsImpl
implements MatchGraphs {
    private EdgesPool ePool1 = null;
    private EdgesPool ePool2 = null;
    private VerticesPool vPool1 = null;
    private VerticesPool vPool2 = null;
    private String[] lab1 = null;
    private String[] cat1 = null;
    private String[] lab2 = null;
    private String[] cat2 = null;
    private int lsz1 = 0;
    private int csz1 = 0;
    private int lsz2 = 0;
    private int csz2 = 0;
    private int vId = 0;
    private int eId = 0;
    private int hd = 0;
    private int tl = 0;
    private ArrayList<Vertice> vSet = new ArrayList();
    private ArrayList<Edge> eSet = new ArrayList();
    private Hashtable<String, Integer> stringToId = new Hashtable();
    private Hashtable<String, Integer> lab1ToId = new Hashtable();
    private Hashtable<String, Integer> lab2ToId = new Hashtable();
    private Hashtable<String, Integer> cat1ToId = new Hashtable();
    private Hashtable<String, Integer> cat2ToId = new Hashtable();
    private Hashtable<Integer, Integer> leftCorr = new Hashtable();
    private Hashtable<Integer, Integer> rightCorr = new Hashtable();
    private boolean defaultInit;

    public MatchGraphsImpl() {
    }

    public MatchGraphsImpl(OntologyGraph ontologyGraph, OntologyGraph ontologyGraph2) {
        this.init(ontologyGraph, ontologyGraph2);
    }

    @Override
    public void init(OntologyGraph ontologyGraph, OntologyGraph ontologyGraph2) {
        this.lsz1 = ontologyGraph.getEdgePool().numberOfPart();
        this.lsz2 = ontologyGraph2.getEdgePool().numberOfPart();
        this.ePool1 = (EdgesPool)ontologyGraph.getEdgePool();
        this.ePool2 = (EdgesPool)ontologyGraph2.getEdgePool();
        this.vPool1 = (VerticesPool)ontologyGraph.getVerticePool();
        this.vPool2 = (VerticesPool)ontologyGraph2.getVerticePool();
        this.lab1 = this.ePool1.getPartsNames();
        this.lab2 = this.ePool2.getPartsNames();
        this.cat1 = this.vPool1.getPartsNames();
        this.cat2 = this.vPool2.getPartsNames();
        this.csz1 = this.vPool1.numberOfPart();
        this.csz2 = this.vPool2.numberOfPart();
    }

    @Override
    public void verticesProduct(String[] stringArray, String string, String string2, boolean bl) {
        this.defaultInit = bl;
        int n = stringArray.length;
        boolean bl2 = this.verticesCompatibilityTest(stringArray, n, true);
        if (bl2) {
            for (int i = 0; i < n; ++i) {
                int n2 = this.cat1ToId.get(stringArray[i]);
                Object[] objectArray = this.vPool1.getAll(this.cat1[n2]);
                int n3 = this.vPool1.partSize(this.cat1[n2]);
                int n4 = this.cat2ToId.get(stringArray[i]);
                Object[] objectArray2 = this.vPool2.getAll(this.cat2[n4]);
                int n5 = this.vPool2.partSize(this.cat2[n4]);
                this.productOfSameCategoryVertice(objectArray, n3, objectArray2, n5, string, string2, false);
            }
        }
    }

    private void productOfSameCategoryVertice(Object[] objectArray, int n, Object[] objectArray2, int n2, String string, String string2, boolean bl) {
        for (int i = 0; i < n; ++i) {
            System.err.println("here");
            Vertice vertice = (Vertice)objectArray[i];
            for (int j = 0; j < n2; ++j) {
                Vertice vertice2 = (Vertice)objectArray2[j];
                if (!bl) {
                    this.createVertice(vertice, vertice2, string, string2);
                    continue;
                }
                int n3 = vertice2.getNeighborhoodSize(true) + vertice2.getNeighborhoodSize(false);
                if (n3 <= 0) continue;
                this.createVertice(vertice, vertice2, string, string2);
            }
        }
    }

    private boolean verticesCompatibilityTest(String[] stringArray, int n, boolean bl) {
        int n2;
        boolean bl2 = true;
        if (bl) {
            this.vId = 0;
            this.eId = 0;
            this.vSet.clear();
            this.eSet.clear();
        }
        this.cat1ToId.clear();
        this.cat2ToId.clear();
        for (n2 = 0; n2 < this.csz1; ++n2) {
            this.cat1ToId.put(this.cat1[n2], n2);
        }
        for (n2 = 0; n2 < this.csz2; ++n2) {
            this.cat2ToId.put(this.cat2[n2], n2);
        }
        for (n2 = 0; n2 < n; ++n2) {
            String string = stringArray[n2];
            if (this.cat1ToId.containsKey(string) && this.cat2ToId.containsKey(string)) {
                int n3 = this.cat1ToId.get(string);
                int n4 = this.cat2ToId.get(string);
                bl2 = bl2 && this.cat1[n3].equalsIgnoreCase(this.cat2[n4]);
                continue;
            }
            bl2 = false;
        }
        return bl2;
    }

    @Override
    public void categoricalProduct(String[] stringArray, String[] stringArray2, String string, String string2, boolean bl) {
        this.defaultInit = bl;
        int n = stringArray.length;
        boolean bl2 = this.edgesCompatibilityTest(stringArray, n, true);
        if (bl2) {
            for (int i = 0; i < n; ++i) {
                int n2 = this.lab1ToId.get(stringArray[i]);
                int n3 = this.lab2ToId.get(stringArray[i]);
                Object[] objectArray = this.ePool1.getAll(this.lab1[n2]);
                Object[] objectArray2 = this.ePool2.getAll(this.lab2[n3]);
                int n4 = this.ePool1.partSize(this.lab1[n2]);
                int n5 = this.ePool2.partSize(this.lab2[n3]);
                this.createVerticesAndEdges(objectArray, objectArray2, n4, n5, string, string2);
            }
        } else {
            System.err.println("Input graphs are not compatible");
        }
    }

    private boolean edgesCompatibilityTest(String[] stringArray, int n, boolean bl) {
        int n2;
        boolean bl2 = true;
        if (bl) {
            this.vId = 0;
            this.eId = 0;
            this.vSet.clear();
            this.eSet.clear();
        }
        this.lab1ToId.clear();
        this.lab2ToId.clear();
        for (n2 = 0; n2 < this.lsz1; ++n2) {
            this.lab1ToId.put(this.lab1[n2], n2);
        }
        for (n2 = 0; n2 < this.lsz2; ++n2) {
            this.lab2ToId.put(this.lab2[n2], n2);
        }
        for (n2 = 0; n2 < n; ++n2) {
            String string = stringArray[n2];
            if (this.lab1ToId.containsKey(string) && this.lab2ToId.containsKey(string)) {
                int n3 = this.lab1ToId.get(string);
                int n4 = this.lab2ToId.get(string);
                bl2 = bl2 && this.lab1[n3].equalsIgnoreCase(this.lab2[n4]);
                continue;
            }
            bl2 = false;
        }
        return bl2;
    }

    private void createVerticesAndEdges(Object[] objectArray, Object[] objectArray2, int n, int n2, String string, String string2) {
        for (int i = 0; i < n; ++i) {
            Edge edge = (Edge)objectArray[i];
            Vertice vertice = (Vertice)this.vPool1.get(edge.getHead());
            Vertice vertice2 = (Vertice)this.vPool1.get(edge.getTail());
            for (int j = 0; j < n2; ++j) {
                Edge edge2 = (Edge)objectArray2[j];
                Vertice vertice3 = (Vertice)this.vPool2.get(edge2.getHead());
                Vertice vertice4 = (Vertice)this.vPool2.get(edge2.getTail());
                boolean bl = this.sameEndPointCategoryTest(vertice, vertice3);
                boolean bl2 = this.sameEndPointCategoryTest(vertice2, vertice4);
                if (bl) {
                    this.hd = this.createVertice(vertice, vertice3, string, string2);
                }
                if (bl2) {
                    this.tl = this.createVertice(vertice2, vertice4, string, string2);
                }
                if (!bl || !bl2) continue;
                this.createEdge(edge, edge2);
            }
        }
    }

    private boolean sameEndPointCategoryTest(Vertice vertice, Vertice vertice2) {
        boolean bl = true;
        bl = vertice.getCategory().equalsIgnoreCase(vertice2.getCategory());
        return bl;
    }

    private int createVertice(Vertice vertice, Vertice vertice2, String string, String string2) {
        int n = this.vId++;
        String string3 = this.getIdentificationString(vertice, vertice2);
        if (!this.stringToId.containsKey(string3)) {
            String string4 = vertice.getCategory();
            String string5 = vertice.getLabel();
            String string6 = vertice2.getLabel();
            String string7 = "[" + string5 + "," + string6 + "]";
            double d = this.computeVerticeWeight(string, string2, string5.toLowerCase(), string6.toLowerCase());
            OWLEntity oWLEntity = vertice.getFirstEntity();
            OWLEntity oWLEntity2 = vertice2.getFirstEntity();
            VerticeImpl verticeImpl = new VerticeImpl(n, string4, string7, "", "", d, oWLEntity, oWLEntity2);
            this.vSet.add(verticeImpl);
            this.stringToId.put(string3, n);
            this.createCorrespondences(n, vertice.getId(), vertice2.getId());
        } else {
            n = this.stringToId.get(string3);
        }
        return n;
    }

    private double computeVerticeWeight(String string, String string2, String string3, String string4) {
        double d = 0.0;
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{String.class, String.class};
            Method method = clazz.getMethod(string2, classArray);
            Object[] objectArray = new Object[]{string3, string4};
            d = 1.0 - (Double)method.invoke(clazz, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d;
    }

    private void createCorrespondences(int n, int n2, int n3) {
        Integer n4 = new Integer(n);
        Integer n5 = new Integer(n2);
        Integer n6 = new Integer(n3);
        this.leftCorr.put(n4, n5);
        this.rightCorr.put(n4, n6);
    }

    private void createEdge(Edge edge, Edge edge2) {
        String string = edge.getLabel();
        double d = edge.getWeight() * edge2.getWeight();
        EdgeImpl edgeImpl = new EdgeImpl(this.eId, string, d, this.hd, this.tl);
        this.eSet.add(edgeImpl);
        ++this.eId;
    }

    @Override
    public Hashtable<Integer, Integer> getLeftCorrespondences() {
        return this.leftCorr;
    }

    @Override
    public Hashtable<Integer, Integer> getRightCorrespondences() {
        return this.rightCorr;
    }

    @Override
    public void clearAll() {
        this.ePool1.clearAll();
        this.ePool1 = null;
        this.ePool2.clearAll();
        this.ePool2 = null;
        this.lab1 = null;
        this.cat1 = null;
        this.lab2 = null;
        this.cat2 = null;
        this.vSet.clear();
        this.eSet.clear();
        this.stringToId.clear();
        this.lab1ToId.clear();
        this.lab2ToId.clear();
        this.cat1ToId.clear();
        this.cat2ToId.clear();
    }

    @Override
    public OntologyGraph getOntologyGraph() {
        OntologyGraphImpl ontologyGraphImpl = new OntologyGraphImpl(this.cat1, this.lab1);
        Object[] objectArray = this.vSet.toArray();
        Object[] objectArray2 = this.eSet.toArray();
        ontologyGraphImpl.StraightforwardBuild(objectArray, objectArray2);
        return ontologyGraphImpl;
    }

    private String getIdentificationString(Vertice vertice, Vertice vertice2) {
        String string = Integer.toString(vertice.getId()) + "x" + Integer.toString(vertice2.getId());
        return string;
    }
}

