/*
 * Decompiled with CFR 0.152.
 */
package ca.uqam.info.latece.sboa.impl.encodings;

import ca.uqam.info.latece.sboa.impl.ograph.EdgeImpl;
import ca.uqam.info.latece.sboa.impl.ograph.OntologyGraphImpl;
import ca.uqam.info.latece.sboa.impl.ograph.VerticeImpl;
import ca.uqam.info.latece.sboa.impl.utils.LabelTokenizer;
import ca.uqam.info.latece.sboa.impl.utils.OLATools;
import ca.uqam.info.latece.sboa.impl.weights.OLAWeightCapture;
import ca.uqam.info.latece.sboa.inter.encodings.OLAOntologyGraph;
import ca.uqam.info.latece.sboa.inter.ograph.Edge;
import ca.uqam.info.latece.sboa.inter.ograph.OntologyGraph;
import ca.uqam.info.latece.sboa.inter.ograph.Vertice;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.align.Parameters;
import org.semanticweb.owl.impl.model.OWLClassImpl;
import org.semanticweb.owl.impl.model.OWLConcreteDataImpl;
import org.semanticweb.owl.impl.model.OWLConcreteDataTypeImpl;
import org.semanticweb.owl.impl.model.OWLDataAllRestrictionImpl;
import org.semanticweb.owl.impl.model.OWLDataCardinalityRestrictionImpl;
import org.semanticweb.owl.impl.model.OWLDataPropertyImpl;
import org.semanticweb.owl.impl.model.OWLIndividualImpl;
import org.semanticweb.owl.impl.model.OWLObjectAllRestrictionImpl;
import org.semanticweb.owl.impl.model.OWLObjectCardinalityRestrictionImpl;
import org.semanticweb.owl.impl.model.OWLObjectPropertyImpl;
import org.semanticweb.owl.impl.model.OWLSubPropertyAxiomImpl;
import org.semanticweb.owl.model.OWLAnnotationInstance;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OLAOntologyGraphImpl
implements OLAOntologyGraph {
    private Object[] cSet;
    private Object[] dSet;
    private Object[] iSet;
    private Object[] dpSet;
    private Object[] opSet;
    private int csz = 0;
    private int dsz = 0;
    private int isz = 0;
    private int dpsz = 0;
    private int opsz = 0;
    private Hashtable<String, Integer> classToId = new Hashtable();
    private Hashtable<String, Integer> datatypeToId = new Hashtable();
    private Hashtable<String, Integer> relationToId = new Hashtable();
    private Hashtable<String, Integer> propertyToId = new Hashtable();
    private Hashtable<String, Integer> objectToId = new Hashtable();
    private Hashtable<String, Integer> propertyInstanceToId = new Hashtable();
    private Hashtable<String, Integer> dataValueToId = new Hashtable();
    private Hashtable<String, String> nullVerticeToName = new Hashtable();
    private Hashtable<String, Integer> tokenToId = new Hashtable();
    private Hashtable<String, Integer> cardinalityToId = new Hashtable();
    private int currentVerticeId = 0;
    private int currentEdgeId = 0;
    private OLATools ot = null;
    private OLAWeightCapture owg = null;
    int NAMEID = 9;

    public OLAOntologyGraphImpl(Parameters parameters) {
        this.owg = new OLAWeightCapture(parameters);
        this.ot = new OLATools(parameters);
    }

    @Override
    public OntologyGraph build(OWLOntology oWLOntology) {
        this.initGraphConstruction();
        String[] stringArray = this.extractCategories(oWLOntology);
        String[] stringArray2 = this.extractLabels(oWLOntology);
        Object[] objectArray = this.extractVertices(oWLOntology);
        Object[] objectArray2 = this.extractEdges(oWLOntology, (Vertice[])objectArray);
        this.updatePropertyInstanceName((Vertice[])objectArray);
        OntologyGraphImpl ontologyGraphImpl = new OntologyGraphImpl(stringArray, stringArray2);
        ontologyGraphImpl.StraightforwardBuild(objectArray, objectArray2);
        this.clearAll();
        return ontologyGraphImpl;
    }

    @Override
    public void initGraphConstruction() {
        this.currentVerticeId = 0;
        this.currentEdgeId = 0;
        this.csz = 0;
        this.dsz = 0;
        this.isz = 0;
        this.dpsz = 0;
        this.opsz = 0;
        this.classToId.clear();
        this.datatypeToId.clear();
        this.relationToId.clear();
        this.propertyToId.clear();
        this.objectToId.clear();
        this.propertyInstanceToId.clear();
        this.dataValueToId.clear();
        this.nullVerticeToName.clear();
        this.tokenToId.clear();
        this.cardinalityToId.clear();
    }

    @Override
    public String[] extractCategories(OWLOntology oWLOntology) {
        String[] stringArray = new String[]{"Class", "Object", "Relation", "Property", "PropertyInstance", "DataType", "DataValue", "Token", "Cardinality"};
        return stringArray;
    }

    @Override
    public String[] extractLabels(OWLOntology oWLOntology) {
        String[] stringArray = new String[]{"subsumption", "instantiation", "attribution", "domain", "range", "restriction", "valuation", "all", "card", "name"};
        return stringArray;
    }

    @Override
    public Vertice[] extractVertices(OWLOntology oWLOntology) {
        ArrayList<Vertice> arrayList = new ArrayList<Vertice>();
        this.buildEntitiesSets(oWLOntology);
        arrayList.addAll(this.buildVerticesFromClasses(oWLOntology));
        arrayList.addAll(this.buildVerticesFromDatatypes());
        arrayList.addAll(this.buildVerticesFromObjectProperties(oWLOntology));
        arrayList.addAll(this.buildVerticesFromDataProperties(oWLOntology));
        arrayList.addAll(this.buildVerticesFromIndividuals(oWLOntology));
        Vertice[] verticeArray = new Vertice[this.currentVerticeId];
        for (int i = 0; i < this.currentVerticeId; ++i) {
            verticeArray[i] = (Vertice)arrayList.get(i);
        }
        return verticeArray;
    }

    @Override
    public Edge[] extractEdges(OWLOntology oWLOntology, Vertice[] verticeArray) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        arrayList.addAll(this.encodeSubsumptionEdgesBetweenClasses(oWLOntology));
        arrayList.addAll(this.encodeSubsumptionEdgesBetweenProperties(oWLOntology));
        arrayList.addAll(this.encodeDomainEdgesBetweenDataPropertiessAndClasses(oWLOntology));
        arrayList.addAll(this.encodeDomainEdgesBetweenObjectPropertiessAndClasses(oWLOntology));
        arrayList.addAll(this.encodeRangeEdgesBetweenDataPropertiessAndDatatype(oWLOntology));
        arrayList.addAll(this.encodeRangeEdgesBetweenObjectPropertiesAndClasses(oWLOntology));
        arrayList.addAll(this.encodeRestrictionEdgeBetweenPropertyAndCardinality(verticeArray));
        arrayList.addAll(this.encodeInstantiationEdgesBetweenClassesAndObjects(oWLOntology));
        arrayList.addAll(this.encodeEdgesBetweenClassesAndProperties(oWLOntology));
        Edge[] edgeArray = new Edge[this.currentEdgeId];
        for (int i = 0; i < this.currentEdgeId; ++i) {
            edgeArray[i] = (Edge)arrayList.get(i);
        }
        return edgeArray;
    }

    @Override
    public void buildEntitiesSets(OWLOntology oWLOntology) {
        try {
            this.cSet = oWLOntology.getClasses().toArray();
            this.dSet = oWLOntology.getDatatypes().toArray();
            this.iSet = oWLOntology.getIndividuals().toArray();
            this.dpSet = oWLOntology.getDataProperties().toArray();
            this.opSet = oWLOntology.getObjectProperties().toArray();
            this.csz = this.cSet.length;
            this.dsz = this.dSet.length;
            this.isz = this.iSet.length;
            this.dpsz = this.dpSet.length;
            this.opsz = this.opSet.length;
        }
        catch (OWLException oWLException) {
            oWLException.printStackTrace();
        }
    }

    @Override
    public void addVertice(ArrayList<Vertice> arrayList, Hashtable<String, Integer> hashtable, String string, String string2, String string3, String string4, OWLEntity oWLEntity, OWLEntity oWLEntity2, String string5) {
        if (!(this.ot.stringFilter(string2) || hashtable.containsKey(string2) || hashtable.containsKey(string5))) {
            VerticeImpl verticeImpl = new VerticeImpl(this.currentVerticeId, string, string2, string3, string4, 0.0, oWLEntity, oWLEntity2);
            if (!string5.equalsIgnoreCase("")) {
                hashtable.put(string5, this.currentVerticeId);
            } else {
                hashtable.put(string2, this.currentVerticeId);
            }
            arrayList.add(verticeImpl);
            ++this.currentVerticeId;
        }
    }

    private String extractAnnotation(OWLEntity oWLEntity, OWLOntology oWLOntology) {
        String string = "";
        try {
            Set set = oWLEntity.getAnnotations(oWLOntology);
            for (OWLAnnotationInstance oWLAnnotationInstance : set) {
                OWLConcreteDataImpl oWLConcreteDataImpl = (OWLConcreteDataImpl)oWLAnnotationInstance.getContent();
                string = string + " " + oWLConcreteDataImpl.getValue().toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    @Override
    public ArrayList<Vertice> buildVerticesFromClasses(OWLOntology oWLOntology) {
        ArrayList<Vertice> arrayList = new ArrayList<Vertice>();
        for (int i = 0; i < this.csz; ++i) {
            boolean bl;
            OWLClassImpl oWLClassImpl = (OWLClassImpl)this.cSet[i];
            boolean bl2 = bl = oWLClassImpl != null;
            if (!bl) continue;
            URI uRI = oWLClassImpl.getURI();
            String string = this.ot.getName(uRI, "Class", 1);
            String string2 = this.extractAnnotation((OWLEntity)oWLClassImpl, oWLOntology);
            this.addVertice(arrayList, this.classToId, "Class", string, "", string2, (OWLEntity)oWLClassImpl, null, uRI.toString());
            arrayList.addAll(this.buildPropertyVerticesFromClass(oWLClassImpl, oWLOntology));
        }
        this.addVertice(arrayList, this.classToId, "Class", "Null", "", "", null, null, "");
        return arrayList;
    }

    @Override
    public ArrayList<Vertice> buildPropertyVerticesFromClass(OWLClassImpl oWLClassImpl, OWLOntology oWLOntology) {
        ArrayList<Vertice> arrayList = new ArrayList<Vertice>();
        for (Object object : oWLClassImpl.getSuperClasses().toArray()) {
            if (object instanceof OWLObjectCardinalityRestrictionImpl) {
                arrayList.addAll(this.buildVerticesFromObjectCardinalityRestriction((OWLObjectCardinalityRestrictionImpl)object, oWLOntology));
                continue;
            }
            if (object instanceof OWLDataCardinalityRestrictionImpl) {
                arrayList.addAll(this.buildVerticesFromDataCardinalityRestriction((OWLDataCardinalityRestrictionImpl)object, oWLOntology));
                continue;
            }
            if (object instanceof OWLObjectAllRestrictionImpl) {
                arrayList.addAll(this.buildVerticesFromObjectAllRestriction((OWLObjectAllRestrictionImpl)object, oWLOntology));
                continue;
            }
            if (!(object instanceof OWLDataAllRestrictionImpl)) continue;
            arrayList.addAll(this.buildVerticesFromDataAllRestriction((OWLDataAllRestrictionImpl)object, oWLOntology));
        }
        return arrayList;
    }

    @Override
    public ArrayList<Vertice> buildVerticesFromObjectCardinalityRestriction(OWLObjectCardinalityRestrictionImpl oWLObjectCardinalityRestrictionImpl, OWLOntology oWLOntology) {
        ArrayList<Vertice> arrayList = new ArrayList<Vertice>();
        try {
            boolean bl;
            OWLObjectPropertyImpl oWLObjectPropertyImpl = (OWLObjectPropertyImpl)oWLObjectCardinalityRestrictionImpl.getObjectProperty();
            boolean bl2 = bl = oWLObjectPropertyImpl != null;
            if (bl) {
                URI uRI = oWLObjectPropertyImpl.getURI();
                String string = this.ot.getName(uRI, "Property", 1);
                int n = oWLObjectCardinalityRestrictionImpl.getAtLeast();
                int n2 = oWLObjectCardinalityRestrictionImpl.getAtMost();
                String string2 = this.ot.generateCardinalityString(n, n2);
                String string3 = this.extractAnnotation((OWLEntity)oWLObjectPropertyImpl, oWLOntology);
                this.addVertice(arrayList, this.propertyToId, "Property", string, string2, string3, (OWLEntity)oWLObjectPropertyImpl, null, uRI.toString());
                arrayList.addAll(this.buildCardinalityVertice(string2));
            }
        }
        catch (OWLException oWLException) {
            oWLException.printStackTrace();
        }
        return arrayList;
    }

    @Override
    public ArrayList<Vertice> buildVerticesFromDataCardinalityRestriction(OWLDataCardinalityRestrictionImpl oWLDataCardinalityRestrictionImpl, OWLOntology oWLOntology) {
        ArrayList<Vertice> arrayList = new ArrayList<Vertice>();
        try {
            boolean bl;
            OWLDataPropertyImpl oWLDataPropertyImpl = (OWLDataPropertyImpl)oWLDataCardinalityRestrictionImpl.getDataProperty();
            boolean bl2 = bl = oWLDataPropertyImpl != null;
            if (bl) {
                URI uRI = oWLDataPropertyImpl.getURI();
                String string = this.ot.getName(uRI, "Property", 1);
                int n = oWLDataCardinalityRestrictionImpl.getAtLeast();
                int n2 = oWLDataCardinalityRestrictionImpl.getAtMost();
                String string2 = this.ot.generateCardinalityString(n, n2);
                String string3 = this.extractAnnotation((OWLEntity)oWLDataPropertyImpl, oWLOntology);
                this.addVertice(arrayList, this.propertyToId, "Property", string, string2, string3, (OWLEntity)oWLDataPropertyImpl, null, uRI.toString());
                arrayList.addAll(this.buildCardinalityVertice(string2));
            }
        }
        catch (OWLException oWLException) {
            oWLException.printStackTrace();
        }
        return arrayList;
    }

    @Override
    public ArrayList<Vertice> buildVerticesFromObjectAllRestriction(OWLObjectAllRestrictionImpl oWLObjectAllRestrictionImpl, OWLOntology oWLOntology) {
        ArrayList<Vertice> arrayList = new ArrayList<Vertice>();
        try {
            boolean bl;
            OWLObjectPropertyImpl oWLObjectPropertyImpl = (OWLObjectPropertyImpl)oWLObjectAllRestrictionImpl.getObjectProperty();
            boolean bl2 = bl = oWLObjectPropertyImpl != null;
            if (bl) {
                URI uRI = oWLObjectPropertyImpl.getURI();
                String string = this.ot.getName(uRI, "Property", 1);
                String string2 = "all";
                String string3 = this.extractAnnotation((OWLEntity)oWLObjectPropertyImpl, oWLOntology);
                this.addVertice(arrayList, this.propertyToId, "Property", string, string2, string3, (OWLEntity)oWLObjectPropertyImpl, null, uRI.toString());
                arrayList.addAll(this.buildCardinalityVertice(string2));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    @Override
    public ArrayList<Vertice> buildVerticesFromDataAllRestriction(OWLDataAllRestrictionImpl oWLDataAllRestrictionImpl, OWLOntology oWLOntology) {
        ArrayList<Vertice> arrayList = new ArrayList<Vertice>();
        try {
            boolean bl;
            OWLDataPropertyImpl oWLDataPropertyImpl = (OWLDataPropertyImpl)oWLDataAllRestrictionImpl.getDataProperty();
            boolean bl2 = bl = oWLDataPropertyImpl != null;
            if (bl) {
                URI uRI = oWLDataPropertyImpl.getURI();
                String string = this.ot.getName(uRI, "Property", 1);
                String string2 = "all";
                String string3 = this.extractAnnotation((OWLEntity)oWLDataPropertyImpl, oWLOntology);
                this.addVertice(arrayList, this.propertyToId, "Property", string, string2, string3, (OWLEntity)oWLDataPropertyImpl, null, uRI.toString());
                arrayList.addAll(this.buildCardinalityVertice(string2));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    @Override
    public ArrayList<Vertice> buildCardinalityVertice(String string) {
        ArrayList<Vertice> arrayList = new ArrayList<Vertice>();
        if (!this.cardinalityToId.containsKey(string)) {
            this.addVertice(arrayList, this.cardinalityToId, "Cardinality", string, "", "", null, null, "");
        }
        return arrayList;
    }

    @Override
    public ArrayList<Vertice> buildVerticesFromDatatypes() {
        ArrayList<Vertice> arrayList = new ArrayList<Vertice>();
        for (int i = 0; i < this.dsz; ++i) {
            boolean bl;
            OWLConcreteDataTypeImpl oWLConcreteDataTypeImpl = (OWLConcreteDataTypeImpl)this.dSet[i];
            boolean bl2 = bl = oWLConcreteDataTypeImpl != null;
            if (!bl) continue;
            URI uRI = oWLConcreteDataTypeImpl.getURI();
            String string = this.ot.getName(uRI, "DataType", 1);
            this.addVertice(arrayList, this.datatypeToId, "DataType", string, "", "", null, null, "");
        }
        this.addVertice(arrayList, this.datatypeToId, "DataType", "null", "", "", null, null, "");
        return arrayList;
    }

    @Override
    public ArrayList<Vertice> buildVerticesFromDataProperties(OWLOntology oWLOntology) {
        ArrayList<Vertice> arrayList = new ArrayList<Vertice>();
        for (int i = 0; i < this.dpsz; ++i) {
            boolean bl;
            OWLDataPropertyImpl oWLDataPropertyImpl = (OWLDataPropertyImpl)this.dpSet[i];
            boolean bl2 = bl = oWLDataPropertyImpl != null;
            if (!bl) continue;
            URI uRI = oWLDataPropertyImpl.getURI();
            String string = this.ot.getName(uRI, "Relation", 1);
            String string2 = this.extractAnnotation((OWLEntity)oWLDataPropertyImpl, oWLOntology);
            this.addVertice(arrayList, this.relationToId, "Relation", string, "", string2, (OWLEntity)oWLDataPropertyImpl, null, uRI.toString());
            arrayList.addAll(this.buildVerticesFromDataPropertyRange(oWLDataPropertyImpl, oWLOntology));
        }
        return arrayList;
    }

    @Override
    public ArrayList<Vertice> buildVerticesFromDataPropertyRange(OWLDataPropertyImpl oWLDataPropertyImpl, OWLOntology oWLOntology) {
        ArrayList<Vertice> arrayList = new ArrayList<Vertice>();
        Set set = oWLDataPropertyImpl.getRanges();
        for (Object e : set) {
            OWLConcreteDataTypeImpl oWLConcreteDataTypeImpl;
            boolean bl;
            if (!(e instanceof OWLConcreteDataTypeImpl) || !(bl = (oWLConcreteDataTypeImpl = (OWLConcreteDataTypeImpl)e) != null)) continue;
            URI uRI = oWLConcreteDataTypeImpl.getURI();
            String string = this.ot.getName(uRI, "DataType", 0);
            this.addVertice(arrayList, this.datatypeToId, "DataType", string, "", "", null, null, "");
        }
        return arrayList;
    }

    @Override
    public ArrayList<Vertice> buildVerticesFromObjectProperties(OWLOntology oWLOntology) {
        ArrayList<Vertice> arrayList = new ArrayList<Vertice>();
        for (int i = 0; i < this.opsz; ++i) {
            boolean bl;
            OWLObjectPropertyImpl oWLObjectPropertyImpl = (OWLObjectPropertyImpl)this.opSet[i];
            boolean bl2 = bl = oWLObjectPropertyImpl != null;
            if (!bl) continue;
            URI uRI = oWLObjectPropertyImpl.getURI();
            String string = this.ot.getName(uRI, "Relation", 1);
            String string2 = this.extractAnnotation((OWLEntity)oWLObjectPropertyImpl, oWLOntology);
            this.addVertice(arrayList, this.relationToId, "Relation", string, "", string2, (OWLEntity)oWLObjectPropertyImpl, null, uRI.toString());
        }
        return arrayList;
    }

    @Override
    public ArrayList<Vertice> buildVerticesFromIndividuals(OWLOntology oWLOntology) {
        boolean bl;
        OWLIndividualImpl oWLIndividualImpl;
        int n;
        ArrayList<Vertice> arrayList = new ArrayList<Vertice>();
        for (n = 0; n < this.isz; ++n) {
            oWLIndividualImpl = (OWLIndividualImpl)this.iSet[n];
            boolean bl2 = bl = oWLIndividualImpl != null;
            if (!bl) continue;
            URI uRI = oWLIndividualImpl.getURI();
            String string = this.ot.getType(oWLIndividualImpl, oWLOntology, 1);
            String string2 = this.ot.getName(uRI, string, 1);
            String string3 = this.extractAnnotation((OWLEntity)oWLIndividualImpl, oWLOntology);
            this.addVertice(arrayList, this.objectToId, "Object", string2, "", string3, (OWLEntity)oWLIndividualImpl, null, "");
            String string4 = this.ot.getIdentification(oWLIndividualImpl, oWLOntology);
            if (string4.equalsIgnoreCase("") || this.nullVerticeToName.containsKey(string4)) continue;
            this.nullVerticeToName.put(string4, string2);
        }
        for (n = 0; n < this.isz; ++n) {
            oWLIndividualImpl = (OWLIndividualImpl)this.iSet[n];
            boolean bl3 = bl = oWLIndividualImpl != null;
            if (!bl) continue;
            arrayList.addAll(this.buildVerticesFromDataPropertyInstances(oWLIndividualImpl, oWLOntology));
            arrayList.addAll(this.buildVerticesFromObjectPropertyInstances(oWLIndividualImpl, oWLOntology));
        }
        return arrayList;
    }

    @Override
    public ArrayList<Vertice> buildVerticesFromDataPropertyInstances(OWLIndividualImpl oWLIndividualImpl, OWLOntology oWLOntology) {
        ArrayList<Vertice> arrayList = new ArrayList<Vertice>();
        Map map = oWLIndividualImpl.getDataPropertyValues(oWLOntology);
        Object[] objectArray = map.keySet().toArray();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            boolean bl;
            OWLDataPropertyImpl oWLDataPropertyImpl = (OWLDataPropertyImpl)objectArray[i];
            boolean bl2 = bl = oWLDataPropertyImpl != null;
            if (!bl) continue;
            HashSet hashSet = (HashSet)map.get(oWLDataPropertyImpl);
            for (OWLConcreteDataImpl oWLConcreteDataImpl : hashSet) {
                boolean bl3 = oWLConcreteDataImpl != null;
                if (!bl3) continue;
                String string = oWLConcreteDataImpl.getValue().toString();
                this.addVertice(arrayList, this.propertyInstanceToId, "PropertyInstance", string, "", "", (OWLEntity)oWLDataPropertyImpl, null, "");
                this.addVertice(arrayList, this.dataValueToId, "DataValue", string, "", "", null, null, "");
            }
        }
        return arrayList;
    }

    @Override
    public ArrayList<Vertice> buildVerticesFromObjectPropertyInstances(OWLIndividualImpl oWLIndividualImpl, OWLOntology oWLOntology) {
        ArrayList<Vertice> arrayList = new ArrayList<Vertice>();
        Map map = oWLIndividualImpl.getObjectPropertyValues(oWLOntology);
        Object[] objectArray = map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            OWLObjectPropertyImpl oWLObjectPropertyImpl = (OWLObjectPropertyImpl)objectArray[i];
            HashSet hashSet = (HashSet)map.get(oWLObjectPropertyImpl);
            for (OWLIndividualImpl oWLIndividualImpl2 : hashSet) {
                boolean bl = oWLIndividualImpl2 != null;
                if (!bl) continue;
                String string = null;
                URI uRI = oWLIndividualImpl2.getURI();
                string = uRI == null ? this.nullVerticeToName.get(this.ot.getIdentification(oWLIndividualImpl2, oWLOntology)) : this.ot.getName(uRI, "", 0);
                this.addVertice(arrayList, this.propertyInstanceToId, "PropertyInstance", string, "", "", (OWLEntity)oWLIndividualImpl2, null, "");
            }
        }
        return arrayList;
    }

    @Override
    public void addEdge(ArrayList<Edge> arrayList, String string, int n, int n2, double d) {
        EdgeImpl edgeImpl = new EdgeImpl(this.currentEdgeId, string, d, n, n2);
        arrayList.add(edgeImpl);
        ++this.currentEdgeId;
    }

    @Override
    public ArrayList<Edge> encodeSubsumptionEdgesBetweenClasses(OWLOntology oWLOntology) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        for (int i = 0; i < this.csz; ++i) {
            boolean bl;
            OWLClassImpl oWLClassImpl = (OWLClassImpl)this.cSet[i];
            boolean bl2 = bl = oWLClassImpl != null;
            if (!bl) continue;
            URI uRI = oWLClassImpl.getURI();
            int n = this.classToId.get(uRI.toString());
            try {
                Object[] objectArray = oWLClassImpl.getSubClasses(oWLOntology).toArray();
                int n2 = objectArray.length;
                for (int j = 0; j < n2; ++j) {
                    boolean bl3;
                    OWLClassImpl oWLClassImpl2 = (OWLClassImpl)objectArray[j];
                    boolean bl4 = bl3 = oWLClassImpl2 != null;
                    if (!bl3) continue;
                    URI uRI2 = oWLClassImpl2.getURI();
                    int n3 = this.classToId.get(uRI2.toString());
                    double d = this.owg.getWeight(4);
                    this.addEdge(arrayList, "subsumption", n, n3, d);
                }
                continue;
            }
            catch (OWLException oWLException) {
                oWLException.printStackTrace();
            }
        }
        return arrayList;
    }

    @Override
    public ArrayList<Edge> encodeSubsumptionEdgesBetweenProperties(OWLOntology oWLOntology) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        try {
            Object[] objectArray = oWLOntology.getPropertyAxioms().toArray();
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                boolean bl;
                OWLSubPropertyAxiomImpl oWLSubPropertyAxiomImpl = (OWLSubPropertyAxiomImpl)objectArray[i];
                OWLProperty oWLProperty = oWLSubPropertyAxiomImpl.getSuperProperty();
                OWLProperty oWLProperty2 = oWLSubPropertyAxiomImpl.getSubProperty();
                boolean bl2 = oWLProperty != null;
                boolean bl3 = bl = oWLProperty2 != null;
                if (!bl2 || !bl) continue;
                URI uRI = oWLProperty.getURI();
                URI uRI2 = oWLProperty2.getURI();
                int n2 = this.relationToId.get(uRI.toString());
                int n3 = this.relationToId.get(uRI2.toString());
                double d = this.owg.getWeight(20);
                this.addEdge(arrayList, "subsumption", n2, n3, d);
            }
        }
        catch (OWLException oWLException) {
            oWLException.printStackTrace();
        }
        return arrayList;
    }

    @Override
    public ArrayList<Edge> encodeDomainEdgesBetweenDataPropertiessAndClasses(OWLOntology oWLOntology) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        for (int i = 0; i < this.dpsz; ++i) {
            int n;
            boolean bl;
            OWLDataPropertyImpl oWLDataPropertyImpl = (OWLDataPropertyImpl)this.dpSet[i];
            boolean bl2 = bl = oWLDataPropertyImpl != null;
            if (!bl) continue;
            URI uRI = oWLDataPropertyImpl.getURI();
            int n2 = this.relationToId.get(uRI.toString());
            Object[] objectArray = oWLDataPropertyImpl.getDomains(oWLOntology).toArray();
            int n3 = objectArray.length;
            if (n3 == 0) {
                n = this.classToId.get("Null");
                double d = 0.0;
                this.addEdge(arrayList, "domain", n, n2, d);
            }
            for (n = 0; n < n3; ++n) {
                Object[] objectArray2 = this.ot.getOperand(objectArray[n]);
                int n4 = objectArray2.length;
                for (int j = 0; j < n4; ++j) {
                    boolean bl3;
                    OWLClassImpl oWLClassImpl = (OWLClassImpl)objectArray2[j];
                    boolean bl4 = bl3 = oWLClassImpl != null;
                    if (!bl3) continue;
                    URI uRI2 = oWLClassImpl.getURI();
                    int n5 = this.classToId.get(uRI2.toString());
                    double d = this.owg.getWeight(18);
                    this.addEdge(arrayList, "domain", n5, n2, d);
                    arrayList.addAll(this.encodeAttributionEdgesBetweenClassesAndProperties(uRI2.toString(), uRI.toString()));
                    arrayList.addAll(this.encodeSubsumptionEdgesBetweenPropertiesAndRelations(uRI.toString(), uRI.toString()));
                }
            }
        }
        return arrayList;
    }

    @Override
    public ArrayList<Edge> encodeDomainEdgesBetweenObjectPropertiessAndClasses(OWLOntology oWLOntology) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        for (int i = 0; i < this.opsz; ++i) {
            int n;
            boolean bl;
            OWLObjectPropertyImpl oWLObjectPropertyImpl = (OWLObjectPropertyImpl)this.opSet[i];
            boolean bl2 = bl = oWLObjectPropertyImpl != null;
            if (!bl) continue;
            URI uRI = oWLObjectPropertyImpl.getURI();
            int n2 = this.relationToId.get(uRI.toString());
            Object[] objectArray = oWLObjectPropertyImpl.getDomains(oWLOntology).toArray();
            int n3 = objectArray.length;
            if (n3 == 0) {
                n = this.classToId.get("Null");
                double d = 0.0;
                this.addEdge(arrayList, "domain", n, n2, d);
            }
            for (n = 0; n < n3; ++n) {
                Object[] objectArray2 = this.ot.getOperand(objectArray[n]);
                int n4 = objectArray2.length;
                for (int j = 0; j < n4; ++j) {
                    boolean bl3;
                    OWLClassImpl oWLClassImpl = (OWLClassImpl)objectArray2[j];
                    boolean bl4 = bl3 = oWLClassImpl != null;
                    if (!bl3) continue;
                    URI uRI2 = oWLClassImpl.getURI();
                    int n5 = this.classToId.get(uRI2.toString());
                    double d = this.owg.getWeight(22);
                    this.addEdge(arrayList, "domain", n5, n2, d);
                    arrayList.addAll(this.encodeAttributionEdgesBetweenClassesAndProperties(uRI2.toString(), uRI.toString()));
                    arrayList.addAll(this.encodeSubsumptionEdgesBetweenPropertiesAndRelations(uRI.toString(), uRI.toString()));
                }
            }
        }
        return arrayList;
    }

    @Override
    public ArrayList<Edge> encodeAttributionEdgesBetweenClassesAndProperties(String string, String string2) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        if (this.propertyToId.containsKey(string2)) {
            int n = this.classToId.get(string);
            int n2 = this.propertyToId.get(string2);
            double d = this.owg.getWeight(5);
            this.addEdge(arrayList, "attribution", n2, n, d);
        }
        return arrayList;
    }

    @Override
    public ArrayList<Edge> encodeSubsumptionEdgesBetweenPropertiesAndRelations(String string, String string2) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        if (this.propertyToId.containsKey(string)) {
            int n = this.relationToId.get(string2);
            int n2 = this.propertyToId.get(string);
            double d = this.owg.getWeight(11);
            this.addEdge(arrayList, "subsumption", n, n2, d);
        }
        return arrayList;
    }

    @Override
    public ArrayList<Edge> encodeRangeEdgesBetweenDataPropertiessAndDatatype(OWLOntology oWLOntology) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        for (int i = 0; i < this.dpsz; ++i) {
            int n;
            boolean bl;
            OWLDataPropertyImpl oWLDataPropertyImpl = (OWLDataPropertyImpl)this.dpSet[i];
            boolean bl2 = bl = oWLDataPropertyImpl != null;
            if (!bl) continue;
            URI uRI = oWLDataPropertyImpl.getURI();
            int n2 = this.relationToId.get(uRI.toString());
            Object[] objectArray = oWLDataPropertyImpl.getRanges().toArray();
            int n3 = objectArray.length;
            if (n3 == 0) {
                n = this.datatypeToId.get("null");
                double d = 0.0;
                this.addEdge(arrayList, "range", n, n2, d);
            }
            for (n = 0; n < n3; ++n) {
                for (Object object : this.ot.getOperand(objectArray[n])) {
                    boolean bl3;
                    if (!(object instanceof OWLConcreteDataTypeImpl)) continue;
                    OWLConcreteDataTypeImpl oWLConcreteDataTypeImpl = (OWLConcreteDataTypeImpl)object;
                    boolean bl4 = bl3 = oWLConcreteDataTypeImpl != null;
                    if (!bl3) continue;
                    URI uRI2 = oWLConcreteDataTypeImpl.getURI();
                    String string = this.ot.getName(uRI2, "DataType", 1);
                    int n4 = this.datatypeToId.get(string);
                    double d = this.owg.getWeight(19);
                    this.addEdge(arrayList, "range", n4, n2, d);
                    arrayList.addAll(this.encodeAllEdgesBetweenPropertiesAndDatatypes(uRI.toString(), string));
                }
            }
        }
        return arrayList;
    }

    @Override
    public ArrayList<Edge> encodeAllEdgesBetweenPropertiesAndDatatypes(String string, String string2) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        if (this.propertyToId.containsKey(string)) {
            int n = this.datatypeToId.get(string2);
            int n2 = this.propertyToId.get(string);
            double d = this.owg.getWeight(13);
            this.addEdge(arrayList, "all", n, n2, d);
        }
        return arrayList;
    }

    @Override
    public ArrayList<Edge> encodeRangeEdgesBetweenObjectPropertiesAndClasses(OWLOntology oWLOntology) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        for (int i = 0; i < this.opsz; ++i) {
            int n;
            boolean bl;
            OWLObjectPropertyImpl oWLObjectPropertyImpl = (OWLObjectPropertyImpl)this.opSet[i];
            boolean bl2 = bl = oWLObjectPropertyImpl != null;
            if (!bl) continue;
            URI uRI = oWLObjectPropertyImpl.getURI();
            int n2 = this.relationToId.get(uRI.toString());
            Object[] objectArray = oWLObjectPropertyImpl.getRanges().toArray();
            int n3 = objectArray.length;
            if (n3 == 0) {
                n = this.classToId.get("Null");
                double d = 0.0;
                this.addEdge(arrayList, "range", n, n2, d);
            }
            for (n = 0; n < n3; ++n) {
                Object[] objectArray2 = this.ot.getOperand(objectArray[n]);
                int n4 = objectArray2.length;
                for (int j = 0; j < n4; ++j) {
                    boolean bl3;
                    OWLClassImpl oWLClassImpl = (OWLClassImpl)objectArray2[j];
                    boolean bl4 = bl3 = oWLClassImpl != null;
                    if (!bl3) continue;
                    URI uRI2 = oWLClassImpl.getURI();
                    int n5 = this.classToId.get(uRI2.toString());
                    double d = this.owg.getWeight(23);
                    this.addEdge(arrayList, "range", n5, n2, d);
                    arrayList.addAll(this.encodeAllEdgesBetweenPropertiesAndClasses(uRI.toString(), uRI2.toString()));
                }
            }
        }
        return arrayList;
    }

    @Override
    public ArrayList<Edge> encodeAllEdgesBetweenPropertiesAndClasses(String string, String string2) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        if (this.propertyToId.containsKey(string)) {
            int n = this.classToId.get(string2);
            int n2 = this.propertyToId.get(string);
            double d = this.owg.getWeight(8);
            this.addEdge(arrayList, "all", n, n2, d);
        }
        return arrayList;
    }

    @Override
    public ArrayList<Edge> encodeInstantiationEdgesBetweenClassesAndObjects(OWLOntology oWLOntology) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        try {
            for (int i = 0; i < this.isz; ++i) {
                boolean bl;
                OWLIndividualImpl oWLIndividualImpl = (OWLIndividualImpl)this.iSet[i];
                boolean bl2 = bl = oWLIndividualImpl != null;
                if (!bl) continue;
                URI uRI = oWLIndividualImpl.getURI();
                String string = this.ot.getType(oWLIndividualImpl, oWLOntology, 0);
                if (string.equalsIgnoreCase("")) continue;
                String string2 = null;
                String string3 = this.ot.getIdentification(oWLIndividualImpl, oWLOntology);
                String string4 = this.ot.getType(oWLIndividualImpl, oWLOntology, 1);
                string2 = !string3.equalsIgnoreCase("") ? this.nullVerticeToName.get(string3) : this.ot.getName(uRI, string4, 1);
                int n = this.classToId.get(string);
                int n2 = this.objectToId.get(string2);
                double d = this.owg.getWeight(3);
                this.addEdge(arrayList, "instantiation", n2, n, d);
                arrayList.addAll(this.encodeEdgesBetweenObjectsPropertyInstanceDataPropertiesAndDataTypes(oWLIndividualImpl, string2, n2, oWLOntology));
                arrayList.addAll(this.encodeEdgesBetweenObjectsPropertyInstancesAndObjectProperties(oWLIndividualImpl, string2, n2, oWLOntology));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    @Override
    public ArrayList<Edge> encodeEdgesBetweenObjectsPropertyInstanceDataPropertiesAndDataTypes(OWLIndividualImpl oWLIndividualImpl, String string, int n, OWLOntology oWLOntology) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        Map map = oWLIndividualImpl.getDataPropertyValues(oWLOntology);
        Object[] objectArray = map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            boolean bl;
            OWLDataPropertyImpl oWLDataPropertyImpl = (OWLDataPropertyImpl)objectArray[i];
            boolean bl2 = bl = oWLDataPropertyImpl != null;
            if (!bl) continue;
            URI uRI = oWLDataPropertyImpl.getURI();
            int n2 = this.relationToId.get(uRI.toString());
            HashSet hashSet = (HashSet)map.get(oWLDataPropertyImpl);
            for (OWLConcreteDataImpl oWLConcreteDataImpl : hashSet) {
                boolean bl3 = oWLConcreteDataImpl != null;
                if (!bl3) continue;
                String string2 = oWLConcreteDataImpl.getValue().toString();
                int n3 = this.propertyInstanceToId.get(string2);
                int n4 = this.dataValueToId.get(string2);
                double d = this.owg.getWeight(33);
                this.addEdge(arrayList, "attribution", n, n3, d);
                d = this.owg.getWeight(26);
                this.addEdge(arrayList, "attribution", n3, n, d);
                d = this.owg.getWeight(31);
                this.addEdge(arrayList, "restriction", n2, n3, d);
                d = this.owg.getWeight(30);
                this.addEdge(arrayList, "valuation", n4, n3, d);
            }
        }
        return arrayList;
    }

    @Override
    public ArrayList<Edge> encodeEdgesBetweenObjectsPropertyInstancesAndObjectProperties(OWLIndividualImpl oWLIndividualImpl, String string, int n, OWLOntology oWLOntology) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        Map map = oWLIndividualImpl.getObjectPropertyValues(oWLOntology);
        Object[] objectArray = map.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            boolean bl;
            OWLObjectPropertyImpl oWLObjectPropertyImpl = (OWLObjectPropertyImpl)objectArray[i];
            boolean bl2 = bl = oWLObjectPropertyImpl != null;
            if (!bl) continue;
            URI uRI = oWLObjectPropertyImpl.getURI();
            int n2 = this.relationToId.get(uRI.toString());
            HashSet hashSet = (HashSet)map.get(oWLObjectPropertyImpl);
            for (OWLIndividualImpl oWLIndividualImpl2 : hashSet) {
                boolean bl3 = oWLIndividualImpl2 != null;
                if (!bl3) continue;
                URI uRI2 = oWLIndividualImpl2.getURI();
                String string2 = null;
                String string3 = this.ot.getIdentification(oWLIndividualImpl2, oWLOntology);
                string2 = !string3.equalsIgnoreCase("") ? this.nullVerticeToName.get(string3) : this.ot.getName(uRI2, "", 0);
                int n3 = this.propertyInstanceToId.get(string2);
                int n4 = this.objectToId.get(string2);
                double d = this.owg.getWeight(33);
                this.addEdge(arrayList, "attribution", n, n3, d);
                d = this.owg.getWeight(27);
                this.addEdge(arrayList, "attribution", n3, n, d);
                d = this.owg.getWeight(34);
                this.addEdge(arrayList, "restriction", n2, n3, d);
                d = this.owg.getWeight(33);
                this.addEdge(arrayList, "valuation", n4, n3, d);
            }
        }
        return arrayList;
    }

    @Override
    public ArrayList<Edge> encodeRestrictionEdgeBetweenPropertyAndCardinality(Vertice[] verticeArray) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        Object[] objectArray = this.propertyToId.values().toArray();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = (Integer)objectArray[i];
            Vertice vertice = verticeArray[n2];
            String string = vertice.getComments();
            int n3 = this.cardinalityToId.get(string);
            double d = this.owg.getWeight(10);
            this.addEdge(arrayList, "card", n3, n2, d);
            verticeArray[n2].setComments("");
        }
        return arrayList;
    }

    public ArrayList<Edge> encodeEdgesBetweenClassesAndProperties(OWLOntology oWLOntology) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        for (int i = 0; i < this.csz; ++i) {
            boolean bl;
            OWLClassImpl oWLClassImpl = (OWLClassImpl)this.cSet[i];
            boolean bl2 = bl = oWLClassImpl != null;
            if (!bl) continue;
            URI uRI = oWLClassImpl.getURI();
            int n = this.classToId.get(uRI.toString());
            try {
                for (Object object : oWLClassImpl.getSuperClasses().toArray()) {
                    OWLObjectProperty oWLObjectProperty;
                    if (object instanceof OWLObjectCardinalityRestrictionImpl) {
                        oWLObjectProperty = ((OWLObjectCardinalityRestrictionImpl)object).getObjectProperty();
                        arrayList.addAll(this.encodeEdgesBetweenClassAndObjectProperties(n, oWLObjectProperty));
                        continue;
                    }
                    if (!(object instanceof OWLObjectAllRestrictionImpl)) continue;
                    oWLObjectProperty = ((OWLObjectAllRestrictionImpl)object).getObjectProperty();
                    arrayList.addAll(this.encodeEdgesBetweenClassAndObjectProperties(n, oWLObjectProperty));
                }
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return arrayList;
    }

    public ArrayList<Edge> encodeEdgesBetweenClassAndObjectProperties(int n, OWLObjectProperty oWLObjectProperty) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        try {
            URI uRI = oWLObjectProperty.getURI();
            int n2 = this.relationToId.get(uRI.toString());
            double d = this.owg.getWeight(8);
            this.addEdge(arrayList, "attribution", n2, n, d);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    @Override
    public void updatePropertyInstanceName(Vertice[] verticeArray) {
        Object[] objectArray = this.propertyInstanceToId.keySet().toArray();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = this.propertyInstanceToId.get((String)objectArray[i]);
            verticeArray[n2].setLabel("PI" + Integer.toString(i));
        }
    }

    @Override
    public OntologyGraph completeOntologyGraph(OntologyGraph ontologyGraph, Object[] objectArray, boolean bl) {
        OntologyGraph ontologyGraph2 = ontologyGraph;
        this.currentVerticeId = ontologyGraph2.getVerticePool().size();
        this.currentEdgeId = ontologyGraph2.getEdgePool().size();
        int n = this.currentVerticeId;
        LabelTokenizer labelTokenizer = new LabelTokenizer();
        for (int i = 0; i < n; ++i) {
            String string;
            boolean bl2;
            Vertice vertice = (Vertice)objectArray[i];
            String string2 = vertice.getCategory();
            boolean bl3 = bl2 = string2.equalsIgnoreCase("Class") || string2.equalsIgnoreCase("Object") || string2.equalsIgnoreCase("Relation");
            if (!bl2) continue;
            ArrayList arrayList = null;
            boolean bl4 = vertice.getCategory().equalsIgnoreCase("Object");
            int n2 = 0;
            if (bl || bl4) {
                string = vertice.getLabel();
                arrayList = labelTokenizer.tokenize(string);
                n2 = labelTokenizer.getNumberOfTokens();
            } else {
                string = vertice.getComments();
                vertice.setLabel(string);
                arrayList = labelTokenizer.tokenizePath(string);
                n2 = labelTokenizer.getNumberOfTokens();
            }
            if (!vertice.getAnnotation().equalsIgnoreCase("")) {
                arrayList.add(vertice.getAnnotation());
                ++n2;
            }
            for (int j = 0; j < n2; ++j) {
                int n3 = 0;
                if (this.tokenToId.containsKey(arrayList.get(j))) {
                    n3 = this.tokenToId.get(arrayList.get(j));
                } else {
                    n3 = this.directVerticeInsertion(ontologyGraph2, "Token", (String)arrayList.get(j));
                    this.tokenToId.put((String)arrayList.get(j), n3);
                }
                double d = 0.0;
                if (string2.equalsIgnoreCase("Class")) {
                    d = this.owg.getWeight(2);
                }
                if (string2.equalsIgnoreCase("Object")) {
                    d = this.owg.getWeight(25);
                }
                if (string2.equalsIgnoreCase("Relation")) {
                    d = this.owg.getWeight(17);
                }
                this.directEdgeInsertion(ontologyGraph2, "name", n3, vertice.getId(), d);
            }
        }
        return ontologyGraph2;
    }

    @Override
    public int directVerticeInsertion(OntologyGraph ontologyGraph, String string, String string2) {
        int n = this.currentVerticeId;
        VerticeImpl verticeImpl = new VerticeImpl(this.currentVerticeId, string, string2, "", "", 0.0, null, null);
        ontologyGraph.insertVertice(verticeImpl);
        ++this.currentVerticeId;
        return n;
    }

    @Override
    public void directEdgeInsertion(OntologyGraph ontologyGraph, String string, int n, int n2, double d) {
        EdgeImpl edgeImpl = new EdgeImpl(this.currentEdgeId, string, d, n, n2);
        ontologyGraph.insertEdge(edgeImpl);
        ((Vertice)ontologyGraph.getVerticePool().get(n)).insertNeighId(n2, this.NAMEID, true);
        ((Vertice)ontologyGraph.getVerticePool().get(n2)).insertNeighId(n, this.NAMEID, false);
        ((Vertice)ontologyGraph.getVerticePool().get(n)).insertEdgeId(this.currentEdgeId, this.NAMEID, true);
        ((Vertice)ontologyGraph.getVerticePool().get(n2)).insertEdgeId(this.currentEdgeId, this.NAMEID, false);
        ++this.currentEdgeId;
    }

    @Override
    public void clearAll() {
        this.cSet = null;
        this.dSet = null;
        this.iSet = null;
        this.dpSet = null;
        this.opSet = null;
        this.classToId.clear();
        this.datatypeToId.clear();
        this.relationToId.clear();
        this.propertyToId.clear();
        this.objectToId.clear();
        this.propertyInstanceToId.clear();
        this.dataValueToId.clear();
        this.nullVerticeToName.clear();
        this.tokenToId.clear();
        this.cardinalityToId.clear();
    }
}

