/*
 * Decompiled with CFR 0.152.
 */
package ca.uqam.info.latece.sboa.impl.amatrix;

import ca.uqam.info.latece.sboa.impl.selection.AssignmentMethodsImpl;
import ca.uqam.info.latece.sboa.inter.amatrix.AdjacencyMatrix;
import ca.uqam.info.latece.sboa.inter.amatrix.OLAMatrixUpdate;
import ca.uqam.info.latece.sboa.inter.ograph.Edge;
import ca.uqam.info.latece.sboa.inter.ograph.OntologyGraph;
import ca.uqam.info.latece.sboa.inter.ograph.Vertice;
import ca.uqam.info.latece.sboa.inter.ograph.VerticesPool;
import ca.uqam.info.latece.sboa.inter.selection.AssignmentMethods;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OLAMatrixUpdateImpl
implements OLAMatrixUpdate {
    int[] verticesIds = null;
    Matrix config = null;
    Matrix update = null;
    ArrayList<Integer> lNeigh = null;
    VerticesPool leftPool = null;
    VerticesPool rightPool = null;
    Hashtable<Integer, Integer> leftCorr = new Hashtable();
    Hashtable<Integer, Integer> rightCorr = new Hashtable();
    Hashtable<Integer, Integer> IdToLine = new Hashtable();
    Hashtable<Integer, Integer> IdToColumn = new Hashtable();
    Hashtable<Integer, Integer> IdToLabel = new Hashtable();
    ArrayList<Integer> usefulIds = new ArrayList();
    int[] dynIndices = null;
    AssignmentMethods tps = new AssignmentMethodsImpl();
    int dynIndSz = 0;
    boolean adapt = true;
    boolean select = true;

    public OLAMatrixUpdateImpl(int[] nArray, int[] nArray2, int n, Hashtable<Integer, Integer> hashtable, Hashtable<Integer, Integer> hashtable2, VerticesPool verticesPool, VerticesPool verticesPool2) {
        int n2;
        this.verticesIds = nArray;
        this.leftCorr = hashtable;
        this.rightCorr = hashtable2;
        this.leftPool = verticesPool;
        this.rightPool = verticesPool2;
        int n3 = nArray2.length;
        this.dynIndSz = n - n3;
        this.dynIndices = new int[this.dynIndSz];
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (n2 = 0; n2 < n3; ++n2) {
            hashSet.add(new Integer(nArray2[n2]));
        }
        n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (hashSet.contains(new Integer(i))) continue;
            this.dynIndices[n2] = i;
            ++n2;
        }
    }

    public Matrix matrixUpdate(OntologyGraph ontologyGraph, AdjacencyMatrix adjacencyMatrix, Vector vector, boolean bl, boolean bl2) {
        this.adapt = bl;
        this.select = bl2;
        this.update = adjacencyMatrix.getMatrix();
        int n = adjacencyMatrix.getNumberOfLines();
        for (int i = 0; i < this.dynIndSz; ++i) {
            int n2 = this.dynIndices[i];
            Hashtable<Integer, Integer> hashtable = this.getSelectedEntries(n2, ontologyGraph, adjacencyMatrix, vector);
            this.lineUpdate(n2, n, hashtable, ontologyGraph, adjacencyMatrix);
        }
        return this.update;
    }

    public Hashtable<Integer, Integer> getSelectedEntries(int n, OntologyGraph ontologyGraph, AdjacencyMatrix adjacencyMatrix, Vector vector) {
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        int n2 = ontologyGraph.getEdgePool().numberOfPart();
        this.usefulIds.clear();
        for (int i = 0; i < n2; ++i) {
            Integer n3 = new Integer(i);
            Matrix matrix = this.buildLineEntriesSelectionMatrix(n, i, ontologyGraph, adjacencyMatrix, vector);
            if (this.select && (this.config.numRows() > 1 || this.config.numColumns() > 1)) {
                Matrix matrix2 = this.tps.greedy(matrix);
                int n4 = matrix2.numRows();
                for (int j = 0; j < n4; ++j) {
                    int n5 = (int)matrix2.get(j, 0);
                    int n6 = (int)matrix2.get(j, 1);
                    Integer n7 = new Integer((int)this.config.get(n5, n6));
                    hashtable.put(n7, n3);
                }
                continue;
            }
            for (Integer n8 : this.lNeigh) {
                hashtable.put(n8, n3);
            }
        }
        return hashtable;
    }

    public Matrix buildLineEntriesSelectionMatrix(int n, int n2, OntologyGraph ontologyGraph, AdjacencyMatrix adjacencyMatrix, Vector vector) {
        int n3 = this.verticesIds[n];
        Vertice vertice = (Vertice)ontologyGraph.getVerticePool().get(n3);
        this.lNeigh = vertice.getNeighborhood(n2, false);
        int n4 = vertice.getNeighborhoodSize(n2, false);
        Matrix matrix = this.buildMatrix(this.lNeigh, n4);
        for (int i = 0; i < n4; ++i) {
            Integer n5 = this.lNeigh.get(i);
            int n6 = adjacencyMatrix.getLineIndice(n5);
            double d = vector.get(n6);
            Integer n7 = this.leftCorr.get(n5);
            int n8 = this.IdToLine.get(n7);
            Integer n9 = this.rightCorr.get(n5);
            int n10 = this.IdToColumn.get(n9);
            matrix.set(n8, n10, d);
            this.config.set(n8, n10, (double)n5.intValue());
            this.usefulIds.add(n5);
        }
        return matrix;
    }

    @Override
    public Matrix buildMatrix(ArrayList<Integer> arrayList, int n) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            Integer n4;
            Integer n5 = arrayList.get(i);
            Integer n6 = this.leftCorr.get(n5);
            boolean bl = hashSet.add(n6);
            if (bl) {
                ++n2;
            }
            if (!(bl = hashSet2.add(n4 = this.rightCorr.get(n5)))) continue;
            ++n3;
        }
        this.config = new DenseMatrix(n2, n3);
        DenseMatrix denseMatrix = new DenseMatrix(n2, n3);
        this.IdToLine.clear();
        this.IdToColumn.clear();
        int n7 = 0;
        for (Integer n8 : hashSet) {
            this.IdToLine.put(n8, new Integer(n7));
            ++n7;
        }
        n7 = 0;
        for (Integer n9 : hashSet2) {
            this.IdToColumn.put(n9, new Integer(n7));
            ++n7;
        }
        return denseMatrix;
    }

    public void lineUpdate(int n, int n2, Hashtable<Integer, Integer> hashtable, OntologyGraph ontologyGraph, AdjacencyMatrix adjacencyMatrix) {
        int n3;
        int n4;
        Integer n5;
        int n6;
        double[] dArray = this.allEdgesWeight(n, ontologyGraph);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(hashtable.keySet());
        int n7 = arrayList.size();
        this.usefulIds.removeAll(arrayList);
        int n8 = this.usefulIds.size();
        for (n6 = 0; n6 < n8; ++n6) {
            n5 = this.usefulIds.get(n6);
            n4 = n5;
            n3 = adjacencyMatrix.getColumnIndice(n4);
            this.update.set(n, n3, 0.0);
        }
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = arrayList.get(n6);
            n4 = n5;
            n3 = adjacencyMatrix.getColumnIndice(n4);
            int n9 = hashtable.get(n5);
            int n10 = this.getNormalizationValue(n9, this.verticesIds[n], ontologyGraph);
            double d = dArray[n9] / (double)n10;
            this.update.set(n, n3, d);
        }
    }

    @Override
    public double[] allEdgesWeight(int n, OntologyGraph ontologyGraph) {
        Vertice vertice = (Vertice)ontologyGraph.getVerticePool().get(this.verticesIds[n]);
        int n2 = ontologyGraph.getEdgePool().numberOfPart();
        int[] nArray = new int[n2];
        double[] dArray = new double[n2];
        int n3 = 0;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = vertice.getNeighborhoodSize(i, false);
            if (nArray[i] > 0) {
                ++n3;
            }
            dArray[i] = this.getEdgeWeight(vertice, i, ontologyGraph);
            d += dArray[i];
        }
        if (this.adapt) {
            if (d < 1.0) {
                d2 = 1.0 - d;
            }
            double d3 = 0.0;
            if (n3 > 0) {
                d3 = d2 / (double)n3;
            }
            for (int i = 0; i < n2; ++i) {
                if (nArray[i] <= 0 || i == 8) continue;
                dArray[i] = dArray[i] + d3;
            }
        }
        return dArray;
    }

    public double getEdgeWeight(Vertice vertice, int n, OntologyGraph ontologyGraph) {
        double d = 0.0;
        ArrayList<Integer> arrayList = vertice.getEdges(n, false);
        if (!arrayList.isEmpty()) {
            int n2 = arrayList.get(0);
            d = ((Edge)ontologyGraph.getEdgePool().get(n2)).getWeight();
        }
        return d;
    }

    @Override
    public int getNormalizationValue(int n, int n2, OntologyGraph ontologyGraph) {
        int n3 = 0;
        Integer n4 = new Integer(n2);
        int n5 = this.leftCorr.get(n4);
        int n6 = this.rightCorr.get(n4);
        Vertice vertice = (Vertice)this.leftPool.get(n5);
        Vertice vertice2 = (Vertice)this.rightPool.get(n6);
        int n7 = vertice.getNeighborhoodSize(n, false);
        int n8 = vertice2.getNeighborhoodSize(n, false);
        n3 = this.adapt ? Math.max(n7, n8) : n7 * n8;
        return n3;
    }

    public void clearAll() {
        this.verticesIds = null;
        this.leftCorr.clear();
        this.leftCorr = null;
        this.rightCorr.clear();
        this.rightCorr = null;
        this.IdToLine.clear();
        this.IdToLine = null;
        this.IdToColumn.clear();
        this.IdToColumn = null;
        this.lNeigh.clear();
        this.lNeigh = null;
        this.config = null;
    }
}

