/*
 * Decompiled with CFR 0.152.
 */
package ca.uqam.info.latece.sboa.impl.amatrix;

import ca.uqam.info.latece.sboa.inter.amatrix.AdjacencyMatrix;
import ca.uqam.info.latece.sboa.inter.ograph.Edge;
import ca.uqam.info.latece.sboa.inter.ograph.Vertice;
import ca.uqam.info.latece.sboa.inter.ograph.VerticesPool;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdjacencyMatrixImpl
implements AdjacencyMatrix {
    private String name = null;
    private String type = null;
    private Matrix matrix = null;
    private int[] lineVerticeIds = null;
    private int[] colVerticeIds = null;
    private int[] nzLines = null;
    private int[] nzColumns = null;
    private int lines = 0;
    private int columns = 0;
    private Hashtable<Integer, Integer> lineIdToIndice = new Hashtable();
    private Hashtable<Integer, Integer> colIdToIndice = new Hashtable();

    public AdjacencyMatrixImpl() {
    }

    public AdjacencyMatrixImpl(Edge[] edgeArray) {
        this.build(edgeArray);
    }

    @Override
    public void build(Edge[] edgeArray) {
        this.insertAllVertices(edgeArray);
        for (Edge edge : edgeArray) {
            Integer n = new Integer(edge.getHead());
            int n2 = this.colIdToIndice.get(n);
            Integer n3 = new Integer(edge.getTail());
            int n4 = this.lineIdToIndice.get(n3);
            double d = edge.getWeight();
            this.matrix.set(n4, n2, d);
        }
    }

    @Override
    public void insertAllVertices(Edge[] edgeArray) {
        int n;
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
        int n2 = edgeArray.length;
        this.lines = 0;
        this.columns = 0;
        for (n = 0; n < n2; ++n) {
            Integer n3;
            boolean bl;
            Edge edge = edgeArray[n];
            Integer n4 = new Integer(edge.getHead());
            boolean bl2 = treeSet2.add(n4);
            if (bl2) {
                ++this.columns;
            }
            if (!(bl = treeSet.add(n3 = new Integer(edge.getTail())))) continue;
            ++this.lines;
        }
        this.lineVerticeIds = new int[this.lines];
        this.nzLines = new int[this.lines];
        for (n = 0; n < this.lines; ++n) {
            this.nzLines[n] = 0;
        }
        this.colVerticeIds = new int[this.columns];
        this.nzColumns = new int[this.columns];
        for (n = 0; n < this.columns; ++n) {
            this.nzColumns[n] = 0;
        }
        this.matrix = new FlexCompRowMatrix(this.lines, this.columns);
        this.insertVertice(treeSet, treeSet2);
    }

    @Override
    public void insertVertice(TreeSet<Integer> treeSet, TreeSet<Integer> treeSet2) {
        Integer n;
        Object object;
        Iterator<Integer> iterator = treeSet.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            object = iterator.next();
            this.lineVerticeIds[n2] = (Integer)object;
            n = new Integer(n2);
            this.lineIdToIndice.put((Integer)object, n);
            ++n2;
        }
        object = treeSet2.iterator();
        n2 = 0;
        while (object.hasNext()) {
            n = (Integer)object.next();
            this.colVerticeIds[n2] = n;
            Integer n3 = new Integer(n2);
            this.colIdToIndice.put(n, n3);
            ++n2;
        }
    }

    public AdjacencyMatrixImpl(String string, String string2, Matrix matrix, int[] nArray, int[] nArray2) {
        this.build(string, string2, matrix, nArray, nArray2);
    }

    @Override
    public void build(String string, String string2, Matrix matrix, int[] nArray, int[] nArray2) {
        Integer n;
        Integer n2;
        int n3;
        this.name = string;
        this.type = string2;
        this.matrix = matrix;
        this.lineVerticeIds = nArray;
        this.colVerticeIds = nArray2;
        this.lines = this.matrix.numRows();
        this.columns = this.matrix.numColumns();
        for (n3 = 0; n3 < this.lines; ++n3) {
            n2 = new Integer(this.lineVerticeIds[n3]);
            n = new Integer(n3);
            this.lineIdToIndice.put(n2, n);
        }
        for (n3 = 0; n3 < this.columns; ++n3) {
            n2 = new Integer(this.colVerticeIds[n3]);
            n = new Integer(n3);
            this.colIdToIndice.put(n2, n);
        }
    }

    @Override
    public int[] getLineVerticeIds() {
        return this.lineVerticeIds;
    }

    @Override
    public int[] getColVerticeIds() {
        return this.colVerticeIds;
    }

    @Override
    public int getLineIndice(int n) {
        return this.lineIdToIndice.get(new Integer(n));
    }

    @Override
    public int getColumnIndice(int n) {
        return this.colIdToIndice.get(new Integer(n));
    }

    @Override
    public void updateWithStaticLineVertice(int[] nArray, int n) {
        int[] nArray2 = this.getStaticLineVerticeIds(nArray, n);
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            this.matrix.set(n2, n2, 1.0);
        }
    }

    @Override
    public void updateWithStaticColVertice(int[] nArray, int n) {
        int[] nArray2 = this.getStaticColVerticeIds(nArray, n);
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            this.matrix.set(n2, n2, 1.0);
        }
    }

    @Override
    public int[] getStaticLineVerticeIds(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            Integer n2 = new Integer(nArray[i]);
            nArray2[i] = this.lineIdToIndice.get((int)n2);
        }
        return nArray2;
    }

    @Override
    public int[] getStaticColVerticeIds(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            Integer n2 = new Integer(nArray[i]);
            nArray2[i] = this.colIdToIndice.get((int)n2);
        }
        return nArray2;
    }

    @Override
    public Matrix getMatrix() {
        return this.matrix;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getNumberOfColums() {
        return this.columns;
    }

    @Override
    public int getNumberOfLines() {
        return this.lines;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setMatrix(Matrix matrix) {
        this.matrix = matrix;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public void setNumberOfColums(int n) {
        this.columns = n;
    }

    @Override
    public void setNumberOfLines(int n) {
        this.lines = n;
    }

    @Override
    public void setType(String string) {
        this.type = string;
    }

    @Override
    public void viewMatrix(VerticesPool verticesPool) {
        for (int i = 0; i < this.lines; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                if (this.matrix.get(i, j) == 0.0) continue;
                String string = ((Vertice)verticesPool.get(this.lineVerticeIds[i])).getLabel();
                String string2 = ((Vertice)verticesPool.get(this.colVerticeIds[j])).getLabel();
                System.err.println(string + "[" + this.lineVerticeIds[i] + "]" + "<-" + string2 + "[" + this.colVerticeIds[j] + "]" + "= " + this.matrix.get(i, j));
            }
        }
    }

    @Override
    public void clearAll() {
        this.name = null;
        this.type = null;
        this.matrix = null;
        this.lineVerticeIds = null;
        this.colVerticeIds = null;
        this.lineIdToIndice.clear();
        this.colIdToIndice.clear();
    }
}

