/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.io.tptp;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.log4j.BasicConfigurator;
import org.semanticweb.owl.io.RendererException;
import org.semanticweb.owl.io.ShortFormProvider;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValue;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLIndividualAxiom;
import org.semanticweb.owl.model.OWLNamedObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLPropertyAxiom;
import org.semanticweb.owl.model.helper.OntologyHelper;
import uk.ac.man.cs.img.owl.io.tptp.AxiomRenderer;
import uk.ac.man.cs.img.owl.io.tptp.RenderingVisitor;

public class Renderer
implements org.semanticweb.owl.io.Renderer,
ShortFormProvider {
    private PrintWriter pw;
    private Set allURIs;
    private List shortNames;
    private Map known;
    private int reservedNames;
    private String[] names = new String[]{"", "a_", "b_", "c_", "d_", "e_", "f_", "g_", "h_", "i_", "j_", "k_", "l_", "m_", "n_", "o_", "p_", "q_", "r_", "s_", "t_", "u_", "v_", "w_", "x_", "y_", "z_"};
    private Random random;
    private SimpleDateFormat sdf;
    private TimeZone gmt;
    private int axiomCount = 0;
    private Map anonymousIndividuals;
    private List axioms;
    private boolean singleAxiom = false;
    private boolean negate = false;
    public static int STRING = 0;
    public static int INTEGER = 1;
    public static int OTHER = 2;
    public static int TYPES = 3;
    private List stringDataValues;
    private List integerDataValues;
    private List otherDataValues;
    private List unsupportedDataTypes;
    public String[] typeNames = new String[]{"xsd_string", "xsd_integer", "unsupported_type"};

    public void setOptions(Map map) {
    }

    public Map getOptions() {
        return null;
    }

    public void setNegate(boolean b) {
        this.negate = b;
    }

    private void addAxiom(String axiom, String comment) {
        String[] strs = new String[]{axiom, comment};
        this.axioms.add(strs);
    }

    public void renderOntology(OWLOntology ontology, Writer writer) throws RendererException {
        this.renderOntology(ontology, writer, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList());
    }

    public void renderOntology(OWLOntology ontology, Writer writer, List names, List strings, List integers, List others, List types) throws RendererException {
        try {
            int outer;
            this.pw = new PrintWriter(writer);
            this.allURIs = OntologyHelper.allURIs((OWLOntology)ontology);
            this.axiomCount = 0;
            this.axioms = new ArrayList();
            this.shortNames = names;
            this.stringDataValues = strings;
            this.integerDataValues = integers;
            this.otherDataValues = others;
            this.unsupportedDataTypes = types;
            this.known = new HashMap();
            this.known.put("http://www.w3.org/2002/07/owl#", "owl");
            this.known.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
            this.known.put("http://www.w3.org/2000/01/rdf-schema#", "rdfs");
            this.known.put("http://www.w3.org/2001/XMLSchema#", "xsd");
            this.sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
            this.gmt = TimeZone.getTimeZone("GMT");
            this.sdf.setTimeZone(this.gmt);
            this.random = new Random();
            this.anonymousIndividuals = new HashMap();
            this.addAxiom("![X]: (abstractDomain(X) | dataDomain(X))", "Everything is in the Abstract or Data domain");
            this.addAxiom("?[X]: (abstractDomain(X))", "The abstract domain must be non-empty.");
            this.addAxiom("?[X]: (dataDomain(X))", "The data domain must be non-empty (we know that 1 exists)");
            this.addAxiom("![X]: (~(abstractDomain(X) & dataDomain(X)))", "The Abstract and Data domains are distinct");
            this.addAxiom("![X]: (iowlThing(X) => abstractDomain(X))", "Everything in Thing is Abstract");
            this.addAxiom("![X]: (iowlNothing(X) => abstractDomain(X))", "Anything in Nothing is abstract");
            this.addAxiom("![X]: (abstractDomain(X) => iowlThing(X))", "All Abstract things are in Thing");
            this.addAxiom("![X]: (~iowlNothing(X))", "Nothing is empty");
            this.addAxiom("![X]: (" + this.typeNames[STRING] + "(X) => dataDomain(X))", "Strings are Data objects ");
            this.addAxiom("![X]: (" + this.typeNames[INTEGER] + "(X) => dataDomain(X))", "Integers are Data objects ");
            this.addAxiom("![X]: (dataDomain(X) => ~(" + this.typeNames[STRING] + "(X) & " + this.typeNames[INTEGER] + "(X)))", "String and Integer are disjoint ");
            Set allOntologies = OntologyHelper.importClosure((OWLOntology)ontology);
            Iterator allIt = allOntologies.iterator();
            while (allIt.hasNext()) {
                OWLOntology ontologyToProcess = (OWLOntology)allIt.next();
                Iterator it = this.orderedEntities(ontologyToProcess.getClasses()).iterator();
                while (it.hasNext()) {
                    this.renderClass(ontologyToProcess, (OWLClass)it.next());
                }
                it = this.orderedEntities(ontologyToProcess.getObjectProperties()).iterator();
                while (it.hasNext()) {
                    this.renderObjectProperty(ontologyToProcess, (OWLObjectProperty)it.next());
                }
                it = this.orderedEntities(ontologyToProcess.getDataProperties()).iterator();
                while (it.hasNext()) {
                    this.renderDataProperty(ontologyToProcess, (OWLDataProperty)it.next());
                }
                it = this.orderedEntities(ontologyToProcess.getIndividuals()).iterator();
                while (it.hasNext()) {
                    this.renderIndividual(ontologyToProcess, (OWLIndividual)it.next());
                }
                it = this.orderedEntities(ontologyToProcess.getDatatypes()).iterator();
                while (it.hasNext()) {
                    this.renderDataType(ontologyToProcess, (OWLDataType)it.next());
                }
                it = this.orderedEntities(ontologyToProcess.getClassAxioms()).iterator();
                while (it.hasNext()) {
                    this.renderClassAxiom((OWLClassAxiom)it.next());
                }
                it = this.orderedEntities(ontologyToProcess.getPropertyAxioms()).iterator();
                while (it.hasNext()) {
                    this.renderPropertyAxiom((OWLPropertyAxiom)it.next());
                }
                it = this.orderedEntities(ontologyToProcess.getIndividualAxioms()).iterator();
                while (it.hasNext()) {
                    this.renderIndividualAxiom((OWLIndividualAxiom)it.next());
                }
            }
            this.writeUnsupportedDataTypes();
            for (outer = 0; outer < this.stringDataValues.size(); ++outer) {
                for (int inner = outer + 1; inner < this.stringDataValues.size(); ++inner) {
                    this.addAxiom("~equal(" + this.typeNames[STRING] + "_" + outer + "," + this.typeNames[STRING] + "_" + inner + ")", "String value disjoint");
                }
            }
            for (outer = 0; outer < this.integerDataValues.size(); ++outer) {
                for (int inner = outer + 1; inner < this.integerDataValues.size(); ++inner) {
                    this.addAxiom("~equal(" + this.typeNames[INTEGER] + "_" + this.integerDataValues.get(outer) + "," + this.typeNames[INTEGER] + "_" + this.integerDataValues.get(inner) + ")", "Integer value disjoint");
                }
            }
            if (this.negate) {
                this.pw.println("input_formula(the_axiom,axiom,(");
                this.pw.println("~(");
                Iterator it = this.axioms.iterator();
                while (it.hasNext()) {
                    String[] axiomAndComment = (String[])it.next();
                    if (axiomAndComment[1] != null) {
                        this.pw.println("%-- " + axiomAndComment[1]);
                    }
                    this.pw.println("( " + axiomAndComment[0] + ")");
                    if (!it.hasNext()) continue;
                    this.pw.println(" &");
                }
                this.pw.println(")");
                this.pw.println(")).");
            } else if (this.singleAxiom) {
                this.pw.println("input_formula(the_axiom,axiom,(");
                Iterator it = this.axioms.iterator();
                while (it.hasNext()) {
                    String[] axiomAndComment = (String[])it.next();
                    if (axiomAndComment[1] != null) {
                        this.pw.println("%-- " + axiomAndComment[1]);
                    }
                    this.pw.println(axiomAndComment[0]);
                    if (!it.hasNext()) continue;
                    this.pw.println(" &");
                }
                this.pw.println(")).");
            } else {
                Iterator it = this.axioms.iterator();
                while (it.hasNext()) {
                    String[] axiomAndComment = (String[])it.next();
                    if (axiomAndComment[1] != null) {
                        this.pw.println("%-- " + axiomAndComment[1]);
                    }
                    this.pw.println("input_formula(axiom_" + this.axiomCount++ + ",axiom,(");
                    this.pw.println(" " + axiomAndComment[0]);
                    this.pw.println(")).");
                }
            }
        }
        catch (BigCardinalityException ex) {
            throw ex;
        }
        catch (OWLException ex) {
            throw new RendererException(ex.getMessage());
        }
    }

    private void renderClass(OWLOntology ontology, OWLClass clazz) throws OWLException {
        OWLDescription eq;
        this.addAxiom("![X]: (" + this.shortForm((OWLNamedObject)clazz) + "(X) => abstractDomain(X))", "Class " + this.shortForm((OWLNamedObject)clazz) + " is subset of Abstract domain");
        Iterator it = clazz.getEquivalentClasses(ontology).iterator();
        while (it.hasNext()) {
            eq = (OWLDescription)it.next();
            this.equality((OWLDescription)clazz, eq, "Equality " + this.shortForm((OWLNamedObject)clazz));
        }
        it = clazz.getSuperClasses(ontology).iterator();
        while (it.hasNext()) {
            eq = (OWLDescription)it.next();
            this.implication((OWLDescription)clazz, eq, "Super " + this.shortForm((OWLNamedObject)clazz));
        }
        it = clazz.getEnumerations(ontology).iterator();
        while (it.hasNext()) {
            eq = (OWLDescription)it.next();
            this.equality((OWLDescription)clazz, eq, "Enumeration " + this.shortForm((OWLNamedObject)clazz));
        }
    }

    private void renderIndividual(OWLOntology ontology, OWLIndividual ind) throws OWLException {
        if (ind.getTypes(ontology).isEmpty() && ind.getObjectPropertyValues(ontology).keySet().isEmpty() && ind.getDataPropertyValues(ontology).keySet().isEmpty()) {
            this.addAxiom("abstractDomain(" + this.shortForm((OWLNamedObject)ind) + ")", this.shortForm((OWLNamedObject)ind));
        } else {
            Iterator it = ind.getTypes(ontology).iterator();
            while (it.hasNext()) {
                RenderingVisitor rv1 = new RenderingVisitor(this, this.shortForm((OWLNamedObject)ind), new HashSet());
                OWLDescription eq = (OWLDescription)it.next();
                eq.accept((OWLObjectVisitor)rv1);
                this.addAxiom(rv1.result(), this.shortForm((OWLNamedObject)ind));
            }
            Map propertyValues = ind.getObjectPropertyValues(ontology);
            Iterator it2 = propertyValues.keySet().iterator();
            while (it2.hasNext()) {
                OWLObjectProperty prop = (OWLObjectProperty)it2.next();
                Set vals = (Set)propertyValues.get(prop);
                Iterator valIt = vals.iterator();
                while (valIt.hasNext()) {
                    OWLIndividual oi = (OWLIndividual)valIt.next();
                    this.addAxiom(this.shortForm((OWLNamedObject)prop) + "(" + this.shortForm((OWLNamedObject)ind) + "," + this.shortForm((OWLNamedObject)oi) + ")", this.shortForm((OWLNamedObject)ind) + ":" + this.shortForm((OWLNamedObject)prop) + ":" + this.shortForm((OWLNamedObject)oi));
                }
            }
            Map dataValues = ind.getDataPropertyValues(ontology);
            Iterator it3 = dataValues.keySet().iterator();
            while (it3.hasNext()) {
                OWLDataProperty prop = (OWLDataProperty)it3.next();
                Set vals = (Set)dataValues.get(prop);
                Iterator valIt = vals.iterator();
                while (valIt.hasNext()) {
                    OWLDataValue dv = (OWLDataValue)valIt.next();
                    this.addAxiom(this.shortForm((OWLNamedObject)prop) + "(" + this.shortForm((OWLNamedObject)ind) + "," + this.canonicalize(dv) + ")", this.shortForm((OWLNamedObject)ind) + ":" + this.shortForm((OWLNamedObject)prop) + ":" + this.canonicalize(dv));
                }
            }
        }
    }

    private void renderObjectProperty(OWLOntology ontology, OWLObjectProperty prop) throws OWLException {
        Iterator it;
        StringWriter sw = new StringWriter();
        sw.write("![X,Y]: ");
        sw.write("(" + this.shortForm((OWLNamedObject)prop) + "(X,Y) => (abstractDomain(X) & abstractDomain(Y)))");
        this.addAxiom(sw.toString(), "ObjectProperty: " + this.shortForm((OWLNamedObject)prop));
        if (!prop.getSuperProperties(ontology).isEmpty()) {
            it = prop.getSuperProperties(ontology).iterator();
            while (it.hasNext()) {
                OWLObjectProperty sup = (OWLObjectProperty)it.next();
                this.addAxiom("![X,Y]: (" + this.shortForm((OWLNamedObject)prop) + "(X,Y) => " + this.shortForm((OWLNamedObject)sup) + "(X,Y)) ", "Super: " + this.shortForm((OWLNamedObject)prop));
            }
        }
        if (prop.isFunctional(ontology)) {
            this.addAxiom("![X,Y,Z]: (" + this.shortForm((OWLNamedObject)prop) + "(X,Y) & " + this.shortForm((OWLNamedObject)prop) + "(X,Z) => equal(Y,Z))", "Functional: " + this.shortForm((OWLNamedObject)prop));
        }
        if (prop.isInverseFunctional(ontology)) {
            this.addAxiom("![X,Y,Z]: (" + this.shortForm((OWLNamedObject)prop) + "(Y,X) & " + this.shortForm((OWLNamedObject)prop) + "(Z,X) => equal(Y,Z))", "InverseFunctional: " + this.shortForm((OWLNamedObject)prop));
        }
        if (prop.isTransitive(ontology)) {
            this.addAxiom("![X,Y,Z]: (" + this.shortForm((OWLNamedObject)prop) + "(X,Y) & " + this.shortForm((OWLNamedObject)prop) + "(Y,Z) => " + this.shortForm((OWLNamedObject)prop) + "(X,Z))", "Transitive: " + this.shortForm((OWLNamedObject)prop));
        }
        it = prop.getDomains(ontology).iterator();
        while (it.hasNext()) {
            sw = new StringWriter();
            sw.write("![X,Y]: ");
            sw.write("(" + this.shortForm((OWLNamedObject)prop) + "(X,Y) => ");
            OWLDescription dom = (OWLDescription)it.next();
            RenderingVisitor rv = new RenderingVisitor(this, "X", new HashSet());
            dom.accept((OWLObjectVisitor)rv);
            sw.write(rv.result() + ")");
            this.addAxiom(sw.toString(), "Domain: " + this.shortForm((OWLNamedObject)prop));
        }
        it = prop.getRanges(ontology).iterator();
        while (it.hasNext()) {
            sw = new StringWriter();
            sw.write("![X,Y]: (" + this.shortForm((OWLNamedObject)prop) + "(X,Y) => ");
            OWLDescription ran = (OWLDescription)it.next();
            HashSet<String> s = new HashSet<String>();
            s.add("X");
            RenderingVisitor rv = new RenderingVisitor(this, "Y", s);
            ran.accept((OWLObjectVisitor)rv);
            sw.write(rv.result() + ")");
            this.addAxiom(sw.toString(), "Range: " + this.shortForm((OWLNamedObject)prop));
        }
        if (prop.isSymmetric(ontology)) {
            this.addAxiom("![X,Y]: (" + this.shortForm((OWLNamedObject)prop) + "(X,Y) => " + this.shortForm((OWLNamedObject)prop) + "(Y,X))", "Symmetric: " + this.shortForm((OWLNamedObject)prop));
        }
        it = prop.getInverses(ontology).iterator();
        while (it.hasNext()) {
            OWLObjectProperty inv = (OWLObjectProperty)it.next();
            this.addAxiom("![X,Y]: (" + this.shortForm((OWLNamedObject)prop) + "(X,Y) <=> " + this.shortForm((OWLNamedObject)inv) + "(Y,X))", "Inverse: " + this.shortForm((OWLNamedObject)prop));
        }
    }

    private void renderDataProperty(OWLOntology ontology, OWLDataProperty prop) throws OWLException {
        Iterator it;
        StringWriter sw = new StringWriter();
        sw.write("![X,Y]: ");
        sw.write("(" + this.shortForm((OWLNamedObject)prop) + "(X,Y) => (abstractDomain(X) & dataDomain(Y)))");
        this.addAxiom(sw.toString(), "DataProperty: " + this.shortForm((OWLNamedObject)prop));
        if (!prop.getSuperProperties(ontology).isEmpty()) {
            it = prop.getSuperProperties(ontology).iterator();
            while (it.hasNext()) {
                OWLObjectProperty sup = (OWLObjectProperty)it.next();
                this.addAxiom("![X,Y]: (" + this.shortForm((OWLNamedObject)prop) + "(X,Y) => " + this.shortForm((OWLNamedObject)sup) + "(X,Y))", "Super: " + this.shortForm((OWLNamedObject)prop));
            }
        }
        if (prop.isFunctional(ontology)) {
            this.addAxiom("![X,Y,Z]: (" + this.shortForm((OWLNamedObject)prop) + "(X,Y) & " + this.shortForm((OWLNamedObject)prop) + "(X,Z) => equal(Y,Z))", "Functional: " + this.shortForm((OWLNamedObject)prop));
        }
        it = prop.getDomains(ontology).iterator();
        while (it.hasNext()) {
            sw = new StringWriter();
            sw.write("![X,Y]: (" + this.shortForm((OWLNamedObject)prop) + "(X,Y) => ");
            OWLDescription dom = (OWLDescription)it.next();
            RenderingVisitor rv = new RenderingVisitor(this, "X", new HashSet());
            dom.accept((OWLObjectVisitor)rv);
            sw.write(rv.result() + ")");
            this.addAxiom(sw.toString(), "Domain: " + this.shortForm((OWLNamedObject)prop));
        }
        it = prop.getRanges(ontology).iterator();
        while (it.hasNext()) {
            sw = new StringWriter();
            sw.write("![X,Y]: (" + this.shortForm((OWLNamedObject)prop) + "(X,Y) => ");
            OWLDataRange ran = (OWLDataRange)it.next();
            HashSet<String> s = new HashSet<String>();
            s.add("X");
            RenderingVisitor rv = new RenderingVisitor(this, "Y", s);
            ran.accept((OWLObjectVisitor)rv);
            sw.write(rv.result() + ")");
            this.addAxiom(sw.toString(), "Range: " + this.shortForm((OWLNamedObject)prop));
        }
    }

    private void renderDataType(OWLOntology ontology, OWLDataType datatype) throws OWLException {
        this.addAxiom("![X]: (" + this.typeFor(datatype) + "(X) => dataDomain(X))", this.typeFor(datatype) + " is a datatype");
    }

    private void renderClassAxiom(OWLClassAxiom axiom) throws OWLException {
        AxiomRenderer ar = new AxiomRenderer(this);
        axiom.accept((OWLObjectVisitor)ar);
        String str = ar.result();
        if (!str.equals("")) {
            this.addAxiom(ar.result(), null);
        }
    }

    private void renderPropertyAxiom(OWLPropertyAxiom axiom) throws OWLException {
        AxiomRenderer ar = new AxiomRenderer(this);
        axiom.accept((OWLObjectVisitor)ar);
        String str = ar.result();
        if (!str.equals("")) {
            this.addAxiom(ar.result(), null);
        }
    }

    private void renderIndividualAxiom(OWLIndividualAxiom axiom) throws OWLException {
        AxiomRenderer ar = new AxiomRenderer(this);
        axiom.accept((OWLObjectVisitor)ar);
        this.addAxiom(ar.result(), null);
    }

    private void implication(OWLDescription desc1, OWLDescription desc2, String comment) throws OWLException {
        RenderingVisitor rv1 = new RenderingVisitor(this, "X", new HashSet());
        desc1.accept((OWLObjectVisitor)rv1);
        RenderingVisitor rv2 = new RenderingVisitor(this, "X", new HashSet());
        desc2.accept((OWLObjectVisitor)rv2);
        this.addAxiom("![X]: (" + rv1.result() + " => " + rv2.result() + ")", comment);
    }

    private void equality(OWLDescription desc1, OWLDescription desc2, String comment) throws OWLException {
        RenderingVisitor rv1 = new RenderingVisitor(this, "X", new HashSet());
        desc1.accept((OWLObjectVisitor)rv1);
        RenderingVisitor rv2 = new RenderingVisitor(this, "X", new HashSet());
        desc2.accept((OWLObjectVisitor)rv2);
        this.addAxiom("![X]: (" + rv1.result() + " <=> " + rv2.result() + ")", comment);
    }

    private void generateShortNames() {
        this.shortNames = new ArrayList();
        Iterator it = this.allURIs.iterator();
        while (it.hasNext()) {
            try {
                URI uri = (URI)it.next();
                if (uri.getFragment() == null) continue;
                String ssp = new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null).toString();
                if (!ssp.endsWith("#")) {
                    ssp = ssp + "#";
                }
                if (this.known.keySet().contains(ssp) || this.shortNames.contains(ssp)) continue;
                this.shortNames.add(ssp);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
    }

    private void writeShortNames() {
        String ns;
        this.pw.println("% ============= Namespaces ============= ");
        Iterator it = this.known.keySet().iterator();
        while (it.hasNext()) {
            ns = (String)it.next();
            String shrt = (String)this.known.get(ns);
            this.pw.println("%  " + shrt + "\t= " + ns);
        }
        for (int i = 0; i < this.shortNames.size(); ++i) {
            if (i >= this.names.length) continue;
            ns = (String)this.shortNames.get(i);
            this.pw.println("%  " + this.names[i] + "\t= " + ns);
        }
        this.pw.println("% ====================================== ");
    }

    private void writeUnsupportedDataTypes() {
        if (!this.unsupportedDataTypes.isEmpty()) {
            this.pw.print("%_Unsupported_Types: ");
            Iterator it = this.unsupportedDataTypes.iterator();
            while (it.hasNext()) {
                this.pw.print(it.next());
                if (!it.hasNext()) continue;
                this.pw.print(" ");
            }
            this.pw.println();
        }
        for (int i = 0; i < this.unsupportedDataTypes.size(); ++i) {
            this.addAxiom("![X]: (" + this.typeNames[OTHER] + "_" + i + "(X) => dataDomain(X))", "Data types are subsets of the data domain");
        }
    }

    public String mangle(String str) {
        String result = str;
        try {
            result = URLEncoder.encode(str, "utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        result = result.replace('-', '_');
        result = result.replace('%', '_');
        result = result.replace('.', 'x');
        return result;
    }

    public int determineType(URI uri) throws OWLException {
        if (uri == null || uri.toString().equals("http://www.w3.org/2001/XMLSchema#string")) {
            return STRING;
        }
        if (uri.toString().equals("http://www.w3.org/2001/XMLSchema#integer")) {
            return INTEGER;
        }
        return OTHER;
    }

    public String typeFor(OWLDataType odt) throws OWLException {
        URI uri = odt.getURI();
        if (this.determineType(odt.getURI()) == STRING) {
            return this.typeNames[STRING];
        }
        if (this.determineType(odt.getURI()) == INTEGER) {
            return this.typeNames[INTEGER];
        }
        return this.typeNames[OTHER] + "_" + this.indexForUnsupported(odt.getURI().toString());
    }

    public int indexForUnsupported(String str) {
        if (!this.unsupportedDataTypes.contains(str)) {
            this.unsupportedDataTypes.add(str);
        }
        return this.unsupportedDataTypes.indexOf(str);
    }

    public int determineType(OWLDataValue dv) throws OWLException {
        return this.determineType(dv.getURI());
    }

    public String canonicalize(OWLDataValue dv) throws OWLException {
        int t = this.determineType(dv);
        if (t == STRING) {
            Object v = dv.getValue();
            if (!this.stringDataValues.contains(v)) {
                this.stringDataValues.add(v);
                this.addAxiom(this.typeNames[t] + "(" + this.typeNames[t] + "_" + this.stringDataValues.indexOf(v) + ")", "Data value");
            }
            return this.typeNames[t] + "_" + this.stringDataValues.indexOf(v);
        }
        if (t == INTEGER) {
            try {
                int i = Integer.parseInt((String)dv.getValue());
                Integer integer = new Integer(i);
                if (!this.integerDataValues.contains(integer)) {
                    this.integerDataValues.add(integer);
                    this.addAxiom(this.typeNames[t] + "(" + this.typeNames[t] + "_" + i + ")", "Data value");
                }
                return this.typeNames[t] + "_" + i;
            }
            catch (NumberFormatException ex) {
                throw new RendererException(ex.getMessage());
            }
        }
        if (t == OTHER) {
            String v = dv.getURI().toString() + "@" + dv.getValue().toString();
            if (!this.otherDataValues.contains(v)) {
                this.otherDataValues.add(v);
                this.addAxiom(this.typeNames[t] + "_" + this.indexForUnsupported(dv.getURI().toString()) + "(" + this.typeNames[t] + "_value_" + this.otherDataValues.indexOf(v) + ")", "Data value");
            }
            return this.typeNames[t] + "_value_" + this.otherDataValues.indexOf(v);
        }
        throw new RendererException("Problem with Datatype canonicalization");
    }

    public String shortForm(OWLNamedObject ono) throws OWLException {
        OWLIndividual oi;
        String prefix = "i";
        if (ono instanceof OWLIndividual && (oi = (OWLIndividual)ono).isAnonymous()) {
            if (!this.anonymousIndividuals.containsKey(oi)) {
                String newName = this.mangle(prefix + this.sdf.format(new Date()) + "" + this.random.nextInt(1000) + "");
                this.anonymousIndividuals.put(oi, newName);
            }
            return (String)this.anonymousIndividuals.get(oi);
        }
        URI uri = ono.getURI();
        if (uri == null) {
            return "xxx";
        }
        return this.shortForm(uri);
    }

    public String shortForm(URI uri) {
        String prefix = "i";
        if (uri == null) {
            return "xxx";
        }
        try {
            if (uri.getFragment() == null) {
                return this.mangle(prefix + uri.toString());
            }
            String ssp = new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null).toString();
            if (!ssp.endsWith("#")) {
                ssp = ssp + "#";
            }
            if (this.known.keySet().contains(ssp)) {
                return this.mangle(prefix + (String)this.known.get(ssp) + uri.getFragment());
            }
            if (!this.shortNames.contains(ssp)) {
                this.shortNames.add(ssp);
            }
            if (this.shortNames.indexOf(ssp) < this.names.length) {
                return this.mangle(prefix + this.names[this.shortNames.indexOf(ssp)] + uri.getFragment());
            }
            return this.mangle(prefix + uri.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            return this.mangle(prefix + uri.toString());
        }
    }

    private SortedSet orderedEntities(Set entities) {
        TreeSet ss = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                try {
                    return ((OWLEntity)o1).getURI().toString().compareTo(((OWLEntity)o2).getURI().toString());
                }
                catch (Exception ex) {
                    return o1.toString().compareTo(o2.toString());
                }
            }
        });
        ss.addAll(entities);
        return ss;
    }

    public static void main(String[] args) {
        try {
            URI uri;
            BasicConfigurator.configure();
            boolean neg = false;
            if (args.length > 1) {
                neg = args[0].equals("-n");
                uri = new URI(args[1]);
            } else {
                uri = new URI(args[0]);
            }
            OWLOntology onto = OntologyHelper.getOntology((URI)uri);
            Renderer renderer = new Renderer();
            renderer.setNegate(neg);
            StringWriter writer = new StringWriter();
            renderer.renderOntology(onto, writer);
            System.out.println(((Object)writer).toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void cardinalityException(String message) throws OWLException {
        throw new BigCardinalityException(message);
    }

    public class BigCardinalityException
    extends RendererException {
        public BigCardinalityException(String message) {
            super(message);
        }
    }
}

