/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.io.tptp;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.model.OWLDataPropertyInstance;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentPropertiesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLFunctionalPropertyAxiom;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLIndividualTypeAssertion;
import org.semanticweb.owl.model.OWLInverseFunctionalPropertyAxiom;
import org.semanticweb.owl.model.OWLInversePropertyAxiom;
import org.semanticweb.owl.model.OWLNamedObject;
import org.semanticweb.owl.model.OWLObjectPropertyInstance;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLProperty;
import org.semanticweb.owl.model.OWLPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSubPropertyAxiom;
import org.semanticweb.owl.model.OWLSymmetricPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitivePropertyAxiom;
import org.semanticweb.owl.model.helper.OWLObjectVisitorAdapter;
import uk.ac.man.cs.img.owl.io.tptp.Renderer;
import uk.ac.man.cs.img.owl.io.tptp.RenderingVisitor;

public class AxiomRenderer
extends OWLObjectVisitorAdapter {
    Renderer renderer;
    StringWriter sw;
    PrintWriter pw;
    int level;
    boolean indenting = true;
    String var;
    Set boundVariables;
    private String[] variables = new String[]{"X", "Y", "Z", "W", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V"};

    public AxiomRenderer(Renderer renderer) {
        this.renderer = renderer;
        this.sw = new StringWriter();
        this.pw = new PrintWriter(this.sw);
    }

    public String result() {
        return this.sw.toString();
    }

    public void visit(OWLEquivalentClassesAxiom axiom) throws OWLException {
        if (axiom.getEquivalentClasses().size() > 1) {
            this.pw.print("![X]: (");
            Object[] eqs = axiom.getEquivalentClasses().toArray();
            for (int i = 0; i < eqs.length; ++i) {
                for (int j = i + 1; j < eqs.length; ++j) {
                    RenderingVisitor rv1 = new RenderingVisitor(this.renderer, "X", new HashSet());
                    OWLDescription desc1 = (OWLDescription)eqs[i];
                    desc1.accept((OWLObjectVisitor)rv1);
                    RenderingVisitor rv2 = new RenderingVisitor(this.renderer, "X", new HashSet());
                    OWLDescription desc2 = (OWLDescription)eqs[j];
                    desc2.accept((OWLObjectVisitor)rv2);
                    if (i != 0 || j != 1) {
                        this.pw.print(" & ");
                    }
                    this.pw.print("(" + rv1.result() + " <=> " + rv2.result() + ")");
                }
            }
            this.pw.println(")");
        }
    }

    public void visit(OWLDisjointClassesAxiom axiom) throws OWLException {
        this.pw.print("![X]: (");
        Object[] eqs = axiom.getDisjointClasses().toArray();
        for (int i = 0; i < eqs.length; ++i) {
            for (int j = i + 1; j < eqs.length; ++j) {
                RenderingVisitor rv1 = new RenderingVisitor(this.renderer, "X", new HashSet());
                OWLDescription desc1 = (OWLDescription)eqs[i];
                desc1.accept((OWLObjectVisitor)rv1);
                RenderingVisitor rv2 = new RenderingVisitor(this.renderer, "X", new HashSet());
                OWLDescription desc2 = (OWLDescription)eqs[j];
                desc2.accept((OWLObjectVisitor)rv2);
                if (i != 0 || j != 1) {
                    this.pw.print(" & ");
                }
                this.pw.print("~(" + rv1.result() + " & " + rv2.result() + ")");
            }
        }
        this.pw.println(")");
    }

    public void visit(OWLSubClassAxiom axiom) throws OWLException {
        this.pw.print("![X]: ");
        RenderingVisitor rv1 = new RenderingVisitor(this.renderer, "X", new HashSet());
        axiom.getSubClass().accept((OWLObjectVisitor)rv1);
        this.pw.print("(" + rv1.result());
        this.pw.print(" => ");
        RenderingVisitor rv2 = new RenderingVisitor(this.renderer, "X", new HashSet());
        axiom.getSuperClass().accept((OWLObjectVisitor)rv2);
        this.pw.print(rv2.result() + ")");
    }

    public void visit(OWLEquivalentPropertiesAxiom axiom) throws OWLException {
        if (axiom.getProperties().size() > 1) {
            this.pw.print("(");
            Object[] eqs = axiom.getProperties().toArray();
            for (int i = 0; i < eqs.length; ++i) {
                for (int j = i + 1; j < eqs.length; ++j) {
                    if (i != 0 || j != 1) {
                        this.pw.print(" & ");
                    }
                    OWLProperty prop1 = (OWLProperty)eqs[i];
                    OWLProperty prop2 = (OWLProperty)eqs[j];
                    this.pw.print("(![X,Y]: ");
                    this.pw.print("(" + this.renderer.shortForm((OWLNamedObject)prop1) + "(X,Y) <=> ");
                    this.pw.print(this.renderer.shortForm((OWLNamedObject)prop2) + "(X,Y))");
                    this.pw.print(")");
                }
            }
            this.pw.print(")");
        }
    }

    public void visit(OWLSubPropertyAxiom axiom) throws OWLException {
        this.pw.print("![X,Y]: ");
        this.pw.print("(" + this.renderer.shortForm((OWLNamedObject)axiom.getSubProperty()) + "(X,Y) => ");
        this.pw.print(this.renderer.shortForm((OWLNamedObject)axiom.getSuperProperty()) + "(X,Y))");
    }

    public void visit(OWLDifferentIndividualsAxiom ax) throws OWLException {
        this.pw.print("(");
        Object[] diffs = ax.getIndividuals().toArray();
        for (int i = 0; i < diffs.length; ++i) {
            for (int j = i + 1; j < diffs.length; ++j) {
                OWLIndividual ind1 = (OWLIndividual)diffs[i];
                OWLIndividual ind2 = (OWLIndividual)diffs[j];
                if (i != 0 || j != 1) {
                    this.pw.print(" & ");
                }
                this.pw.print("~(equal(" + this.renderer.shortForm((OWLNamedObject)ind1) + "," + this.renderer.shortForm((OWLNamedObject)ind2) + "))");
            }
        }
        this.pw.print(")");
    }

    public void visit(OWLSameIndividualsAxiom ax) throws OWLException {
        this.pw.print("(");
        Object[] diffs = ax.getIndividuals().toArray();
        for (int i = 0; i < diffs.length - 1; ++i) {
            OWLIndividual ind1 = (OWLIndividual)diffs[i];
            OWLIndividual ind2 = (OWLIndividual)diffs[i + 1];
            this.pw.print("(equal(" + this.renderer.shortForm((OWLNamedObject)ind1) + "," + this.renderer.shortForm((OWLNamedObject)ind2) + "))");
            if (i >= diffs.length - 2) continue;
            this.pw.print(" & ");
        }
        this.pw.print(")");
    }

    public void visit(OWLFunctionalPropertyAxiom node) throws OWLException {
    }

    public void visit(OWLInverseFunctionalPropertyAxiom node) throws OWLException {
    }

    public void visit(OWLTransitivePropertyAxiom node) throws OWLException {
    }

    public void visit(OWLSymmetricPropertyAxiom node) throws OWLException {
    }

    public void visit(OWLInversePropertyAxiom node) throws OWLException {
    }

    public void visit(OWLPropertyDomainAxiom node) throws OWLException {
    }

    public void visit(OWLObjectPropertyRangeAxiom node) throws OWLException {
    }

    public void visit(OWLDataPropertyRangeAxiom node) throws OWLException {
    }

    public void visit(OWLObjectPropertyInstance node) throws OWLException {
    }

    public void visit(OWLDataPropertyInstance node) throws OWLException {
    }

    public void visit(OWLIndividualTypeAssertion node) throws OWLException {
    }
}

