/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.io.html;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.BasicConfigurator;
import org.semanticweb.owl.io.ShortFormProvider;
import org.semanticweb.owl.model.OWLAnnotationInstance;
import org.semanticweb.owl.model.OWLAnnotationProperty;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValue;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLIndividualAxiom;
import org.semanticweb.owl.model.OWLNamedObject;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLPropertyAxiom;
import org.semanticweb.owl.model.helper.OntologyHelper;
import uk.ac.man.cs.img.owl.io.html.Linker;
import uk.ac.man.cs.img.owl.io.html.RenderingVisitor;

public class OntologyRenderer
implements ShortFormProvider {
    private List shortNames;
    private Map known;
    private int reservedNames;
    private String[] names = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    private OWLOntology ontology;

    public OntologyRenderer(OWLOntology ontology) {
        this.ontology = ontology;
        this.generateShortNames();
    }

    public void listClasses(PrintWriter pw, Linker linker) throws OWLException {
        this.objectCollection(this.orderedEntities(this.ontology.getClasses()).iterator(), pw, linker);
    }

    public void listObjectProperties(PrintWriter pw, Linker linker) throws OWLException {
        this.objectCollection(this.orderedEntities(this.ontology.getObjectProperties()).iterator(), pw, linker);
    }

    public void listAnnotationProperties(PrintWriter pw, Linker linker) throws OWLException {
        this.objectCollection(this.orderedEntities(this.ontology.getAnnotationProperties()).iterator(), pw, linker);
    }

    public void listDataProperties(PrintWriter pw, Linker linker) throws OWLException {
        this.objectCollection(this.orderedEntities(this.ontology.getDataProperties()).iterator(), pw, linker);
    }

    public void listIndividuals(PrintWriter pw, Linker linker) throws OWLException {
        this.objectCollection(this.orderedEntities(this.ontology.getIndividuals()).iterator(), pw, linker);
    }

    public void renderURI(URI uri, PrintWriter pw, Linker linker) throws OWLException {
        OWLClass clazz = this.ontology.getClass(uri);
        if (clazz != null) {
            this.renderClass(clazz, pw, linker);
            return;
        }
        OWLObjectProperty oprop = this.ontology.getObjectProperty(uri);
        if (oprop != null) {
            this.renderObjectProperty(oprop, pw, linker);
            return;
        }
        OWLDataProperty dprop = this.ontology.getDataProperty(uri);
        if (dprop != null) {
            this.renderDataProperty(dprop, pw, linker);
            return;
        }
        OWLAnnotationProperty aprop = this.ontology.getAnnotationProperty(uri);
        if (aprop != null) {
            this.renderAnnotationProperty(aprop, pw, linker);
            return;
        }
        OWLIndividual ind = this.ontology.getIndividual(uri);
        if (ind != null) {
            this.renderIndividual(ind, pw, linker);
            return;
        }
    }

    public void renderClass(OWLClass clazz, PrintWriter pw, Linker linker) throws OWLException {
        pw.println("<h2>Class: " + linker.linkFor((OWLNamedObject)clazz) + "</h2>");
        if (!clazz.getEquivalentClasses(this.ontology).isEmpty()) {
            pw.println("<h3>Complete Descriptions</h3>");
            this.descriptionCollection(clazz.getEquivalentClasses(this.ontology).iterator(), pw, linker);
        }
        if (!clazz.getSuperClasses(this.ontology).isEmpty()) {
            pw.println("<h3>Super Classes</h3>");
            this.descriptionCollection(clazz.getSuperClasses(this.ontology).iterator(), pw, linker);
        }
        if (!clazz.getEnumerations(this.ontology).isEmpty()) {
            pw.println("<h3>Enumerations</h3>");
            this.descriptionCollection(clazz.getEnumerations(this.ontology).iterator(), pw, linker);
        }
        if (!clazz.getAnnotations(this.ontology).isEmpty()) {
            pw.println("<h3>Annotations</h3>");
            ArrayList<String> l = new ArrayList<String>();
            Iterator it = clazz.getAnnotations(this.ontology).iterator();
            while (it.hasNext()) {
                OWLAnnotationInstance oai = (OWLAnnotationInstance)it.next();
                RenderingVisitor visitor = new RenderingVisitor(linker, this.ontology);
                oai.accept((OWLObjectVisitor)visitor);
                l.add(visitor.result());
            }
            this.collection(l, pw);
        }
        this.displayUsage((OWLEntity)clazz, pw, linker);
    }

    public void renderIndividual(OWLIndividual ind, PrintWriter pw, Linker linker) throws OWLException {
        RenderingVisitor visitor;
        Iterator valIt;
        ArrayList<String> l;
        Set vals;
        OWLObjectProperty prop;
        Iterator<Object> it;
        Map m;
        if (ind.isAnonymous() && !(m = ind.getIncomingObjectPropertyValues(this.ontology)).isEmpty()) {
            return;
        }
        pw.print("<h2>Individual: " + linker.linkFor((OWLNamedObject)ind) + "</h2>");
        if (!ind.getTypes(this.ontology).isEmpty()) {
            pw.println("<h3>Types</h3>");
            this.descriptionCollection(ind.getTypes(this.ontology).iterator(), pw, linker);
        }
        if (!ind.getObjectPropertyValues(this.ontology).keySet().isEmpty()) {
            pw.println("<h3>Values</h3>");
            Map propertyValues = ind.getObjectPropertyValues(this.ontology);
            it = propertyValues.keySet().iterator();
            while (it.hasNext()) {
                pw.println();
                prop = (OWLObjectProperty)it.next();
                vals = (Set)propertyValues.get(prop);
                l = new ArrayList<String>();
                valIt = vals.iterator();
                while (valIt.hasNext()) {
                    OWLIndividual oi = (OWLIndividual)valIt.next();
                    visitor = new RenderingVisitor(linker, this.ontology);
                    oi.accept((OWLObjectVisitor)visitor);
                    l.add("  <span class='keyword'>value</span>(" + linker.linkFor((OWLNamedObject)prop) + " " + visitor.result() + ")");
                }
                this.collection(l, pw);
            }
        }
        if (!ind.getDataPropertyValues(this.ontology).keySet().isEmpty()) {
            pw.println("<h3>Data Values</h3>");
            Map dataValues = ind.getDataPropertyValues(this.ontology);
            it = dataValues.keySet().iterator();
            while (it.hasNext()) {
                pw.println();
                prop = (OWLDataProperty)it.next();
                vals = (Set)dataValues.get(prop);
                l = new ArrayList();
                valIt = vals.iterator();
                while (valIt.hasNext()) {
                    OWLDataValue dtv = (OWLDataValue)valIt.next();
                    visitor = new RenderingVisitor(linker, this.ontology);
                    dtv.accept((OWLObjectVisitor)visitor);
                    l.add("  <span class='keyword'>value</span>(" + linker.linkFor((OWLNamedObject)prop) + " " + visitor.result() + ")");
                }
                this.collection(l, pw);
            }
        }
        if (!ind.getAnnotations(this.ontology).isEmpty()) {
            pw.println("<h3>Annotations</h3>");
            ArrayList<String> l2 = new ArrayList<String>();
            it = ind.getAnnotations(this.ontology).iterator();
            while (it.hasNext()) {
                OWLAnnotationInstance oai = (OWLAnnotationInstance)it.next();
                RenderingVisitor visitor2 = new RenderingVisitor(linker, this.ontology);
                oai.accept((OWLObjectVisitor)visitor2);
                l2.add(visitor2.result());
            }
            this.collection(l2, pw);
        }
        this.displayUsage((OWLEntity)ind, pw, linker);
    }

    public void renderAnnotationProperty(OWLAnnotationProperty prop, PrintWriter pw, Linker linker) throws OWLException {
        pw.println("<h2>Annotation Property: " + linker.linkFor((OWLNamedObject)prop) + "</h2>");
        this.displayUsage((OWLEntity)prop, pw, linker);
    }

    public void renderObjectProperty(OWLObjectProperty prop, PrintWriter pw, Linker linker) throws OWLException {
        pw.print("<h2>ObjectProperty " + linker.linkFor((OWLNamedObject)prop) + "</h2>");
        ArrayList<String> l = new ArrayList<String>();
        if (prop.isTransitive(this.ontology)) {
            l.add(" <span class='keyword'>Transitive</span>");
        }
        if (prop.isFunctional(this.ontology)) {
            l.add(" <span class='keyword'>Functional</span>");
        }
        if (prop.isInverseFunctional(this.ontology)) {
            l.add(" <span class='keyword'>InverseFunctional</span>");
        }
        if (prop.isSymmetric(this.ontology)) {
            l.add(" <span class='keyword'>Symmetric</span>");
        }
        this.collection(l, pw);
        if (!prop.getInverses(this.ontology).isEmpty()) {
            pw.println("<h3>Inverse</h3>");
            this.objectCollection(prop.getInverses(this.ontology).iterator(), pw, linker);
        }
        if (!prop.getSuperProperties(this.ontology).isEmpty()) {
            pw.println("<h3>SuperProperties</h3>");
            this.objectCollection(prop.getSuperProperties(this.ontology).iterator(), pw, linker);
        }
        if (!prop.getDomains(this.ontology).isEmpty()) {
            pw.println("<h3>Domain</h3>");
            this.descriptionCollection(prop.getDomains(this.ontology).iterator(), pw, linker);
        }
        if (!prop.getRanges(this.ontology).isEmpty()) {
            pw.println("<h3>Range</h3>");
            this.descriptionCollection(prop.getRanges(this.ontology).iterator(), pw, linker);
        }
        if (!prop.getAnnotations(this.ontology).isEmpty()) {
            pw.println("<h3>Annotations</h3>");
            l = new ArrayList();
            Iterator it = prop.getAnnotations(this.ontology).iterator();
            while (it.hasNext()) {
                OWLAnnotationInstance oai = (OWLAnnotationInstance)it.next();
                RenderingVisitor visitor = new RenderingVisitor(linker, this.ontology);
                oai.accept((OWLObjectVisitor)visitor);
                l.add(visitor.result());
            }
            this.collection(l, pw);
        }
        this.displayUsage((OWLEntity)prop, pw, linker);
    }

    public void renderDataProperty(OWLDataProperty prop, PrintWriter pw, Linker linker) throws OWLException {
        RenderingVisitor visitor;
        Iterator it;
        pw.print("<h2>DataProperty: " + linker.linkFor((OWLNamedObject)prop) + "</h2>");
        ArrayList<String> l = new ArrayList<String>();
        if (prop.isFunctional(this.ontology)) {
            l.add(" <span class='keyword'>Functional</span>");
        }
        this.collection(l, pw);
        if (!prop.getDomains(this.ontology).isEmpty()) {
            pw.println("<h3>Domain</h3>");
            this.descriptionCollection(prop.getDomains(this.ontology).iterator(), pw, linker);
        }
        if (!prop.getRanges(this.ontology).isEmpty()) {
            pw.println("<h3>Domain</h3>");
            l = new ArrayList();
            it = prop.getRanges(this.ontology).iterator();
            while (it.hasNext()) {
                OWLDataType ran = (OWLDataType)it.next();
                visitor = new RenderingVisitor(linker, this.ontology);
                ran.accept((OWLObjectVisitor)visitor);
                l.add(visitor.result());
            }
            this.collection(l, pw);
        }
        if (!prop.getAnnotations(this.ontology).isEmpty()) {
            pw.println("<h3>Annotations</h3>");
            l = new ArrayList();
            it = prop.getAnnotations(this.ontology).iterator();
            while (it.hasNext()) {
                OWLAnnotationInstance oai = (OWLAnnotationInstance)it.next();
                visitor = new RenderingVisitor(linker, this.ontology);
                oai.accept((OWLObjectVisitor)visitor);
                l.add(visitor.result());
            }
            this.collection(l, pw);
        }
        this.displayUsage((OWLEntity)prop, pw, linker);
    }

    public void renderDataType(OWLDataType datatype, PrintWriter pw, Linker linker) throws OWLException {
        pw.println("<h2>Datatype: " + this.shortForm(datatype.getURI()) + "</h2>");
    }

    public void renderClassAxiom(OWLClassAxiom axiom, PrintWriter pw, Linker linker) throws OWLException {
        RenderingVisitor visitor = new RenderingVisitor(linker, this.ontology);
        axiom.accept((OWLObjectVisitor)visitor);
        pw.println(" " + visitor.result());
    }

    public void renderPropertyAxiom(OWLPropertyAxiom axiom, PrintWriter pw, Linker linker) throws OWLException {
        RenderingVisitor visitor = new RenderingVisitor(linker, this.ontology);
        axiom.accept((OWLObjectVisitor)visitor);
        pw.println(" " + visitor.result());
    }

    public void renderIndividualAxiom(OWLIndividualAxiom axiom, PrintWriter pw, Linker linker) throws OWLException {
        RenderingVisitor visitor = new RenderingVisitor(linker, this.ontology);
        axiom.accept((OWLObjectVisitor)visitor);
        pw.println(" " + visitor.result());
        pw.println("<hr/>");
    }

    public void generateShortNames() {
        Set allURIs = new HashSet();
        try {
            allURIs = OntologyHelper.allURIs((OWLOntology)this.ontology);
        }
        catch (OWLException ex) {
            // empty catch block
        }
        this.shortNames = new ArrayList();
        this.known = new HashMap();
        this.known.put("http://www.w3.org/2002/07/owl#", "owl");
        this.known.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
        this.known.put("http://www.w3.org/2000/01/rdf-schema#", "rdfs");
        this.known.put("http://www.w3.org/2001/XMLSchema#", "xsd");
        Iterator it = allURIs.iterator();
        while (it.hasNext()) {
            try {
                URI uri = (URI)it.next();
                if (uri.getFragment() == null) continue;
                String ssp = new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null).toString();
                if (!ssp.endsWith("#")) {
                    ssp = ssp + "#";
                }
                if (this.known.keySet().contains(ssp) || this.shortNames.contains(ssp)) continue;
                this.shortNames.add(ssp);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
    }

    public void writeShortNames(PrintWriter pw) {
        String ns;
        pw.println("<h2>Namespaces</h2>");
        pw.println("<table>");
        ArrayList l = new ArrayList();
        Iterator it = this.known.keySet().iterator();
        while (it.hasNext()) {
            ns = (String)it.next();
            String shrt = (String)this.known.get(ns);
            pw.println("<tr><td align='right'><b>" + shrt + "</b></td><td><a href=\" + ns + \">&lt;" + ns + "&gt;</a></td></tr>");
        }
        for (int i = 0; i < this.shortNames.size(); ++i) {
            if (i >= this.names.length) continue;
            ns = (String)this.shortNames.get(i);
            pw.println("<tr><td align='right'><b>" + this.names[i] + "</b></td><td><a href=\" + ns + \">&lt;" + ns + "&gt;</a></td></tr>");
        }
    }

    public String header() {
        return "<html><body style='font-family:arial'>";
    }

    public String footer() {
        return "</body></html>";
    }

    public Linker defaultLinker() {
        return new Linker(){

            public String linkFor(OWLNamedObject ono) throws OWLException {
                return "<a href=\"" + ono.getURI() + "\">" + OntologyRenderer.this.shortForm(ono.getURI()) + "</a>";
            }
        };
    }

    public String shortForm(URI uri) {
        if (uri == null) {
            return "_";
        }
        try {
            if (uri.getFragment() == null) {
                return "&lt;" + uri.toString() + "&gt;";
            }
            String ssp = new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null).toString();
            if (!ssp.endsWith("#")) {
                ssp = ssp + "#";
            }
            if (this.known.keySet().contains(ssp)) {
                return (String)this.known.get(ssp) + ":" + uri.getFragment();
            }
            if (this.shortNames.contains(ssp)) {
                if (this.shortNames.indexOf(ssp) < this.names.length) {
                    return this.names[this.shortNames.indexOf(ssp)] + ":" + uri.getFragment();
                }
                return "&lt;" + uri.toString() + "&gt;";
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return uri.toString();
    }

    private SortedSet orderedEntities(Set entities) {
        TreeSet ss = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                try {
                    return ((OWLEntity)o1).getURI().toString().compareTo(((OWLEntity)o2).getURI().toString());
                }
                catch (Exception ex) {
                    return o1.toString().compareTo(o2.toString());
                }
            }
        });
        ss.addAll(entities);
        return ss;
    }

    private void descriptionCollection(Iterator it, PrintWriter pw, Linker linker) throws OWLException {
        ArrayList<String> l = new ArrayList<String>();
        while (it.hasNext()) {
            OWLDescription eq = (OWLDescription)it.next();
            RenderingVisitor visitor = new RenderingVisitor(linker, this.ontology);
            eq.accept((OWLObjectVisitor)visitor);
            l.add(visitor.result());
        }
        this.collection(l, pw);
    }

    private void objectCollection(Iterator it, PrintWriter pw, Linker linker) throws OWLException {
        ArrayList<String> l = new ArrayList<String>();
        while (it.hasNext()) {
            OWLNamedObject eq = (OWLNamedObject)it.next();
            l.add(linker.linkFor(eq));
        }
        this.collection(l, pw);
    }

    private void collection(List l, PrintWriter pw) {
        pw.println("<div class='collection'>");
        Iterator it = l.iterator();
        while (it.hasNext()) {
            pw.println("<span class='item'>");
            pw.println(it.next());
            pw.println("</span>");
        }
        pw.println("</div>");
    }

    private void renderAnnotationContent(Object o, PrintWriter pw) throws OWLException {
        if (o instanceof URI) {
            pw.print(o.toString());
        } else if (o instanceof OWLIndividual) {
            pw.print(((OWLIndividual)o).getURI().toString());
        } else if (o instanceof OWLDataValue) {
            OWLDataValue dv = (OWLDataValue)o;
            pw.print("\"" + dv.getValue() + "\"");
            URI dvdt = dv.getURI();
            String dvlang = dv.getLang();
            if (dvdt != null) {
                pw.print("^^" + dvdt);
            } else if (dvlang != null) {
                pw.print("@" + dvlang);
            }
        } else {
            pw.print(o.toString());
        }
    }

    private void displayUsage(OWLEntity entity, PrintWriter pw, Linker linker) throws OWLException {
        RenderingVisitor visitor;
        OWLObject ooo;
        Iterator it;
        if (!entity.getUsage(this.ontology).isEmpty()) {
            pw.println("<h3>Usage</h3>");
            pw.println("<div class='collection'><span class='item'>");
            it = entity.getUsage(this.ontology).iterator();
            while (it.hasNext()) {
                ooo = (OWLObject)it.next();
                visitor = new RenderingVisitor(linker, this.ontology);
                ooo.accept((OWLObjectVisitor)visitor);
                pw.println(visitor.result());
                if (!it.hasNext()) continue;
                pw.print(", ");
            }
            pw.println();
            pw.println("</span></div>");
        }
        if (!entity.objectsUsed(this.ontology).isEmpty()) {
            pw.println("<h3>Uses</h3>");
            pw.println("<div class='collection'><span>");
            it = entity.objectsUsed(this.ontology).iterator();
            while (it.hasNext()) {
                ooo = (OWLObject)it.next();
                visitor = new RenderingVisitor(linker, this.ontology);
                ooo.accept((OWLObjectVisitor)visitor);
                pw.println(visitor.result());
                if (!it.hasNext()) continue;
                pw.print(", ");
            }
            pw.println();
            pw.println("</span></div");
        }
    }

    public static void main(String[] args) {
        try {
            BasicConfigurator.configure();
            URI uri = new URI(args[0]);
            OWLOntology onto = OntologyHelper.getOntology((URI)uri);
            StringWriter writer = new StringWriter();
            PrintWriter pw = new PrintWriter(writer);
            final OntologyRenderer renderer = new OntologyRenderer(onto);
            pw.println(renderer.header());
            Linker linker = new Linker(){

                public String linkFor(OWLNamedObject ono) throws OWLException {
                    return "<a href=\"" + ono.getURI() + "\">" + renderer.shortForm(ono.getURI()) + "</a>";
                }
            };
            pw.println("<h1>Ontology: " + onto.getURI() + "</h1>");
            pw.println("<table border=\"1\"><tr>");
            pw.println("<td valign=\"top\">");
            renderer.listClasses(pw, linker);
            pw.println("</td>");
            pw.println("<td valign=\"top\">");
            renderer.listObjectProperties(pw, linker);
            pw.println("</td>");
            pw.println("<td valign=\"top\">");
            renderer.listDataProperties(pw, linker);
            pw.println("</td>");
            pw.println("<td valign=\"top\">");
            renderer.listAnnotationProperties(pw, linker);
            pw.println("</td>");
            pw.println("<td valign=\"top\">");
            renderer.listIndividuals(pw, linker);
            pw.println("</td>");
            pw.println("</tr></table>");
            Iterator it = onto.getClasses().iterator();
            while (it.hasNext()) {
                renderer.renderClass((OWLClass)it.next(), pw, linker);
            }
            it = onto.getObjectProperties().iterator();
            while (it.hasNext()) {
                renderer.renderObjectProperty((OWLObjectProperty)it.next(), pw, linker);
            }
            it = onto.getDataProperties().iterator();
            while (it.hasNext()) {
                renderer.renderDataProperty((OWLDataProperty)it.next(), pw, linker);
            }
            it = onto.getIndividuals().iterator();
            while (it.hasNext()) {
                renderer.renderIndividual((OWLIndividual)it.next(), pw, linker);
            }
            pw.println(renderer.footer());
            System.out.println(((Object)writer).toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

