/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.io.factplus;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.log4j.BasicConfigurator;
import org.semanticweb.owl.io.RendererException;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValue;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLIndividualAxiom;
import org.semanticweb.owl.model.OWLNamedObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLPropertyAxiom;
import org.semanticweb.owl.model.helper.OntologyHelper;
import uk.ac.man.cs.img.owl.io.factplus.RenderingVisitor;
import uk.ac.man.cs.img.owl.io.factplus.ShortFormProvider;

public class Renderer
implements org.semanticweb.owl.io.Renderer,
ShortFormProvider {
    private PrintWriter pw;
    private Set allURIs;
    private Set allOntologies;
    private List shortNames;
    private Map known;
    private int reservedNames;
    private RenderingVisitor visitor;
    private String[] names = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    private Random random;
    private SimpleDateFormat sdf;
    private TimeZone gmt;
    private Set definedURIs;
    private Map anonymousIndividuals;
    private boolean doneThing;

    public void setOptions(Map map) {
    }

    public Map getOptions() {
        return null;
    }

    public void renderOntology(OWLOntology ontology, Writer writer) throws RendererException {
        try {
            this.pw = new PrintWriter(writer);
            this.allURIs = OntologyHelper.allURIs((OWLOntology)ontology);
            this.allOntologies = OntologyHelper.importClosure((OWLOntology)ontology);
            this.visitor = new RenderingVisitor(this);
            this.definedURIs = new HashSet();
            this.generateShortNames();
            this.writeShortNames();
            this.sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
            this.gmt = TimeZone.getTimeZone("GMT");
            this.sdf.setTimeZone(this.gmt);
            this.doneThing = false;
            this.random = new Random();
            this.anonymousIndividuals = new HashMap();
            Iterator ontoIt = this.allOntologies.iterator();
            while (ontoIt.hasNext()) {
                OWLOntology onto = (OWLOntology)ontoIt.next();
                this.pw.println(" ;; Ontology: " + onto.getURI());
                this.pw.println();
                this.pw.println(" ;; Classes ");
                this.pw.println();
                Iterator it = this.orderedEntities(onto.getClasses()).iterator();
                while (it.hasNext()) {
                    this.renderClass(onto, (OWLClass)it.next());
                }
                this.pw.println(" ;; Object Properties ");
                it = this.orderedEntities(onto.getObjectProperties()).iterator();
                while (it.hasNext()) {
                    this.renderObjectProperty(onto, (OWLObjectProperty)it.next());
                }
                this.pw.println(" ;; Data Properties ");
                it = this.orderedEntities(onto.getDataProperties()).iterator();
                while (it.hasNext()) {
                    this.renderDataProperty(onto, (OWLDataProperty)it.next());
                }
                this.pw.println(" ;; Individuals ");
                it = this.orderedEntities(onto.getIndividuals()).iterator();
                while (it.hasNext()) {
                    this.renderIndividual(onto, (OWLIndividual)it.next());
                }
                this.pw.println(" ;; Class Axioms ");
                it = this.orderedEntities(onto.getDatatypes()).iterator();
                while (it.hasNext()) {
                    this.renderDataType(onto, (OWLDataType)it.next());
                }
                this.pw.println(" ;;_Datatypes ");
                it = this.orderedEntities(onto.getClassAxioms()).iterator();
                while (it.hasNext()) {
                    this.renderClassAxiom((OWLClassAxiom)it.next());
                }
                this.pw.println(" ;; Property Axioms ");
                it = this.orderedEntities(onto.getPropertyAxioms()).iterator();
                while (it.hasNext()) {
                    this.renderPropertyAxiom((OWLPropertyAxiom)it.next());
                }
                this.pw.println(" ;; Individual Axioms ");
                it = this.orderedEntities(onto.getIndividualAxioms()).iterator();
                while (it.hasNext()) {
                    this.renderIndividualAxiom((OWLIndividualAxiom)it.next());
                }
            }
        }
        catch (OWLException ex) {
            throw new RendererException(ex.getMessage());
        }
    }

    private void renderClass(OWLOntology ontology, OWLClass clazz) throws OWLException {
        OWLDescription eq;
        if (!this.definedURIs.contains(clazz.getURI())) {
            this.pw.println(" (defprimconcept " + this.shortForm((OWLNamedObject)clazz) + ")");
            this.definedURIs.add(clazz.getURI());
        }
        if (this.shortForm((OWLNamedObject)clazz).equals("|owl:Thing|") && !this.doneThing) {
            this.pw.println(" ;; Thing == TOP ");
            this.pw.println(" (equal_c " + this.shortForm((OWLNamedObject)clazz) + " :top)");
            this.doneThing = true;
        }
        if (this.shortForm((OWLNamedObject)clazz).equals("|owl:Nothing|")) {
            this.pw.println(" ;; Nothing == BOTTOM ");
            this.pw.println(" (equal_c " + this.shortForm((OWLNamedObject)clazz) + " :bottom)");
        }
        Iterator it = clazz.getEquivalentClasses(ontology).iterator();
        while (it.hasNext()) {
            eq = (OWLDescription)it.next();
            this.pw.print(" (equal_c " + this.shortForm((OWLNamedObject)clazz));
            this.visitor.reset();
            eq.accept((OWLObjectVisitor)this.visitor);
            this.pw.print("  " + this.visitor.result());
            this.pw.println(" )");
        }
        it = clazz.getSuperClasses(ontology).iterator();
        while (it.hasNext()) {
            eq = (OWLDescription)it.next();
            this.pw.print(" (implies_c " + this.shortForm((OWLNamedObject)clazz));
            this.visitor.reset();
            eq.accept((OWLObjectVisitor)this.visitor);
            this.pw.print("  " + this.visitor.result());
            this.pw.println(" )");
        }
        it = clazz.getEnumerations(ontology).iterator();
        while (it.hasNext()) {
            eq = (OWLDescription)it.next();
            this.pw.print(" (equal_c " + this.shortForm((OWLNamedObject)clazz));
            this.visitor.reset();
            eq.accept((OWLObjectVisitor)this.visitor);
            this.pw.print("  " + this.visitor.result());
            this.pw.println(" )");
        }
        this.pw.println();
    }

    private void renderIndividual(OWLOntology ontology, OWLIndividual ind) throws OWLException {
        if (!this.definedURIs.contains(ind.getURI())) {
            this.pw.println(" (defindividual " + this.shortForm((OWLNamedObject)ind) + ")");
            this.definedURIs.add(ind.getURI());
        }
        if (!(ind.getTypes(ontology).isEmpty() && ind.getObjectPropertyValues(ontology).keySet().isEmpty() && ind.getDataPropertyValues(ontology).keySet().isEmpty())) {
            Iterator it = ind.getTypes(ontology).iterator();
            while (it.hasNext()) {
                this.pw.print(" (instance " + this.shortForm((OWLNamedObject)ind));
                OWLDescription eq = (OWLDescription)it.next();
                this.visitor.reset();
                eq.accept((OWLObjectVisitor)this.visitor);
                this.pw.print(" " + this.visitor.result());
                this.pw.println(")");
            }
            Map propertyValues = ind.getObjectPropertyValues(ontology);
            Iterator it2 = propertyValues.keySet().iterator();
            while (it2.hasNext()) {
                OWLObjectProperty prop = (OWLObjectProperty)it2.next();
                Set vals = (Set)propertyValues.get(prop);
                Iterator valIt = vals.iterator();
                while (valIt.hasNext()) {
                    OWLIndividual oi = (OWLIndividual)valIt.next();
                    this.visitor.reset();
                    oi.accept((OWLObjectVisitor)this.visitor);
                    this.pw.println(" (related " + this.shortForm((OWLNamedObject)ind) + " " + this.shortForm((OWLNamedObject)prop) + " " + this.visitor.result() + ")");
                }
            }
            Map dataValues = ind.getDataPropertyValues(ontology);
            Iterator it3 = dataValues.keySet().iterator();
            while (it3.hasNext()) {
                this.pw.println();
                OWLDataProperty prop = (OWLDataProperty)it3.next();
                Set vals = (Set)dataValues.get(prop);
                Iterator valIt = vals.iterator();
                while (valIt.hasNext()) {
                    OWLDataValue dtv = (OWLDataValue)valIt.next();
                    this.visitor.reset();
                    dtv.accept((OWLObjectVisitor)this.visitor);
                    this.pw.print(";;_DataTypeValue  value(" + this.shortForm((OWLNamedObject)prop) + " " + this.visitor.result() + ")");
                    if (!valIt.hasNext()) continue;
                    this.pw.println();
                }
            }
        }
        this.pw.println();
    }

    private void renderObjectProperty(OWLOntology ontology, OWLObjectProperty prop) throws OWLException {
        OWLDescription dom;
        Iterator it;
        if (!this.definedURIs.contains(prop.getURI())) {
            this.pw.println(" (defprimrole " + this.shortForm((OWLNamedObject)prop) + ")");
            this.definedURIs.add(prop.getURI());
        }
        if (prop.isInverseFunctional(ontology)) {
            this.pw.print(" (functional");
            this.pw.print(" (inv " + this.shortForm((OWLNamedObject)prop) + ")");
            this.pw.println(" )");
        }
        if (!prop.getSuperProperties(ontology).isEmpty()) {
            it = prop.getSuperProperties(ontology).iterator();
            while (it.hasNext()) {
                OWLObjectProperty sup = (OWLObjectProperty)it.next();
                this.pw.print(" (implies_r ");
                this.pw.print(this.shortForm((OWLNamedObject)prop));
                this.pw.print(" ");
                this.pw.print(this.shortForm((OWLNamedObject)sup));
                this.pw.println(")");
            }
        }
        if (prop.isFunctional(ontology)) {
            this.pw.print(" (functional");
            this.pw.print(" " + this.shortForm((OWLNamedObject)prop));
            this.pw.println(" )");
        }
        if (prop.isTransitive(ontology)) {
            this.pw.print(" (transitive");
            this.pw.print(" " + this.shortForm((OWLNamedObject)prop));
            this.pw.println(" )");
        }
        it = prop.getDomains(ontology).iterator();
        while (it.hasNext()) {
            this.pw.println(" ;; Domain " + this.shortForm((OWLNamedObject)prop));
            this.pw.print(" (domain " + this.shortForm((OWLNamedObject)prop) + " ");
            dom = (OWLDescription)it.next();
            this.visitor.reset();
            dom.accept((OWLObjectVisitor)this.visitor);
            this.pw.println(this.visitor.result() + " )");
        }
        it = prop.getRanges(ontology).iterator();
        while (it.hasNext()) {
            this.pw.println(" ;; Range " + this.shortForm((OWLNamedObject)prop));
            this.pw.print(" (range " + this.shortForm((OWLNamedObject)prop) + " ");
            dom = (OWLDescription)it.next();
            this.visitor.reset();
            dom.accept((OWLObjectVisitor)this.visitor);
            this.pw.println(this.visitor.result() + " )");
        }
        if (prop.isSymmetric(ontology)) {
            this.pw.println(" ;; Symmetry ");
            this.pw.println(" (equal_r  " + this.shortForm((OWLNamedObject)prop) + " " + "(inv " + this.shortForm((OWLNamedObject)prop) + " ))");
        }
        it = prop.getInverses(ontology).iterator();
        while (it.hasNext()) {
            this.pw.println(" ;;Inverse " + this.shortForm((OWLNamedObject)prop));
            this.pw.print(" (equal_r  " + this.shortForm((OWLNamedObject)prop) + " " + "(inv ");
            OWLObjectProperty inv = (OWLObjectProperty)it.next();
            this.visitor.reset();
            inv.accept((OWLObjectVisitor)this.visitor);
            this.pw.println(this.visitor.result() + " ))");
        }
        this.pw.println();
    }

    private void renderDataProperty(OWLOntology ontology, OWLDataProperty prop) throws OWLException {
        this.pw.println(" ;; DataProperty " + this.shortForm((OWLNamedObject)prop));
    }

    private void renderDataType(OWLOntology ontology, OWLDataType datatype) throws OWLException {
        this.pw.println(" ;; Datatype(" + datatype.getURI() + ")");
    }

    private void renderClassAxiom(OWLClassAxiom axiom) throws OWLException {
        this.visitor.reset();
        axiom.accept((OWLObjectVisitor)this.visitor);
        this.pw.println(this.visitor.result());
        this.pw.println();
    }

    private void renderPropertyAxiom(OWLPropertyAxiom axiom) throws OWLException {
        this.visitor.reset();
        axiom.accept((OWLObjectVisitor)this.visitor);
        this.pw.println(this.visitor.result());
        this.pw.println();
    }

    private void renderIndividualAxiom(OWLIndividualAxiom axiom) throws OWLException {
        this.visitor.reset();
        axiom.accept((OWLObjectVisitor)this.visitor);
        this.pw.println(this.visitor.result());
        this.pw.println();
    }

    private void generateShortNames() {
        this.shortNames = new ArrayList();
        this.known = new HashMap();
        this.known.put("http://www.w3.org/2002/07/owl#", "owl");
        this.known.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
        this.known.put("http://www.w3.org/2000/01/rdf-schema#", "rdfs");
        this.known.put("http://www.w3.org/2001/XMLSchema#", "xsd");
        Iterator it = this.allURIs.iterator();
        while (it.hasNext()) {
            try {
                URI uri = (URI)it.next();
                if (uri.getFragment() == null) continue;
                String ssp = new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null).toString();
                if (!ssp.endsWith("#")) {
                    ssp = ssp + "#";
                }
                if (this.known.keySet().contains(ssp) || this.shortNames.contains(ssp)) continue;
                this.shortNames.add(ssp);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
    }

    private void writeShortNames() {
        String ns;
        this.pw.println(";; ============= Namespaces ============= ");
        Iterator it = this.known.keySet().iterator();
        while (it.hasNext()) {
            ns = (String)it.next();
            String shrt = (String)this.known.get(ns);
            this.pw.println(";;  " + shrt + "\t= " + ns);
        }
        for (int i = 0; i < this.shortNames.size(); ++i) {
            if (i >= this.names.length) continue;
            ns = (String)this.shortNames.get(i);
            this.pw.println(";;  " + this.names[i] + "\t= " + ns);
        }
        this.pw.println(";; ====================================== ");
    }

    public String shortForm(OWLNamedObject ono) throws OWLException {
        OWLIndividual oi;
        if (ono instanceof OWLIndividual && (oi = (OWLIndividual)ono).isAnonymous()) {
            if (!this.anonymousIndividuals.containsKey(oi)) {
                String newName = "|_" + this.sdf.format(new Date()) + "-" + this.random.nextInt(1000) + "|";
                this.anonymousIndividuals.put(oi, newName);
            }
            return (String)this.anonymousIndividuals.get(oi);
        }
        URI uri = ono.getURI();
        if (uri == null) {
            return "|_|";
        }
        try {
            if (uri.getFragment() == null) {
                return "|" + uri.toString() + "|";
            }
            String ssp = new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null).toString();
            if (!ssp.endsWith("#")) {
                ssp = ssp + "#";
            }
            if (this.known.keySet().contains(ssp)) {
                return "|" + (String)this.known.get(ssp) + ":" + uri.getFragment() + "|";
            }
            if (this.shortNames.contains(ssp)) {
                if (this.shortNames.indexOf(ssp) < this.names.length) {
                    return "|" + this.names[this.shortNames.indexOf(ssp)] + ":" + uri.getFragment() + "|";
                }
                return "|" + uri.toString() + "|";
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return "|" + uri.toString() + "|";
    }

    private SortedSet orderedEntities(Set entities) {
        TreeSet ss = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                try {
                    return ((OWLEntity)o1).getURI().toString().compareTo(((OWLEntity)o2).getURI().toString());
                }
                catch (Exception ex) {
                    return o1.toString().compareTo(o2.toString());
                }
            }
        });
        ss.addAll(entities);
        return ss;
    }

    public static void main(String[] args) {
        try {
            BasicConfigurator.configure();
            URI uri = new URI(args[0]);
            OWLOntology onto = OntologyHelper.getOntology((URI)uri);
            Renderer renderer = new Renderer();
            StringWriter writer = new StringWriter();
            renderer.renderOntology(onto, writer);
            System.out.println(((Object)writer).toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

