/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.io.fact;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.BasicConfigurator;
import org.semanticweb.owl.io.RendererException;
import org.semanticweb.owl.io.ShortFormProvider;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLIndividualAxiom;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLPropertyAxiom;
import org.semanticweb.owl.model.helper.OntologyHelper;
import uk.ac.man.cs.img.owl.io.fact.RenderingVisitor;

public class Renderer
implements org.semanticweb.owl.io.Renderer,
ShortFormProvider {
    private PrintWriter pw;
    private Set allURIs;
    private Set allOntologies;
    private List shortNames;
    private Map known;
    private int reservedNames;
    private RenderingVisitor visitor;
    private String[] names = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};

    public void setOptions(Map map) {
    }

    public Map getOptions() {
        return null;
    }

    public void renderOntology(OWLOntology ontology, Writer writer) throws RendererException {
        try {
            this.pw = new PrintWriter(writer);
            this.allURIs = OntologyHelper.allURIs((OWLOntology)ontology);
            this.allOntologies = OntologyHelper.importClosure((OWLOntology)ontology);
            this.visitor = new RenderingVisitor(this);
            this.generateShortNames();
            this.writeShortNames();
            Iterator ontoIt = this.allOntologies.iterator();
            while (ontoIt.hasNext()) {
                OWLOntology onto = (OWLOntology)ontoIt.next();
                this.pw.println(" ;; Ontology: " + onto.getURI());
                this.pw.println();
                this.pw.println(" ;; Classes ");
                this.pw.println();
                Iterator it = this.orderedEntities(onto.getClasses()).iterator();
                while (it.hasNext()) {
                    this.renderClass(onto, (OWLClass)it.next());
                }
                this.pw.println(" ;; Object Properties ");
                it = this.orderedEntities(onto.getObjectProperties()).iterator();
                while (it.hasNext()) {
                    this.renderObjectProperty(onto, (OWLObjectProperty)it.next());
                }
                this.pw.println(" ;; Data Properties ");
                it = this.orderedEntities(onto.getDataProperties()).iterator();
                while (it.hasNext()) {
                    this.renderDataProperty(onto, (OWLDataProperty)it.next());
                }
                this.pw.println(" ;; Individuals ");
                it = this.orderedEntities(onto.getIndividuals()).iterator();
                while (it.hasNext()) {
                    this.renderIndividual(onto, (OWLIndividual)it.next());
                }
                this.pw.println(" ;; Class Axioms ");
                it = this.orderedEntities(onto.getDatatypes()).iterator();
                while (it.hasNext()) {
                    this.renderDataType(onto, (OWLDataType)it.next());
                }
                this.pw.println(" ;; Datatypes ");
                it = this.orderedEntities(onto.getClassAxioms()).iterator();
                while (it.hasNext()) {
                    this.renderClassAxiom((OWLClassAxiom)it.next());
                }
                this.pw.println(" ;; Property Axioms ");
                it = this.orderedEntities(onto.getPropertyAxioms()).iterator();
                while (it.hasNext()) {
                    this.renderPropertyAxiom((OWLPropertyAxiom)it.next());
                }
                this.pw.println(" ;; Individual Axioms ");
                it = this.orderedEntities(onto.getIndividualAxioms()).iterator();
                while (it.hasNext()) {
                    this.renderIndividualAxiom((OWLIndividualAxiom)it.next());
                }
            }
        }
        catch (OWLException ex) {
            throw new RendererException(ex.getMessage());
        }
    }

    private void renderClass(OWLOntology ontology, OWLClass clazz) throws OWLException {
        OWLDescription eq;
        this.pw.println(" (defprimconcept |" + this.shortForm(clazz.getURI()) + "|)");
        if (this.shortForm(clazz.getURI()).equals("owl:Thing")) {
            this.pw.println(" ;; Thing == TOP ");
            this.pw.println(" (equal_c |" + this.shortForm(clazz.getURI()) + "| :top)");
        }
        if (this.shortForm(clazz.getURI()).equals("owl:Nothing")) {
            this.pw.println(" ;; Nothing == BOTTOM ");
            this.pw.println(" (equal_c |" + this.shortForm(clazz.getURI()) + "| :bottom)");
        }
        Iterator it = clazz.getEquivalentClasses(ontology).iterator();
        while (it.hasNext()) {
            eq = (OWLDescription)it.next();
            this.pw.print(" (equal_c |" + this.shortForm(clazz.getURI()) + "|");
            this.visitor.reset();
            eq.accept((OWLObjectVisitor)this.visitor);
            this.pw.print("  " + this.visitor.result());
            this.pw.println(" )");
        }
        it = clazz.getSuperClasses(ontology).iterator();
        while (it.hasNext()) {
            eq = (OWLDescription)it.next();
            this.pw.print(" (implies_c |" + this.shortForm(clazz.getURI()) + "|");
            this.visitor.reset();
            eq.accept((OWLObjectVisitor)this.visitor);
            this.pw.print("  " + this.visitor.result());
            this.pw.println(" )");
        }
        it = clazz.getEnumerations(ontology).iterator();
        while (it.hasNext()) {
            eq = (OWLDescription)it.next();
            this.pw.print(" (equal_c |" + this.shortForm(clazz.getURI()) + "|");
            this.visitor.reset();
            eq.accept((OWLObjectVisitor)this.visitor);
            this.pw.print("  " + this.visitor.result());
            this.pw.println(" )");
        }
        this.pw.println();
    }

    private void renderIndividual(OWLOntology ontology, OWLIndividual ind) throws OWLException {
        Map m;
        if (ind.isAnonymous() && !(m = ind.getIncomingObjectPropertyValues(ontology)).isEmpty()) {
            return;
        }
        this.pw.println(" (defprimconcept |_I_" + this.shortForm(ind.getURI()) + "|)");
        if (!(ind.getTypes(ontology).isEmpty() && ind.getObjectPropertyValues(ontology).keySet().isEmpty() && ind.getDataPropertyValues(ontology).keySet().isEmpty())) {
            Iterator it = ind.getTypes(ontology).iterator();
            while (it.hasNext()) {
                this.pw.print(" (implies_c |_I_" + this.shortForm(ind.getURI()) + "|");
                OWLDescription eq = (OWLDescription)it.next();
                this.visitor.reset();
                eq.accept((OWLObjectVisitor)this.visitor);
                this.pw.print(" " + this.visitor.result());
                this.pw.println(")");
            }
        }
        this.pw.println();
    }

    private void renderObjectProperty(OWLOntology ontology, OWLObjectProperty prop) throws OWLException {
        Iterator it;
        this.pw.print(" (defprimrole |" + this.shortForm(prop.getURI()) + "|");
        if (prop.isInverseFunctional(ontology)) {
            this.pw.print(" InverseFunctional");
        }
        if (!prop.getSuperProperties(ontology).isEmpty()) {
            this.pw.print(" :supers ( ");
            it = prop.getSuperProperties(ontology).iterator();
            while (it.hasNext()) {
                OWLObjectProperty sup = (OWLObjectProperty)it.next();
                this.visitor.reset();
                sup.accept((OWLObjectVisitor)this.visitor);
                this.pw.print(" ");
            }
            this.pw.print(")");
        }
        this.pw.println(")");
        if (prop.isFunctional(ontology)) {
            this.pw.print(" (functional ");
            this.pw.print(" |" + this.shortForm(prop.getURI()) + "|");
            this.pw.print(" )");
        }
        if (prop.isTransitive(ontology)) {
            this.pw.print(" (transitive ");
            this.pw.print(" |" + this.shortForm(prop.getURI()) + "|");
            this.pw.print(" )");
        }
        it = prop.getDomains(ontology).iterator();
        while (it.hasNext()) {
            this.pw.println(" ;; Domain " + this.shortForm(prop.getURI()));
            this.pw.print(" (implies_c :TOP (all (inv |" + this.shortForm(prop.getURI()) + "|) ");
            OWLDescription dom = (OWLDescription)it.next();
            this.visitor.reset();
            dom.accept((OWLObjectVisitor)this.visitor);
            this.pw.println(this.visitor.result() + " ))");
        }
        it = prop.getRanges(ontology).iterator();
        while (it.hasNext()) {
            this.pw.println(" ;; Range " + this.shortForm(prop.getURI()));
            this.pw.print(" (implies_c :TOP (all |" + this.shortForm(prop.getURI()) + "| ");
            OWLDescription ran = (OWLDescription)it.next();
            this.visitor.reset();
            ran.accept((OWLObjectVisitor)this.visitor);
            this.pw.println(this.visitor.result() + " ))");
        }
        if (prop.isSymmetric(ontology)) {
            this.pw.println(" (equal_r  |" + this.shortForm(prop.getURI()) + "| " + "(inv |" + this.shortForm(prop.getURI()) + "| ))");
        }
        it = prop.getInverses(ontology).iterator();
        while (it.hasNext()) {
            this.pw.println(" ;;Inverse " + this.shortForm(prop.getURI()));
            this.pw.print(" (equal_r  |" + this.shortForm(prop.getURI()) + "| " + "(inv ");
            OWLObjectProperty inv = (OWLObjectProperty)it.next();
            this.visitor.reset();
            inv.accept((OWLObjectVisitor)this.visitor);
            this.pw.println(this.visitor.result() + " ))");
        }
        this.pw.println();
    }

    private void renderDataProperty(OWLOntology ontology, OWLDataProperty prop) throws OWLException {
        this.pw.println(" ;; DataProperty " + this.shortForm(prop.getURI()));
    }

    private void renderDataType(OWLOntology ontology, OWLDataType datatype) throws OWLException {
        this.pw.println(" ;; Datatype(" + this.shortForm(datatype.getURI()) + ")");
    }

    private void renderClassAxiom(OWLClassAxiom axiom) throws OWLException {
        this.visitor.reset();
        axiom.accept((OWLObjectVisitor)this.visitor);
        this.pw.println(this.visitor.result());
        this.pw.println();
    }

    private void renderPropertyAxiom(OWLPropertyAxiom axiom) throws OWLException {
        this.visitor.reset();
        axiom.accept((OWLObjectVisitor)this.visitor);
        this.pw.println(this.visitor.result());
        this.pw.println();
    }

    private void renderIndividualAxiom(OWLIndividualAxiom axiom) throws OWLException {
        this.visitor.reset();
        axiom.accept((OWLObjectVisitor)this.visitor);
        this.pw.println(this.visitor.result());
        this.pw.println();
    }

    private void generateShortNames() {
        this.shortNames = new ArrayList();
        this.known = new HashMap();
        this.known.put("http://www.w3.org/2002/07/owl#", "owl");
        this.known.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
        this.known.put("http://www.w3.org/2000/01/rdf-schema#", "rdfs");
        this.known.put("http://www.w3.org/2001/XMLSchema#", "xsd");
        Iterator it = this.allURIs.iterator();
        while (it.hasNext()) {
            try {
                URI uri = (URI)it.next();
                if (uri.getFragment() == null) continue;
                String ssp = new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null).toString();
                if (!ssp.endsWith("#")) {
                    ssp = ssp + "#";
                }
                if (this.known.keySet().contains(ssp) || this.shortNames.contains(ssp)) continue;
                this.shortNames.add(ssp);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
    }

    private void writeShortNames() {
        String ns;
        this.pw.println(";; ============= Namespaces ============= ");
        Iterator it = this.known.keySet().iterator();
        while (it.hasNext()) {
            ns = (String)it.next();
            String shrt = (String)this.known.get(ns);
            this.pw.println(";;  " + shrt + "\t= " + ns);
        }
        for (int i = 0; i < this.shortNames.size(); ++i) {
            if (i >= this.names.length) continue;
            ns = (String)this.shortNames.get(i);
            this.pw.println(";;  " + this.names[i] + "\t= " + ns);
        }
        this.pw.println(";; ====================================== ");
    }

    public String shortForm(URI uri) {
        if (uri == null) {
            return "_";
        }
        try {
            if (uri.getFragment() == null) {
                return uri.toString();
            }
            String ssp = new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null).toString();
            if (!ssp.endsWith("#")) {
                ssp = ssp + "#";
            }
            if (this.known.keySet().contains(ssp)) {
                return (String)this.known.get(ssp) + ":" + uri.getFragment();
            }
            if (this.shortNames.contains(ssp)) {
                if (this.shortNames.indexOf(ssp) < this.names.length) {
                    return this.names[this.shortNames.indexOf(ssp)] + ":" + uri.getFragment();
                }
                return uri.toString();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return uri.toString();
    }

    private SortedSet orderedEntities(Set entities) {
        TreeSet ss = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                try {
                    return ((OWLEntity)o1).getURI().toString().compareTo(((OWLEntity)o2).getURI().toString());
                }
                catch (Exception ex) {
                    return o1.toString().compareTo(o2.toString());
                }
            }
        });
        ss.addAll(entities);
        return ss;
    }

    public static void main(String[] args) {
        try {
            BasicConfigurator.configure();
            URI uri = new URI(args[0]);
            OWLOntology onto = OntologyHelper.getOntology((URI)uri);
            Renderer renderer = new Renderer();
            StringWriter writer = new StringWriter();
            renderer.renderOntology(onto, writer);
            System.out.println(((Object)writer).toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

