/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.io.dig2_0;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import org.semanticweb.owl.model.OWLAnd;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValue;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLEnumeration;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentPropertiesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLNot;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOr;
import org.semanticweb.owl.model.OWLProperty;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSubPropertyAxiom;
import org.semanticweb.owl.model.helper.OWLObjectVisitorAdapter;
import uk.ac.man.cs.img.owl.io.dig2_0.Renderer;

public class RenderingVisitor
extends OWLObjectVisitorAdapter {
    StringWriter sw;
    PrintWriter pw;
    int level;

    public RenderingVisitor() {
        this.reset();
    }

    public String result() {
        return this.sw.toString();
    }

    public void reset() {
        this.sw = new StringWriter();
        this.pw = new PrintWriter(this.sw);
    }

    public void visit(OWLClass clazz) throws OWLException {
        this.pw.print("<class URI=\"" + Renderer.mapName(clazz.getURI()) + "\"/>");
    }

    public void visit(OWLIndividual ind) throws OWLException {
        if (ind.isAnonymous()) {
            this.pw.print("<individual URI=\"anon-" + ind.hashCode() + "\"/>");
        } else {
            this.pw.print("<individual URI=\"" + Renderer.mapName(ind.getURI()) + "\"/>");
        }
    }

    public void visit(OWLObjectProperty prop) throws OWLException {
        this.pw.print("<objectProperty URI=\"" + Renderer.mapName(prop.getURI()) + "\"/>");
    }

    public void visit(OWLDataProperty prop) throws OWLException {
        this.pw.print("<dataProperty URI=\"" + Renderer.mapName(prop.getURI()) + "\"/>");
    }

    public void visit(OWLDataValue cd) throws OWLException {
        this.pw.print("<dataLiteral>" + cd.getValue() + "</dataLiteral>");
    }

    public void visit(OWLAnd and) throws OWLException {
        this.pw.println("<intersectionOf>");
        Iterator it = and.getOperands().iterator();
        while (it.hasNext()) {
            OWLDescription desc = (OWLDescription)it.next();
            desc.accept((OWLObjectVisitor)this);
            this.pw.println();
        }
        this.pw.print("</intersectionOf>");
    }

    public void visit(OWLOr or) throws OWLException {
        this.pw.println("<unionOf>");
        Iterator it = or.getOperands().iterator();
        while (it.hasNext()) {
            OWLDescription desc = (OWLDescription)it.next();
            desc.accept((OWLObjectVisitor)this);
            this.pw.println();
        }
        this.pw.print("</unionOf>");
    }

    public void visit(OWLNot not) throws OWLException {
        this.pw.println("<complementOf>");
        OWLDescription desc = not.getOperand();
        desc.accept((OWLObjectVisitor)this);
        this.pw.println();
        this.pw.print("</complementOf>");
    }

    public void visit(OWLEnumeration enumeration) throws OWLException {
        this.pw.println("<oneOf>");
        Iterator it = enumeration.getIndividuals().iterator();
        while (it.hasNext()) {
            OWLIndividual desc = (OWLIndividual)it.next();
            desc.accept((OWLObjectVisitor)this);
            this.pw.println();
        }
        this.pw.print("</oneOf>");
    }

    public void visit(OWLObjectSomeRestriction restriction) throws OWLException {
        this.pw.println("<someValuesFrom>");
        restriction.getObjectProperty().accept((OWLObjectVisitor)this);
        this.pw.println();
        restriction.getDescription().accept((OWLObjectVisitor)this);
        this.pw.println();
        this.pw.print("</someValuesFrom>");
    }

    public void visit(OWLObjectAllRestriction restriction) throws OWLException {
        this.pw.println("<allValuesFrom>");
        restriction.getObjectProperty().accept((OWLObjectVisitor)this);
        this.pw.println();
        restriction.getDescription().accept((OWLObjectVisitor)this);
        this.pw.println();
        this.pw.print("</allValuesFrom>");
    }

    public void visit(OWLObjectValueRestriction restriction) throws OWLException {
        this.pw.println("<hasValue>");
        restriction.getObjectProperty().accept((OWLObjectVisitor)this);
        restriction.getIndividual().accept((OWLObjectVisitor)this);
        this.pw.println();
        this.pw.print("</hasValue>");
    }

    public void visit(OWLObjectCardinalityRestriction restriction) throws OWLException {
        if (restriction.isExactly()) {
            this.pw.println("<cardinality num=\"" + restriction.getAtLeast() + "\">");
            restriction.getObjectProperty().accept((OWLObjectVisitor)this);
            this.pw.println();
            this.pw.print("</cardinality>");
        } else if (restriction.isAtMost()) {
            this.pw.println("<maxCardinality num=\"" + restriction.getAtMost() + "\">");
            restriction.getObjectProperty().accept((OWLObjectVisitor)this);
            this.pw.println();
            this.pw.print("</maxCardinality>");
        } else if (restriction.isAtLeast()) {
            this.pw.println("<minCardinality num=\"" + restriction.getAtLeast() + "\">");
            restriction.getObjectProperty().accept((OWLObjectVisitor)this);
            this.pw.println();
            this.pw.print("</minCardinality>");
        }
    }

    public void visit(OWLDataCardinalityRestriction restriction) throws OWLException {
        if (restriction.isExactly()) {
            this.pw.println("<cardinality num=\"" + restriction.getAtLeast() + "\">");
            restriction.getDataProperty().accept((OWLObjectVisitor)this);
            this.pw.println();
            this.pw.print("</cardinality>");
        } else if (restriction.isAtMost()) {
            this.pw.println("<maxCardinality num=\"" + restriction.getAtMost() + "\">");
            restriction.getDataProperty().accept((OWLObjectVisitor)this);
            this.pw.println();
            this.pw.print("</maxCardinality>");
        } else if (restriction.isAtLeast()) {
            this.pw.println("<minCardinality num=\"" + restriction.getAtLeast() + "\">");
            restriction.getDataProperty().accept((OWLObjectVisitor)this);
            this.pw.println();
            this.pw.print("</minCardinality>");
        }
    }

    public void visit(OWLDataSomeRestriction restriction) throws OWLException {
        this.pw.println("<someValuesFrom>");
        restriction.getDataProperty().accept((OWLObjectVisitor)this);
        this.pw.println();
        restriction.getDataType().accept((OWLObjectVisitor)this);
        this.pw.println();
        this.pw.print("</someValuesFrom>");
    }

    public void visit(OWLDataAllRestriction restriction) throws OWLException {
        this.pw.println("<allValuesFrom>");
        restriction.getDataProperty().accept((OWLObjectVisitor)this);
        this.pw.println();
        restriction.getDataType().accept((OWLObjectVisitor)this);
        this.pw.println();
        this.pw.print("</allValuesFrom>");
    }

    public void visit(OWLDataValueRestriction restriction) throws OWLException {
        this.pw.println("<hasValue");
        restriction.getDataProperty().accept((OWLObjectVisitor)this);
        this.pw.println();
        restriction.getValue().accept((OWLObjectVisitor)this);
        this.pw.println();
        this.pw.print("</hasValue>");
    }

    public void visit(OWLEquivalentClassesAxiom axiom) throws OWLException {
        Object[] eqs = axiom.getEquivalentClasses().toArray();
        for (int i = 0; i < eqs.length; ++i) {
            for (int j = i + 1; j < eqs.length; ++j) {
                OWLDescription desc1 = (OWLDescription)eqs[i];
                OWLDescription desc2 = (OWLDescription)eqs[j];
                this.pw.println("<equivalentClass>");
                desc1.accept((OWLObjectVisitor)this);
                this.pw.println();
                desc2.accept((OWLObjectVisitor)this);
                this.pw.println();
                this.pw.println("</equivalentClass>");
            }
        }
    }

    public void visit(OWLDisjointClassesAxiom axiom) throws OWLException {
        Object[] disjs = axiom.getDisjointClasses().toArray();
        for (int i = 0; i < disjs.length; ++i) {
            for (int j = i + 1; j < disjs.length; ++j) {
                OWLDescription desc1 = (OWLDescription)disjs[i];
                OWLDescription desc2 = (OWLDescription)disjs[j];
                this.pw.println("<disjoint>");
                desc1.accept((OWLObjectVisitor)this);
                this.pw.println();
                desc2.accept((OWLObjectVisitor)this);
                this.pw.println();
                this.pw.println("</disjoint>");
            }
        }
    }

    public void visit(OWLSubClassAxiom axiom) throws OWLException {
        this.pw.println("<subClass>");
        axiom.getSubClass().accept((OWLObjectVisitor)this);
        this.pw.println();
        axiom.getSuperClass().accept((OWLObjectVisitor)this);
        this.pw.println();
        this.pw.print("</subClass>");
    }

    public void visit(OWLEquivalentPropertiesAxiom axiom) throws OWLException {
        Object[] eqs = axiom.getProperties().toArray();
        for (int i = 0; i < eqs.length; ++i) {
            for (int j = i + 1; j < eqs.length; ++j) {
                OWLProperty prop1 = (OWLProperty)eqs[i];
                OWLProperty prop2 = (OWLProperty)eqs[j];
                this.pw.println("<equivalenProperty>");
                prop1.accept((OWLObjectVisitor)this);
                this.pw.println();
                prop2.accept((OWLObjectVisitor)this);
                this.pw.println();
                this.pw.println("</equivalentProperty>");
            }
        }
    }

    public void visit(OWLSubPropertyAxiom axiom) throws OWLException {
        this.pw.println("<subProperty>");
        axiom.getSubProperty().accept((OWLObjectVisitor)this);
        this.pw.println();
        axiom.getSuperProperty().accept((OWLObjectVisitor)this);
        this.pw.println();
        this.pw.print("</subProperty>");
    }

    public void visit(OWLDifferentIndividualsAxiom ax) throws OWLException {
        this.pw.println("<different>");
        Iterator it = ax.getIndividuals().iterator();
        while (it.hasNext()) {
            OWLIndividual desc = (OWLIndividual)it.next();
            desc.accept((OWLObjectVisitor)this);
            this.pw.println();
        }
        this.pw.print("</different>");
    }

    public void visit(OWLSameIndividualsAxiom ax) throws OWLException {
        this.pw.println("<same>");
        Iterator it = ax.getIndividuals().iterator();
        while (it.hasNext()) {
            OWLIndividual desc = (OWLIndividual)it.next();
            desc.accept((OWLObjectVisitor)this);
            this.pw.println();
        }
        this.pw.print("</same>");
    }

    public void visit(OWLDataType ocdt) throws OWLException {
        this.pw.print("<datatypeExpression/>");
    }
}

