/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.io.simple;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.io.RendererException;
import org.semanticweb.owl.io.simple.DescriptionRenderer;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLIndividualAxiom;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLPropertyAxiom;

public class Renderer
implements org.semanticweb.owl.io.Renderer {
    private Map options;
    private DescriptionRenderer dr = new DescriptionRenderer();
    private PrintWriter pw;

    public void renderOntology(OWLOntology ontology, Writer writer) throws RendererException {
        try {
            OWLObjectProperty prop;
            this.pw = new PrintWriter(writer);
            this.pw.println("Ontology: " + ontology.getURI().toString());
            this.pw.println("=====================================================");
            this.pw.println("Classes:");
            Iterator it = ontology.getClasses().iterator();
            while (it.hasNext()) {
                OWLClass clazz = (OWLClass)it.next();
                this.renderClass(clazz, ontology);
            }
            this.pw.println();
            this.pw.println("Object Properties:");
            it = ontology.getObjectProperties().iterator();
            while (it.hasNext()) {
                prop = (OWLObjectProperty)it.next();
                this.renderObjectProperty(prop, ontology);
            }
            this.pw.println();
            this.pw.println("Data Properties:");
            it = ontology.getDataProperties().iterator();
            while (it.hasNext()) {
                prop = (OWLDataProperty)it.next();
                this.renderDataProperty((OWLDataProperty)prop, ontology);
            }
            this.pw.println();
            this.pw.println("Individuals:");
            it = ontology.getIndividuals().iterator();
            while (it.hasNext()) {
                OWLIndividual ind = (OWLIndividual)it.next();
                this.renderIndividual(ind, ontology);
            }
            this.pw.println();
            this.pw.println("Axioms:");
            it = ontology.getClassAxioms().iterator();
            while (it.hasNext()) {
                this.renderClassAxiom((OWLClassAxiom)it.next());
            }
        }
        catch (OWLException ex) {
            throw new RendererException(ex.getMessage());
        }
    }

    public void setOptions(Map options) {
    }

    public Map getOptions() {
        return this.options;
    }

    private void renderClass(OWLClass clazz, OWLOntology onto) throws OWLException {
        this.dr.reset();
        clazz.accept((OWLObjectVisitor)this.dr);
        this.pw.println("\t" + this.dr.getContents());
        Iterator cit = clazz.getSuperClasses(onto).iterator();
        while (cit.hasNext()) {
            this.dr.reset();
            ((OWLObject)cit.next()).accept((OWLObjectVisitor)this.dr);
            this.pw.println("\t\t" + this.dr.getContents());
        }
        cit = clazz.getEquivalentClasses(onto).iterator();
        while (cit.hasNext()) {
            this.pw.print("\t\t");
            this.dr.reset();
            ((OWLObject)cit.next()).accept((OWLObjectVisitor)this.dr);
            this.pw.println("\t\t" + this.dr.getContents());
        }
        cit = clazz.getEnumerations(onto).iterator();
        while (cit.hasNext()) {
            this.pw.print("\t\t");
            this.dr.reset();
            ((OWLObject)cit.next()).accept((OWLObjectVisitor)this.dr);
            this.pw.println("\t\t" + this.dr.getContents());
        }
    }

    private void renderObjectProperty(OWLObjectProperty oprop, OWLOntology onto) throws OWLException {
        this.dr.reset();
        oprop.accept((OWLObjectVisitor)this.dr);
        this.pw.println("\t" + this.dr.getContents());
    }

    private void renderDataProperty(OWLDataProperty dprop, OWLOntology onto) throws OWLException {
        this.dr.reset();
        dprop.accept((OWLObjectVisitor)this.dr);
        this.pw.println("\t" + this.dr.getContents());
    }

    private void renderIndividual(OWLIndividual individual, OWLOntology onto) throws OWLException {
        this.dr.reset();
        individual.accept((OWLObjectVisitor)this.dr);
        this.pw.println("\t" + this.dr.getContents());
        Iterator<Object> cit = individual.getTypes(onto).iterator();
        while (cit.hasNext()) {
            this.dr.reset();
            ((OWLObject)cit.next()).accept((OWLObjectVisitor)this.dr);
            this.pw.println("\t\t" + this.dr.getContents());
        }
        cit = individual.getObjectPropertyValues(onto).keySet().iterator();
        while (cit.hasNext()) {
            OWLObject k = (OWLObject)cit.next();
            this.dr.reset();
            k.accept((OWLObjectVisitor)this.dr);
            this.pw.println("\t\t" + this.dr.getContents());
            Iterator vit = ((Set)individual.getObjectPropertyValues(onto).get(k)).iterator();
            while (vit.hasNext()) {
                OWLObject v = (OWLObject)vit.next();
                this.dr.reset();
                v.accept((OWLObjectVisitor)this.dr);
                this.pw.println("\t\t\t" + this.dr.getContents());
            }
        }
    }

    private void renderClassAxiom(OWLClassAxiom axiom) throws OWLException {
        this.dr.reset();
        axiom.accept((OWLObjectVisitor)this.dr);
        this.pw.println("\t" + this.dr.getContents());
    }

    private void renderPropertyAxiom(OWLPropertyAxiom axiom) throws OWLException {
    }

    private void renderIndiviualAxiom(OWLIndividualAxiom axiom) throws OWLException {
    }
}

