/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.io.simple;

import java.io.StringWriter;
import java.util.Iterator;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyInstance;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLFunctionalPropertyAxiom;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLIndividualTypeAssertion;
import org.semanticweb.owl.model.OWLInverseFunctionalPropertyAxiom;
import org.semanticweb.owl.model.OWLInversePropertyAxiom;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyInstance;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitivePropertyAxiom;
import org.semanticweb.owl.model.helper.OWLObjectVisitorAdapter;

public class DescriptionRenderer
extends OWLObjectVisitorAdapter {
    private StringWriter sw;

    public void reset() {
        this.sw = new StringWriter();
    }

    public String getContents() {
        return this.sw.toString();
    }

    public void visit(OWLClass node) throws OWLException {
        this.sw.write(node.getURI().toString());
    }

    public void visit(OWLIndividual node) throws OWLException {
        if (node.isAnonymous()) {
            this.sw.write("??");
        } else {
            this.sw.write(node.getURI().toString());
        }
    }

    public void visit(OWLObjectProperty node) throws OWLException {
        this.sw.write(node.getURI().toString());
    }

    public void visit(OWLDataProperty node) throws OWLException {
        this.sw.write(node.getURI().toString());
    }

    public void visit(OWLSubClassAxiom node) throws OWLException {
        node.getSubClass().accept((OWLObjectVisitor)this);
        this.sw.write(" -> ");
        node.getSuperClass().accept((OWLObjectVisitor)this);
    }

    public void visit(OWLEquivalentClassesAxiom node) throws OWLException {
        this.sw.write("(");
        Iterator it = node.getEquivalentClasses().iterator();
        while (it.hasNext()) {
            OWLObject o = (OWLObject)it.next();
            o.accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.sw.write(" == ");
        }
        this.sw.write(")");
    }

    public void visit(OWLDisjointClassesAxiom node) throws OWLException {
        this.sw.write("(");
        Iterator it = node.getDisjointClasses().iterator();
        while (it.hasNext()) {
            OWLObject o = (OWLObject)it.next();
            o.accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.sw.write(" || ");
        }
        this.sw.write(")");
    }

    public void visit(OWLFunctionalPropertyAxiom node) throws OWLException {
    }

    public void visit(OWLInverseFunctionalPropertyAxiom node) throws OWLException {
    }

    public void visit(OWLTransitivePropertyAxiom node) throws OWLException {
    }

    public void visit(OWLSymmetricPropertyAxiom node) throws OWLException {
    }

    public void visit(OWLInversePropertyAxiom node) throws OWLException {
    }

    public void visit(OWLPropertyDomainAxiom node) throws OWLException {
    }

    public void visit(OWLObjectPropertyRangeAxiom node) throws OWLException {
    }

    public void visit(OWLDataPropertyRangeAxiom node) throws OWLException {
    }

    public void visit(OWLObjectPropertyInstance node) throws OWLException {
    }

    public void visit(OWLDataPropertyInstance node) throws OWLException {
    }

    public void visit(OWLIndividualTypeAssertion node) throws OWLException {
    }
}

