/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.io.abstract_syntax;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.semanticweb.owl.io.RendererException;
import org.semanticweb.owl.io.ShortFormProvider;
import org.semanticweb.owl.io.abstract_syntax.RenderingVisitor;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;

public class ObjectRenderer
implements ShortFormProvider {
    private PrintWriter pw;
    private Set allURIs;
    private List shortNames;
    private Map known;
    private int reservedNames;
    private RenderingVisitor visitor;
    private String[] names = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};

    public ObjectRenderer(OWLOntology ontology) {
        this.visitor = new RenderingVisitor(this, ontology);
        this.generateShortNames();
    }

    public String renderObject(OWLObject obj) throws RendererException {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.visitor.reset();
            obj.accept((OWLObjectVisitor)this.visitor);
            return this.visitor.result();
        }
        catch (OWLException ex) {
            throw new RendererException(ex.getMessage());
        }
    }

    private void generateShortNames() {
        this.shortNames = new ArrayList();
        this.known = new HashMap();
        this.known.put("http://www.w3.org/2002/07/owl#", "owl");
        this.known.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
        this.known.put("http://www.w3.org/2000/01/rdf-schema#", "rdfs");
    }

    public String shortForm(URI uri) {
        try {
            if (uri.getFragment() == null) {
                return uri.toString();
            }
            String ssp = new URI(uri.getScheme(), uri.getSchemeSpecificPart(), null).toString();
            if (!ssp.endsWith("#")) {
                ssp = ssp + "#";
            }
            if (this.known.keySet().contains(ssp)) {
                return (String)this.known.get(ssp) + ":" + uri.getFragment();
            }
            if (this.shortNames.contains(ssp)) {
                return this.names[this.shortNames.indexOf(ssp)] + ":" + uri.getFragment();
            }
            this.shortNames.add(ssp);
            if (this.shortNames.indexOf(ssp) >= this.names.length) {
                return uri.toString();
            }
            return this.names[this.shortNames.indexOf(ssp)] + ":" + uri.getFragment();
        }
        catch (URISyntaxException uRISyntaxException) {
            return uri.toString();
        }
    }

    private SortedSet orderedEntities(Set entities) {
        TreeSet ss = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                try {
                    return ((OWLEntity)o1).getURI().toString().compareTo(((OWLEntity)o2).getURI().toString());
                }
                catch (Exception ex) {
                    return o1.toString().compareTo(o2.toString());
                }
            }
        });
        ss.addAll(entities);
        return ss;
    }
}

