/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss.expt;

import com.wcohen.cls.BinaryExample;
import com.wcohen.cls.ClassLabel;
import com.wcohen.cls.Example;
import com.wcohen.cls.Instance;
import com.wcohen.cls.MutableInstance;
import com.wcohen.cls.expt.CrossValSplitter;
import com.wcohen.cls.expt.Evaluation;
import com.wcohen.ss.AdaptiveStringDistanceLearner;
import com.wcohen.ss.BasicDistanceInstanceIterator;
import com.wcohen.ss.DistanceLearnerFactory;
import com.wcohen.ss.PrintfFormat;
import com.wcohen.ss.api.StringDistance;
import com.wcohen.ss.api.StringDistanceLearner;
import com.wcohen.ss.expt.BasicTeacher;
import com.wcohen.ss.expt.Blocker;
import com.wcohen.ss.expt.MatchData;
import com.wcohen.ss.expt.NullBlocker;
import com.wcohen.util.ProgressCounter;
import com.wcohen.util.gui.ComponentViewer;
import com.wcohen.util.gui.ParallelViewer;
import com.wcohen.util.gui.TransformedViewer;
import com.wcohen.util.gui.Viewer;
import com.wcohen.util.gui.Visible;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class MatchExpt
implements Serializable,
Visible {
    public static final String BLOCKER_PACKAGE = "com.wcohen.ss.expt.";
    public static final String DISTANCE_PACKAGE = "com.wcohen.ss.";
    private static final long serialVersionUID = 1L;
    private static int CURRENT_SERIALIZED_VERSION_NUMBER = 1;
    private Blocker.Pair[] pairs;
    private int numCorrectPairs;
    private double learningTime;
    private double blockingTime;
    private double matchingTime;
    private double sortingTime;
    private String fileName;
    private String learnerName;
    private String blockerName;
    private static double[] elevenPoints = new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};

    public MatchExpt(MatchData data, StringDistanceLearner learner, Blocker blocker) {
        if (learner instanceof AdaptiveStringDistanceLearner) {
            this.setUpAdaptiveExperiment(data, learner, blocker);
        } else {
            this.setUpFixedExperiment(data, learner, blocker);
        }
        this.fileName = data.getFilename();
        this.learnerName = learner.toString();
        this.blockerName = blocker.toString();
    }

    public MatchExpt(MatchData data, StringDistanceLearner learner) {
        this(data, learner, new NullBlocker());
    }

    public String toString() {
        return "[MatchExpt: " + this.fileName + "," + this.learnerName + "," + this.blockerName + "]";
    }

    private void setUpAdaptiveExperiment(MatchData data, StringDistanceLearner learner, Blocker blocker) {
        System.out.println("setting up expt: " + learner + " " + blocker + " file: " + data.getFilename());
        long startTime = System.currentTimeMillis();
        blocker.block(data);
        this.blockingTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        ArrayList<Blocker.Pair> list = new ArrayList<Blocker.Pair>(blocker.size());
        for (int i = 0; i < blocker.size(); ++i) {
            list.add(blocker.getPair(i));
        }
        CrossValSplitter splitter = new CrossValSplitter(3);
        splitter.split(list.iterator());
        this.learningTime = 0.0;
        this.pairs = new Blocker.Pair[blocker.size()];
        this.numCorrectPairs = blocker.numCorrectPairs();
        int pairCursor = 0;
        for (int k = 0; k < splitter.getNumPartitions(); ++k) {
            BasicTeacher teacher = new BasicTeacher(data.getIterator(), new BasicDistanceInstanceIterator(Collections.EMPTY_SET.iterator()), new BasicDistanceInstanceIterator(splitter.getTrain(k)));
            startTime = System.currentTimeMillis();
            StringDistance dist = teacher.train(learner);
            this.learningTime += (double)(System.currentTimeMillis() - startTime) / 1000.0;
            System.out.println("fold " + k + " distance is '" + dist + "'");
            startTime = System.currentTimeMillis();
            Iterator j = splitter.getTest(k);
            while (j.hasNext()) {
                Blocker.Pair pair;
                this.pairs[pairCursor] = pair = (Blocker.Pair)j.next();
                this.pairs[pairCursor].setDistance(dist.score(this.pairs[pairCursor].getA(), this.pairs[pairCursor].getB()));
                ++pairCursor;
            }
            this.matchingTime += (double)(System.currentTimeMillis() - startTime) / 1000.0;
        }
        Arrays.sort(this.pairs);
    }

    private void setUpFixedExperiment(MatchData data, StringDistanceLearner learner, Blocker blocker) {
        System.out.println("setting up expt: " + learner + " " + blocker + " file: " + data.getFilename());
        BasicTeacher teacher = new BasicTeacher(blocker, data);
        long startTime = System.currentTimeMillis();
        StringDistance dist = teacher.train(learner);
        this.learningTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        System.out.println("distance is '" + dist + "'");
        startTime = System.currentTimeMillis();
        blocker.block(data);
        this.blockingTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        this.numCorrectPairs = blocker.numCorrectPairs();
        this.pairs = new Blocker.Pair[blocker.size()];
        startTime = System.currentTimeMillis();
        System.out.println("Pairs: " + this.pairs.length + " Correct: " + blocker.numCorrectPairs());
        ProgressCounter pc = new ProgressCounter("computing distances", "proposed pair", blocker.size());
        for (int i = 0; i < blocker.size(); ++i) {
            this.pairs[i] = blocker.getPair(i);
            this.pairs[i].setDistance(dist.score(this.pairs[i].getA(), this.pairs[i].getB()));
            pc.progress();
        }
        pc.finished();
        this.matchingTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        startTime = System.currentTimeMillis();
        Arrays.sort(this.pairs);
        this.sortingTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        System.out.println("Matching time: " + this.matchingTime);
    }

    public Double time() {
        return new Double(this.learningTime + this.blockingTime + this.matchingTime + this.sortingTime);
    }

    public Double pairsPerSecond() {
        return new Double((double)this.pairs.length / (this.learningTime + this.blockingTime + this.matchingTime + this.sortingTime));
    }

    public Double averagePrecision() {
        double n = 0.0;
        double sumPrecision = 0.0;
        for (int i = 0; i < this.pairs.length; ++i) {
            if (!this.correctPair(i)) continue;
            double precisionAtRankI = (n += 1.0) / ((double)i + 1.0);
            sumPrecision += precisionAtRankI;
        }
        return new Double(sumPrecision / (double)this.numCorrectPairs);
    }

    public Double maxF1() {
        double maxF1 = -1.7976931348623157E308;
        double n = 0.0;
        for (int i = 0; i < this.pairs.length; ++i) {
            if (!this.correctPair(i)) continue;
            double precisionAtRankI = (n += 1.0) / ((double)i + 1.0);
            double recallAtRankI = n / (double)this.numCorrectPairs;
            if (!(precisionAtRankI > 0.0) || !(recallAtRankI > 0.0)) continue;
            double f1 = 2.0 * (precisionAtRankI * recallAtRankI) / (precisionAtRankI + recallAtRankI);
            maxF1 = Math.max(f1, maxF1);
        }
        return new Double(maxF1);
    }

    public Double blockerRecall() {
        double n = 0.0;
        for (int i = 0; i < this.pairs.length; ++i) {
            if (!this.correctPair(i)) continue;
            n += 1.0;
        }
        return new Double(n / (double)this.numCorrectPairs);
    }

    public static double[] interpolated11PointRecallLevels() {
        return elevenPoints;
    }

    public double[] interpolated11PointPrecision() {
        double[] interpolatedPrecision = new double[11];
        int numCorrectAtRankI = 0;
        for (int i = 0; i < this.pairs.length; ++i) {
            if (this.correctPair(i)) {
                ++numCorrectAtRankI;
            }
            double recall = (double)numCorrectAtRankI / (double)this.numCorrectPairs;
            double precision = (double)numCorrectAtRankI / ((double)i + 1.0);
            for (int j = 0; j < elevenPoints.length; ++j) {
                if (!(recall >= elevenPoints[j])) continue;
                interpolatedPrecision[j] = Math.max(interpolatedPrecision[j], precision);
            }
        }
        return interpolatedPrecision;
    }

    public void graphPrecisionRecall(PrintStream out) throws IOException {
        int i;
        double[] interpolatedPrecision = new double[this.pairs.length];
        double n = this.numCorrectPairs;
        double maxPrecision = n / (double)this.pairs.length;
        for (i = this.pairs.length - 1; i >= 0; --i) {
            if (!this.correctPair(i)) continue;
            interpolatedPrecision[i] = maxPrecision;
            maxPrecision = Math.max(maxPrecision, (n -= 1.0) / (double)(i + 1));
        }
        n = 0.0;
        for (i = 0; i < this.pairs.length; ++i) {
            if (!this.correctPair(i)) continue;
            double recallAtRankI = (n += 1.0) / (double)this.numCorrectPairs;
            out.println(recallAtRankI + "\t" + interpolatedPrecision[i]);
        }
    }

    public void displayResults(boolean showMismatches, PrintStream out) throws IOException {
        PrintfFormat fmt = new PrintfFormat("%s %3d %7.2f | %30s | %30s\n");
        for (int i = 0; i < this.pairs.length; ++i) {
            String bText;
            if (this.pairs[i] == null) continue;
            String label = this.pairs[i].isCorrect() ? "+" : "-";
            String aText = this.pairs[i].getA() == null ? "***" : this.pairs[i].getA().unwrap();
            String string = bText = this.pairs[i].getB() == null ? "***" : this.pairs[i].getB().unwrap();
            if (!showMismatches && !"+".equals(label)) continue;
            out.print(fmt.sprintf(new Object[]{label, new Integer(i + 1), new Double(this.pairs[i].getDistance()), aText, bText}));
        }
    }

    public Viewer toGUI() {
        Evaluation e = this.toEvaluation();
        TransformedViewer main = new TransformedViewer(e.toGUI()){

            public Object transform(Object obj) {
                MatchExpt me = (MatchExpt)obj;
                return me.toEvaluation();
            }
        };
        main.setContent((Object)this);
        return main;
    }

    private boolean correctPair(int i) {
        return this.pairs[i] != null && this.pairs[i].isCorrect();
    }

    public Evaluation toEvaluation() {
        ProgressCounter pc = new ProgressCounter("computing statistics", "distance", this.pairs.length);
        MatchExptEvaluation evaluation = new MatchExptEvaluation(this.pairs, this.numCorrectPairs);
        for (int i = 0; i < this.pairs.length; ++i) {
            ClassLabel predicted = ClassLabel.negativeLabel((double)this.pairs[i].getDistance());
            ClassLabel actual = this.pairs[i].isCorrect() ? ClassLabel.positiveLabel((double)1.0) : ClassLabel.negativeLabel((double)-1.0);
            BinaryExample example = new BinaryExample((Instance)new MutableInstance((Object)this.pairs[i]), actual);
            evaluation.extend(predicted, (Example)example);
            pc.progress();
        }
        pc.finished();
        evaluation.setProperty("Blocker", this.blockerName);
        evaluation.setProperty("Distance", this.learnerName);
        evaluation.setProperty("File", this.fileName);
        return evaluation;
    }

    public static void main(String[] argv) {
        try {
            Blocker blocker = (Blocker)Class.forName(BLOCKER_PACKAGE + argv[0]).newInstance();
            StringDistanceLearner learner = DistanceLearnerFactory.build(argv[1]);
            MatchData data = new MatchData(argv[2]);
            MatchExpt expt = new MatchExpt(data, learner, blocker);
            int i = 3;
            while (i < argv.length) {
                String c;
                if ((c = argv[i++]).equals("-display")) {
                    expt.displayResults(true, System.out);
                    continue;
                }
                if (c.equals("-shortDisplay")) {
                    expt.displayResults(false, System.out);
                    continue;
                }
                if (c.equals("-graph")) {
                    expt.graphPrecisionRecall(System.out);
                    continue;
                }
                if (c.equals("-summarize")) {
                    System.out.println("maxF1:\t" + expt.maxF1());
                    System.out.println("avgPrec:\t" + expt.averagePrecision());
                    continue;
                }
                throw new RuntimeException("illegal command " + c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\nusage: <blocker> <distanceClass> <matchDataFile> [commands]\n");
        }
    }

    private static class MatchExptEvaluation
    extends Evaluation {
        private transient Blocker.Pair[] pairs;
        private transient int numCorrectPairs;

        public MatchExptEvaluation(Blocker.Pair[] pairs, int numCorrectPairs) {
            this.pairs = pairs;
            this.numCorrectPairs = numCorrectPairs;
        }

        public Viewer toGUI() {
            ParallelViewer evalViewer = new ParallelViewer();
            evalViewer.addSubView("Summary", (Viewer)new Evaluation.SummaryViewer());
            evalViewer.addSubView("Properties", (Viewer)new Evaluation.PropertyViewer());
            evalViewer.addSubView("11Pt Precision/Recall", (Viewer)new Evaluation.ElevenPointPrecisionViewer());
            evalViewer.addSubView("Details", (Viewer)new ComponentViewer(){

                public JComponent componentFor(Object o) {
                    MatchExptEvaluation e = (MatchExptEvaluation)((Object)o);
                    Object[][] tableData = new Object[MatchExptEvaluation.this.numCorrectPairs + 1][5];
                    int row = 0;
                    PrintfFormat fmt = new PrintfFormat("%7.2f");
                    for (int i = 0; i < MatchExptEvaluation.this.pairs.length; ++i) {
                        if (MatchExptEvaluation.this.pairs[i] == null) continue;
                        tableData[row][0] = new Integer(i);
                        tableData[row][1] = MatchExptEvaluation.this.pairs[i].isCorrect() ? "+" : "-";
                        tableData[row][2] = fmt.sprintf(MatchExptEvaluation.this.pairs[i].getDistance());
                        tableData[row][3] = MatchExptEvaluation.this.pairs[i].getA() == null ? "***" : MatchExptEvaluation.this.pairs[i].getA().unwrap();
                        Object object = tableData[row][4] = MatchExptEvaluation.this.pairs[i].getB() == null ? "***" : MatchExptEvaluation.this.pairs[i].getB().unwrap();
                        if (!MatchExptEvaluation.this.pairs[i].isCorrect()) continue;
                        ++row;
                    }
                    Object[] headers = new String[]{"rank", "", "score", "String A", "String B"};
                    JScrollPane scroller = new JScrollPane(new JTable(tableData, headers));
                    scroller.setHorizontalScrollBarPolicy(30);
                    return scroller;
                }
            });
            evalViewer.setContent((Object)this);
            return evalViewer;
        }
    }
}

