/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss;

import com.wcohen.cls.BinaryClassifier;
import com.wcohen.cls.BinaryClassifierLearner;
import com.wcohen.cls.BinaryExample;
import com.wcohen.cls.Example;
import com.wcohen.cls.Feature;
import com.wcohen.cls.Instance;
import com.wcohen.cls.MutableInstance;
import com.wcohen.cls.linear.NaiveBayes;
import com.wcohen.ss.CombinedStringDistanceLearner;
import com.wcohen.ss.MultiStringWrapper;
import com.wcohen.ss.api.DistanceInstance;
import com.wcohen.ss.api.StringDistance;
import com.wcohen.ss.api.StringDistanceLearner;
import com.wcohen.ss.api.StringWrapper;
import java.util.Iterator;

public class AdaptiveStringDistanceLearner
extends CombinedStringDistanceLearner {
    private MultiStringWrapper prototype = null;
    private BinaryClassifierLearner comboLearner = null;
    private Iterator distanceInstanceIterator = null;

    public AdaptiveStringDistanceLearner() {
        this.comboLearner = new NaiveBayes();
    }

    public AdaptiveStringDistanceLearner(BinaryClassifierLearner comboLearner) {
        this.comboLearner = comboLearner;
    }

    public AdaptiveStringDistanceLearner(StringDistanceLearner[] innerLearners, String delim, BinaryClassifierLearner comboLearner) {
        super(innerLearners, delim);
        this.comboLearner = comboLearner;
    }

    protected void comboSetStringWrapperPool(Iterator it) {
        if (it.hasNext()) {
            this.prototype = this.asMultiStringWrapper((StringWrapper)it.next());
        }
    }

    protected void comboSetDistanceInstancePool(Iterator it) {
        this.distanceInstanceIterator = it;
    }

    protected boolean comboHasNextQuery() {
        return false;
    }

    protected DistanceInstance comboNextQuery() {
        return null;
    }

    protected void comboAddExample(DistanceInstance distanceInstance) {
        CombinedStringDistanceLearner.MyMultiDistanceInstance di = (CombinedStringDistanceLearner.MyMultiDistanceInstance)distanceInstance;
        MutableInstance instance = new MutableInstance((Object)di);
        StringDistance[] innerDistances = this.getInnerDistances();
        for (int i = 0; i < this.prototype.size(); ++i) {
            StringWrapper a = di.getA(i);
            StringWrapper b = di.getB(i);
            int j = this.prototype.getDistanceLearnerIndex(i);
            Feature ithFeature = Feature.Factory.getFeature((String[])new String[]{"dist#" + j, "field#" + this.prototype.getFieldIndex(i)});
            double ithScore = innerDistances[j].score(a, b);
            instance.addNumeric(ithFeature, ithScore);
        }
        double label = di.isCorrect() ? 1.0 : -1.0;
        this.comboLearner.addExample((Example)new BinaryExample((Instance)instance, label));
    }

    public StringDistance getDistance() {
        if (this.prototype == null) {
            throw new IllegalStateException("need to be trained first");
        }
        return new ClassifiedStringDistance(this.getInnerDistances(), this.prototype, this.comboLearner.getBinaryClassifier());
    }

    private class ClassifiedStringDistance
    extends CombinedStringDistanceLearner.CombinedStringDistance {
        private BinaryClassifier classifier;

        public ClassifiedStringDistance(StringDistance[] innerDistances, MultiStringWrapper prototype, BinaryClassifier classifier) {
            super(AdaptiveStringDistanceLearner.this, innerDistances, prototype);
            this.classifier = classifier;
        }

        protected double doScore(MultiStringWrapper ms, MultiStringWrapper mt) {
            return this.classifier.score(this.asComboInstance(ms, mt));
        }

        public String explainCombination(MultiStringWrapper ms, MultiStringWrapper mt) {
            StringBuffer buf = new StringBuffer();
            buf.append("Classifier: " + this.classifier);
            buf.append("Classifier score: " + this.classifier.explain(this.asComboInstance(ms, mt)));
            return buf.toString();
        }

        private Instance asComboInstance(MultiStringWrapper ms, MultiStringWrapper mt) {
            MutableInstance instance = new MutableInstance((Object)(ms.unwrap() + " ~ " + mt.unwrap()));
            for (int i = 0; i < ms.size(); ++i) {
                StringWrapper a = ms.get(i);
                StringWrapper b = mt.get(i);
                int j = this.prototype.getDistanceLearnerIndex(i);
                Feature ithFeature = Feature.Factory.getFeature((String[])new String[]{"dist#" + j, "field#" + this.prototype.getFieldIndex(i)});
                double ithScore = this.innerDistances[j].score(a, b);
                instance.addNumeric(ithFeature, ithScore);
            }
            return instance;
        }

        public String toString() {
            return "[ClassifiedStringDistance: " + this.classifier + ";" + this.innerDistanceString() + "]";
        }
    }
}

